/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxitemlibrary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxItemTypeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final int MAX_CREATED_LEVEL = 9;
    private static final String REGEXP = ".*\\.+.*";
    private static final Pattern pattern = Pattern.compile(".*\\.+.*");
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_PARENT = "parent";
    private static final String KEY_COUNTRYTYPE = "countrytype";
    private static final String FIELD_COUNTRYTYPE_GENERAL = "0";
    private static final String FIELD_COUNTRYTYPE_ASSIGN = "1";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CANCEL = "btncancel";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit parentBE = (BasedataEdit)this.getControl(KEY_PARENT);
        parentBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_CANCEL});
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            String currentNodeId = (String)formShowParameter.getCustomParam("id");
            String countryId = (String)formShowParameter.getCustomParam("countryId");
            if ("999".equals(countryId) || null == countryId) {
                this.getModel().setValue(KEY_COUNTRYTYPE, (Object)FIELD_COUNTRYTYPE_GENERAL);
            } else {
                this.getModel().setValue(KEY_COUNTRYTYPE, (Object)FIELD_COUNTRYTYPE_ASSIGN);
            }
            this.getModel().setValue(KEY_COUNTRY, (Object)countryId);
            this.getModel().setValue(KEY_PARENT, (Object)currentNodeId);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        this.setPropertyEnable();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.setPropertyVisible();
        }
        if (formShowParameter.getStatus().equals((Object)OperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
        }
        this.setCountryPropertyVisible();
        if ("1000001".equals(this.getView().getFormShowParameter().getCustomParam("countryId"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PARENT});
        }
    }

    private void setCountryPropertyVisible() {
        String countryType = this.getModel().getDataEntity().getString(KEY_COUNTRYTYPE);
        if (FIELD_COUNTRYTYPE_GENERAL.equals(countryType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_COUNTRYTYPE});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_COUNTRY});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_COUNTRYTYPE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_COUNTRY});
        }
    }

    private void setPropertyVisible() {
        String parentId = this.getModel().getDataEntity().getString(KEY_PARENT);
        if (null == parentId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PARENT});
        }
    }

    private void setPropertyEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_COUNTRY});
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_COUNTRYTYPE});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        String key = basedataEdit.getKey();
        if (KEY_PARENT.equals(key)) {
            String countryId = this.getModel().getDataEntity().getString("country.id");
            countryId = countryId == null ? FIELD_COUNTRYTYPE_GENERAL : countryId;
            QFilter qFilter = new QFilter(KEY_COUNTRY, "=", (Object)Long.valueOf(countryId));
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"save")) {
            this.checkNumberAndName(args);
            this.checkLevel(args);
        }
    }

    private void checkNumberAndName(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String number = model.getDataEntity().getString("number");
        String name = model.getDataEntity().getString("name");
        Matcher numMatcher = pattern.matcher(number);
        Matcher nameMatcher = pattern.matcher(name);
        if (numMatcher.matches() || nameMatcher.matches()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u5141\u8bb8\u542b\u6709\u5b57\u7b26\".\"\u3002", (String)"TaxItemTypeEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkLevel(BeforeDoOperationEventArgs args) {
        if (args.isCancel()) {
            return;
        }
        DynamicObject currentTaxItemType = this.getModel().getDataEntity();
        int currentNodeLevel = currentTaxItemType.getInt("level");
        if (currentNodeLevel > 9) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u5c42\u7ea7\u8d85\u8fc7\u9650\u5236\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u64cd\u4f5c\u3002", (String)"TaxItemTypeEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentId = currentTaxItemType.getString("id");
        DynamicObject country = currentTaxItemType.getDynamicObject(KEY_COUNTRY);
        String countryId = country == null ? FIELD_COUNTRYTYPE_GENERAL : country.getString("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitemtype");
        QFilter countryFilter = new QFilter(KEY_COUNTRY, "=", (Object)Long.valueOf(countryId));
        DynamicObject[] dynamicObjects = helper.query("id,name,parent,longnumber,level", new QFilter[]{countryFilter});
        List results = Arrays.stream(dynamicObjects).sorted(new dyComparator()).collect(Collectors.toList());
        ArrayList<Long> taxItemTypeIds = new ArrayList<Long>(dynamicObjects.length);
        ArrayList<DynamicObject> currentDyAndChildDys = new ArrayList<DynamicObject>(dynamicObjects.length);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            DynamicObject dy = (DynamicObject)iterator.next();
            if (currentId.equals(dy.getString("id"))) {
                currentDyAndChildDys.add(dy);
                taxItemTypeIds.add(dy.getLong("id"));
                iterator.remove();
                continue;
            }
            if (!taxItemTypeIds.contains(dy.getLong("parent.id"))) continue;
            taxItemTypeIds.add(dy.getLong("id"));
            currentDyAndChildDys.add(dy);
            iterator.remove();
        }
        List sortedCurrentDyAndChildDys = currentDyAndChildDys.stream().sorted(new dyComparator()).collect(Collectors.toList());
        int currentNewLevel = currentTaxItemType.getInt("level");
        int currentOldLevel = 0;
        for (DynamicObject sortedCurrentDyAndChildDy : sortedCurrentDyAndChildDys) {
            if (!currentId.equals(sortedCurrentDyAndChildDy.getString("id"))) continue;
            currentOldLevel = sortedCurrentDyAndChildDy.getInt("level");
        }
        boolean isPass = true;
        int diffLevel = currentNewLevel - currentOldLevel;
        for (DynamicObject sortedCurrentDyAndChildDy : sortedCurrentDyAndChildDys) {
            int level = sortedCurrentDyAndChildDy.getInt("level");
            int newLevel = level + diffLevel;
            if (newLevel <= 9) {
                sortedCurrentDyAndChildDy.set("level", (Object)newLevel);
                continue;
            }
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u5c42\u7ea7\u8d85\u8fc7\u9650\u5236\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"TaxItemTypeEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            isPass = false;
            break;
        }
        if (isPass) {
            GlobalParam.set((String)"allNodes", sortedCurrentDyAndChildDys);
        }
    }

    public void beforeClosed(BeforeClosedEvent ex) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        DynamicObject dy = this.getModel().getDataEntity();
        long id = dy.getLong("id");
        String name = dy.getString("name");
        returnData.put("id", id);
        returnData.put("name", name);
        this.getView().returnDataToParent(returnData);
    }

    static class dyComparator
    implements Comparator<DynamicObject> {
        dyComparator() {
        }

        @Override
        public int compare(DynamicObject d1, DynamicObject d2) {
            int d1Level = d1.getString("longnumber").split("\\.").length;
            int d2Level = d2.getString("longnumber").split("\\.").length;
            return d1Level - d2Level;
        }
    }
}

