/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbs.business.model.TaxItemEntity;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;
import org.apache.commons.lang.StringUtils;

public class FieldSelectorEdit
extends HRDataBaseEdit
implements TabSelectListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(FieldSelectorEdit.class);

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{"ok", "cancel", "taxfilebnt", "taxitembnt"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Search search = (Search)this.getView().getControl("search");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent ex) {
        this.doSearch(ex);
    }

    public void tabSelected(TabSelectEvent evt) {
        String currentTab = evt.getTabKey();
        if ("taxitemtab".equals(currentTab)) {
            try {
                this.showTaxItemPage();
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        } else if ("taxfiletab".equals(currentTab)) {
            try {
                this.showTaxFilePage();
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        try {
            this.showTaxItemPage();
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
        }
    }

    private void showTaxItemPage() {
        List taxItems;
        FormShowParameter prams = this.getView().getFormShowParameter();
        String scene = (String)prams.getCustomParam("scene");
        if ("1".equals(scene)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxitemtab"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxitembnt"});
            this.showTaxFilePage();
            return;
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("taxitemtab");
        HRPageCache pageCache = new HRPageCache(this.getView());
        Boolean isFirst = (Boolean)pageCache.get("taxitemfirst", Boolean.class);
        if (Boolean.FALSE.equals(isFirst)) {
            return;
        }
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        String taxItemCache = (String)parentPageCache.get("sitbs_taxitem_cache", String.class);
        if (StringUtils.isBlank((String)taxItemCache)) {
            String taxCategoryIdJson = (String)prams.getCustomParam("taxCategoryId");
            Set taxCategoryIds = (Set)SerializationUtils.fromJsonString((String)taxCategoryIdJson, Set.class);
            String sceneType = (String)prams.getCustomParam("sceneType");
            taxItems = TaxTemplateHelper.taxItemCache((String)scene, (Set)taxCategoryIds, (String)sceneType, (IFormView)this.getView().getParentView());
        } else {
            taxItems = JSON.parseArray((String)taxItemCache, TaxItemEntity.class);
        }
        this.insertTaxItemEntry(taxItems);
        pageCache.put("taxitemfirst", (Object)Boolean.FALSE);
    }

    private void insertTaxItemEntry(List<TaxItemEntity> taxItems) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taxitementryentity");
        if (null != entryEntity) {
            this.getModel().deleteEntryData("taxitementryentity");
            this.getView().updateView("taxitementryentity");
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int entryentityIndex = 0;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (TaxItemEntity taxItem : taxItems) {
            TableValueSetter addValueSetter = vs.addRow(new Object[0]);
            addValueSetter.set("taxitem", (Object)taxItem.getId(), entryentityIndex);
            ++entryentityIndex;
        }
        model.batchCreateNewEntryRow("taxitementryentity", vs);
        model.endInit();
        this.getView().updateView("taxitementryentity");
    }

    private void showTaxFilePage() {
        HRPageCache pageCache = new HRPageCache(this.getView());
        Boolean isFirst = (Boolean)pageCache.get("taxfilefirst", Boolean.class);
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("taxfiletab");
        if (Boolean.FALSE.equals(isFirst)) {
            return;
        }
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        String taxFileCache = (String)parentPageCache.get("itc_taxfilequery_cache", String.class);
        List selectFields = StringUtils.isBlank((String)taxFileCache) ? TaxImportExportTmpDBHelper.queryTaxFileFields() : JSON.parseArray((String)taxFileCache, QuerySelectField.class);
        this.insertTaxFileEntry(selectFields);
        pageCache.put("taxfilefirst", (Object)Boolean.FALSE);
        parentPageCache.put("itc_taxfilequery_cache", (Object)JSON.toJSONString((Object)selectFields));
    }

    private String getAlias(QuerySelectField qField, Map<String, IDataEntityProperty> allFields, String mainEntityName) {
        String alias = qField.getAlias();
        String[] aliasArry = alias.split("\\.");
        StringBuilder buffer = new StringBuilder(mainEntityName);
        if (0 == aliasArry.length) {
            return buffer.append('.').append(alias).toString();
        }
        if (allFields.containsKey(aliasArry[0])) {
            return buffer.append('.').append(alias).toString();
        }
        return alias;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                this.clickOkBnt();
                break;
            }
            case "cancel": {
                this.clickCancel();
                break;
            }
            case "taxitembnt": {
                try {
                    this.showTaxItemPage();
                }
                catch (Exception e1) {
                    logger.error((Throwable)e1);
                }
                break;
            }
            case "taxfilebnt": {
                try {
                    this.showTaxFilePage();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                break;
            }
        }
    }

    private void doSearch(SearchEnterEvent event) {
        String text = event.getText();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("taxitemtab".equals(currentTab)) {
            this.searchTaxItem(text);
        } else {
            this.searchTaxFileField(text);
        }
    }

    private void searchTaxFileField(String text) {
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        String taxFileCache = (String)parentPageCache.get("itc_taxfilequery_cache", String.class);
        if (StringUtils.isBlank((String)taxFileCache)) {
            return;
        }
        List selectFields = JSON.parseArray((String)taxFileCache, QuerySelectField.class);
        ArrayList<QuerySelectField> matchFieldList = new ArrayList<QuerySelectField>();
        for (QuerySelectField field : selectFields) {
            String displayName = field.getDisplayName();
            if (!displayName.contains(text)) continue;
            matchFieldList.add(field);
        }
        this.insertTaxFileEntry(matchFieldList);
    }

    private void searchTaxItem(String text) {
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        String taxItemCache = (String)parentPageCache.get("sitbs_taxitem_cache", String.class);
        if (StringUtils.isBlank((String)taxItemCache)) {
            return;
        }
        List taxItems = JSON.parseArray((String)taxItemCache, TaxItemEntity.class);
        ArrayList<TaxItemEntity> matchList = new ArrayList<TaxItemEntity>();
        for (TaxItemEntity taxItemEntity : taxItems) {
            if (!taxItemEntity.getName().contains(text)) continue;
            matchList.add(taxItemEntity);
        }
        this.insertTaxItemEntry(matchList);
    }

    private void clickCancel() {
        this.getView().close();
    }

    private void clickOkBnt() {
        this.getSelectedNodeId();
    }

    private void getSelectedNodeId() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("taxitemtab".equals(currentTab)) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("taxitementryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taxitementryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"FieldSelectorEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject selectOvDy = (DynamicObject)this.getModel().getEntryEntity("taxitementryentity").get(entryIndex);
            if (null != selectOvDy) {
                String name = selectOvDy.getString("taxitem.name");
                long primaryKeyValue = selectOvDy.getLong("taxitem.id");
                String taxItemNumber = selectOvDy.getString("taxitem.number");
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("name", name);
                map.put("taxItemId", primaryKeyValue);
                map.put("taxItemNumber", taxItemNumber);
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        } else if ("taxfiletab".equals(currentTab)) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("taxfileentryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taxfileentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"FieldSelectorEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject selectOvDy = (DynamicObject)this.getModel().getEntryEntity("taxfileentryentity").get(entryIndex);
            if (StringUtils.isNotBlank((String)selectOvDy.getString("field"))) {
                String field = selectOvDy.getString("field");
                String name = selectOvDy.getString("fielddisplayname");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("name", name);
                map.put("field", field);
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        }
    }

    private void insertTaxFileEntry(List<QuerySelectField> selectFields) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taxfileentryentity");
        if (null != entryEntity) {
            this.getModel().deleteEntryData("taxfileentryentity");
            this.getView().updateView("taxfileentryentity");
        }
        IDataModel model = this.getModel();
        for (QuerySelectField qField : selectFields) {
            int index = model.createNewEntryRow("taxfileentryentity");
            String alias = qField.getAlias();
            String displayName = qField.getDisplayName();
            this.getModel().setValue("fielddisplayname", (Object)displayName, index);
            this.getView().updateView(displayName);
            this.getModel().setValue("field", (Object)alias, index);
        }
    }
}

