/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;
import kd.sit.sitbs.formplugin.web.taxtemplate.AbstractTaxImportExportTemplate;
import org.apache.commons.lang3.StringUtils;

public class ImportExportTemplateEdit
extends AbstractTaxImportExportTemplate
implements TabSelectListener,
BeforeF7SelectListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (null != tab) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        this.addClickListeners(new String[]{"taxdisplayname"});
        BasedataEdit taxGroupEdit = (BasedataEdit)this.getView().getControl("taxgroup");
        taxGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategoryEdit = (BasedataEdit)this.getView().getControl("taxcategory");
        taxCategoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "ismustinput": {
                this.mustInputChange(evt);
                break;
            }
            case "isexport": {
                this.exportChange(evt);
                break;
            }
        }
    }

    private void mustInputChange(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        String tmpType = model.getDataEntity().getString("templatetype");
        if ("1".equals(tmpType)) {
            return;
        }
        ChangeData data = args.getChangeSet()[0];
        boolean newValue = (Boolean)data.getNewValue();
        if (newValue) {
            int rowIndex = args.getChangeSet()[0].getRowIndex();
            model.setValue("isexport", (Object)Boolean.TRUE, rowIndex);
        }
    }

    private void exportChange(PropertyChangedArgs event) {
        IDataModel model = this.getModel();
        ChangeData data = event.getChangeSet()[0];
        boolean newExport = (Boolean)data.getNewValue();
        int rowIndex = event.getChangeSet()[0].getRowIndex();
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (!newExport) {
            boolean mustInput = entry.getBoolean("ismustinput");
            if (mustInput) {
                model.beginInit();
                model.setValue("isexport", (Object)Boolean.TRUE, rowIndex);
                model.endInit();
                String content = ResManager.loadKDString((String)"\u5fc5\u586b\u7684\u6570\u636e\u5fc5\u987b\u5bfc\u51fa\u3002", (String)"ImportExportTemplateEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(content);
            } else {
                String disPlayName = entry.getString("taxdisplayname");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{disPlayName})) {
                    model.setValue("taxdisplayname", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5c06\u5ffd\u7565\u8be5\u5b57\u6bb5", (String)"ImportExportTemplateEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), rowIndex);
                }
            }
        } else {
            TaxTemplateHelper.setDisplayName((IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("taxdisplayname".equals(key)) {
            this.showFieldSelector();
        }
    }

    private void showFieldSelector() {
        FormShowParameter showParameter = TaxTemplateHelper.fieldSelectorParam((IDataModel)this.getModel());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldselectorack"));
        this.getView().showForm(showParameter);
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        if (StringUtils.equals((CharSequence)"pagethree", (CharSequence)subTabKey)) {
            this.initPageThree();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "taxcategory": {
                QFilter qFilter = new QFilter("country.id", "=", (Object)1000001L);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                showParameter.getTreeFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "taxgroup": {
                QFilter qFilter1 = new QFilter("country.id", "=", (Object)1000001L);
                ListShowParameter showParameter1 = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter1.getListFilterParameter().getQFilters().add(qFilter1);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("fieldselectorack".equals(actionId)) {
            this.selectField(evt);
        }
    }

    private void selectField(ClosedCallBackEvent evt) {
        boolean isRepeat;
        Map selectData = (Map)evt.getReturnData();
        if (null == selectData) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String field = (String)selectData.get("field");
        Long taxItemId = (Long)selectData.get("taxItemId");
        if (StringUtils.isNotBlank((CharSequence)field)) {
            isRepeat = TaxTemplateHelper.judgeField((String)field, (IDataModel)this.getModel(), (IFormView)this.getView());
            if (isRepeat) {
                return;
            }
            this.getModel().setValue("fieldkey", (Object)field, rowIndex);
            this.getModel().setValue("taxitem", null, rowIndex);
        }
        if (null != taxItemId) {
            isRepeat = TaxTemplateHelper.judgeTaxItem((Long)taxItemId, (IDataModel)this.getModel(), (IFormView)this.getView());
            if (isRepeat) {
                return;
            }
            this.getModel().setValue("taxitem", (Object)taxItemId, rowIndex);
            this.getModel().setValue("fieldkey", null, rowIndex);
            this.getView().updateView("taxitemnumber", rowIndex, 0);
        }
        IDataModel model = this.getModel();
        String tmpType = this.getModel().getDataEntity().getString("templatetype");
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        boolean isExport = entry.getBoolean("isexport");
        if (!isExport && "2".equals(tmpType)) {
            model.setValue("taxdisplayname", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5c06\u5ffd\u7565\u8be5\u5b57\u6bb5", (String)"ImportExportTemplateEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), rowIndex);
        } else {
            model.setValue("taxdisplayname", selectData.get("name"), rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult result;
        super.afterDoOperation(evt);
        evt.getOperateKey();
        String key = evt.getOperateKey();
        if ("save".equals(key) && (result = evt.getOperationResult()).isSuccess()) {
            this.openTemplateView(evt);
        }
    }

    private void initPageThree() {
        TaxTemplateHelper.initTemplateEntry((IDataModel)this.getModel(), (IFormView)this.getView());
        String scene = this.getModel().getDataEntity().getString("scene");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)scene) || StringUtils.equals((CharSequence)"4", (CharSequence)scene)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            TaxTemplateHelper.setMustInputItem((IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    private void openTemplateView(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        Object pkId = successPkIds.get(0);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPkId(pkId);
        showParameter.setFormId("sitbs_taxtemplateview");
        showParameter.setCustomParam("id", pkId);
        showParameter.setCustomParam("op", (Object)"edit");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

