/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;
import kd.sit.sitbs.common.enums.TaxTemplateSceneEnums;

public class ImportExportTemplateListEdit
extends HRDataBaseList {
    public void beforeShowBill(BeforeShowBillFormEvent event) {
        this.intShowTemplateViewParam(event);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        switch (key) {
            case "copy": {
                this.beforeCopyDo(args, selectedRows);
                break;
            }
            case "new": {
                IPageCache pageCache = this.getPageCache();
                pageCache.put("opType", "new");
                break;
            }
        }
    }

    private void beforeCopyDo(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ImportExportTemplateEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ImportExportTemplateEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("opType", "copy");
    }

    private void intShowTemplateViewParam(BeforeShowBillFormEvent event) {
        BillShowParameter showParameter = event.getParameter();
        OperationStatus operStatus = showParameter.getStatus();
        IPageCache pageCache = this.getPageCache();
        String opType = pageCache.get("opType");
        if (OperationStatus.ADDNEW.equals((Object)operStatus) && "new".equals(opType)) {
            pageCache.remove("opType");
            return;
        }
        showParameter.setFormId("sitbs_taxtemplateview");
        OperationStatus setStatus = this.setStatus(showParameter.getPkId(), opType);
        showParameter.setStatus(setStatus);
        pageCache.remove("opType");
    }

    private OperationStatus setStatus(Object pkId, String opType) {
        if ("copy".equals(opType)) {
            return OperationStatus.ADDNEW;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxtemplate");
        DynamicObject dy = helper.queryOne("issyspreset", pkId);
        boolean isSysPreset = dy.getBoolean("issyspreset");
        if (isSysPreset) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.EDIT;
    }

    public void packageData(PackageDataEvent ex) {
        DynamicObject rowData2 = ex.getRowData();
        super.packageData(ex);
        ColumnDesc columnDesc = (ColumnDesc)ex.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("simplename".equals(fieldKey)) {
            Object object = rowData2.get("scene");
            ex.setFormatValue(object);
        }
    }

    public void beforePackageData(BeforePackageDataEvent ex) {
        super.beforePackageData(ex);
        DynamicObjectCollection coll = ex.getPageData();
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>(coll.size());
        this.getView().setVisible(Boolean.FALSE, new String[]{"taxcategory", "taxgroup"});
        for (DynamicObject dy : coll) {
            long id = dy.getLong("id");
            set.add(id);
        }
        DynamicObject[] queryTemplates = TaxImportExportTmpDBHelper.queryTemplates(set, null);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(queryTemplates.length);
        for (DynamicObject dy : queryTemplates) {
            map.put(dy.getLong("id"), dy);
        }
        for (DynamicObject dy : coll) {
            DynamicObject dynamicObject = (DynamicObject)map.get(dy.getLong("id"));
            Object scene = dynamicObject.get("scene");
            if ("1".equals(scene)) {
                dy.set("scenesearch", (Object)TaxTemplateSceneEnums.EXPORT_PERSON.getI18nName().loadKDString());
                continue;
            }
            if ("4".equals(scene)) {
                dy.set("scenesearch", (Object)TaxTemplateSceneEnums.IMPORT_SPECIAL_ADDITIONAL.getI18nName().loadKDString());
                continue;
            }
            Object taxCategory = dynamicObject.get("taxcategory.name");
            if (null != taxCategory) {
                dy.set("scenesearch", taxCategory);
                continue;
            }
            Object taxGroup = dynamicObject.get("taxgroup.name");
            if (null == taxGroup) continue;
            dy.set("scenesearch", taxGroup);
        }
    }

    public void setFilter(SetFilterEvent ex) {
        QFilter qFilter;
        super.setFilter(ex);
        List qFilters = ex.getQFilters();
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext() && null != (qFilter = (QFilter)iterator.next())) {
            if (qFilter.getProperty().contains("scenesearch")) {
                this.setScenceFilter(qFilter, iterator, list);
                break;
            }
            List nests = qFilter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests)) continue;
            Iterator iterator1 = nests.iterator();
            while (iterator1.hasNext()) {
                QFilter.QFilterNest next = (QFilter.QFilterNest)iterator1.next();
                if (next == null || !next.getFilter().getProperty().contains("scenesearch")) continue;
                this.setScenceFilter(next.getFilter(), iterator1, list);
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            qFilters.addAll(list);
        }
    }

    private void setScenceFilter(QFilter qFilter, Iterator iterator, List<QFilter> qFilters) {
        String qCp = qFilter.getCP();
        Object qValue = qFilter.getValue();
        switch (qCp) {
            case "is not null": {
                iterator.remove();
                break;
            }
            case "is null": {
                QFilter sceneFilter1 = new QFilter("scene", qCp, (Object)Boolean.TRUE);
                qFilters.add(sceneFilter1);
                QFilter taxGroupFilter = new QFilter("taxgroup.name", qCp, (Object)Boolean.TRUE);
                qFilters.add(taxGroupFilter);
                QFilter taxcategoryFilter = new QFilter("taxcategory.name", qCp, (Object)Boolean.TRUE);
                qFilters.add(taxcategoryFilter);
                iterator.remove();
                break;
            }
            default: {
                if (QEmptyValue.value == qValue) {
                    QFilter sceneFilter2 = new QFilter("scene", qCp, qValue);
                    qFilters.add(sceneFilter2);
                    iterator.remove();
                    return;
                }
                String property = qFilter.getProperty();
                String newProperty = property.replace("scenesearch", "taxgroup.name");
                qFilter.__setProperty(newProperty);
                String value = (String)qFilter.getValue();
                QFilter filter = new QFilter("taxcategory.name", qCp, (Object)value);
                qFilter.or(filter);
                String exportPersonStr = TaxTemplateSceneEnums.EXPORT_PERSON.getI18nName().loadKDString();
                if (StringUtils.isEmpty((String)value)) {
                    return;
                }
                String importSpecialAdditionalStr = TaxTemplateSceneEnums.IMPORT_SPECIAL_ADDITIONAL.getI18nName().loadKDString();
                String str = value.replaceAll("%", "");
                String loadKDString = "";
                String scene = null;
                if (exportPersonStr.contains(str)) {
                    loadKDString = exportPersonStr;
                    scene = "1";
                }
                if (importSpecialAdditionalStr.contains(str)) {
                    loadKDString = importSpecialAdditionalStr;
                    scene = "4";
                }
                if (StringUtils.isEmpty((String)loadKDString)) {
                    return;
                }
                if (value.startsWith("%") && value.endsWith("%")) {
                    QFilter sceneFilter = new QFilter("scene", qCp, (Object)scene);
                    qFilter.or(sceneFilter);
                    break;
                }
                if (loadKDString.startsWith(str) && !value.startsWith("%") && value.endsWith("%")) {
                    QFilter sceneFilter = new QFilter("scene", qCp, (Object)scene);
                    qFilter.or(sceneFilter);
                    break;
                }
                if (loadKDString.endsWith(str) && value.startsWith("%") && !value.endsWith("%")) {
                    QFilter sceneFilter = new QFilter("scene", qCp, (Object)scene);
                    qFilter.or(sceneFilter);
                    break;
                }
                if (!value.equals(loadKDString)) break;
                QFilter sceneFilter = new QFilter("scene", qCp, (Object)scene);
                qFilter.or(sceneFilter);
            }
        }
    }
}

