/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import java.util.Collection;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;

public class ImportExportTemplateListEnableEdit
extends HRDataBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "enable": {
                this.doEnableConfirm(args);
                break;
            }
            case "disable": {
                this.doDisableConfirm(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ex) {
        super.confirmCallBack(ex);
        switch (ex.getCallBackId()) {
            case "DO_ENABLE": {
                this.doEnableCallBack(ex);
                break;
            }
            case "DO_DISABLE": {
                this.doDisableCallBack(ex);
                break;
            }
            case "DO_ENABLESECOND": {
                this.doEnable(ex);
                break;
            }
        }
    }

    private void doEnableCallBack(MessageBoxClosedEvent ex) {
        if (!ex.getResult().equals((Object)MessageBoxResult.Yes)) {
            return;
        }
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        HashSet<DynamicObject[]> set = new HashSet<DynamicObject[]>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            DynamicObject[] primaryKeyValue = (DynamicObject[])row.getPrimaryKeyValue();
            set.add(primaryKeyValue);
        }
        DynamicObject[] queryTemplates = TaxImportExportTmpDBHelper.queryTemplates(set, null);
        int importCount = 0;
        for (DynamicObject dy : queryTemplates) {
            String templateType = dy.getString("templatetype");
            if (!"1".equals(templateType)) continue;
            ++importCount;
        }
        if (importCount == 1) {
            String confirmMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u76f8\u540c\u9002\u7528\u573a\u666f\u4e0b\u7684\u6570\u636e\u5bfc\u5165\u65b9\u6848\uff0c\u786e\u5b9a\u8981\u542f\u7528\u8be5\u65b9\u6848\u5e76\u7981\u7528\u5176\u4ed6\u65b9\u6848\u5417\uff1f", (String)"ImportExportTemplateListEnableEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DO_ENABLESECOND"));
            return;
        }
        if (importCount > 1) {
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u4e0d\u652f\u6301\u6279\u91cf\u542f\u7528\u64cd\u4f5c\u3002", (String)"ImportExportTemplateListEnableEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("confirmed", "true");
        this.getView().invokeOperation("enable", op);
    }

    private void doDisableCallBack(MessageBoxClosedEvent ex) {
        if (ex.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("confirmed", "true");
            this.getView().invokeOperation("disable", op);
        }
    }

    private void doEnable(MessageBoxClosedEvent ex) {
        if (ex.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("confirmed", "true");
            this.getView().invokeOperation("enable", op);
        }
    }

    private void doEnableConfirm(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean confirmed = formOperate.getOption().tryGetVariableValue("confirmed", new RefObject());
        if (!confirmed) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ImportExportTemplateEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            String confirmMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u542f\u7528\u5bfc\u5165\u5bfc\u51fa\u65b9\u6848\u5417\uff1f", (String)"ImportExportTemplateListEnableEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DO_ENABLE"));
            args.setCancel(true);
        }
    }

    private void doDisableConfirm(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean confirmed = formOperate.getOption().tryGetVariableValue("confirmed", new RefObject());
        if (!confirmed) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ImportExportTemplateEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String confirmMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u7981\u7528\u5bfc\u5165\u5bfc\u51fa\u65b9\u6848\u5417\uff1f", (String)"ImportExportTemplateListEnableEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DO_DISABLE"));
            args.setCancel(true);
        }
    }
}

