/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.TaxTemplateImportTaxDataEnum;
import kd.sit.sitbp.common.field.LockableComboEdit;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;
import org.apache.commons.lang3.StringUtils;

public class ImportExportTemplateViewEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(ImportExportTemplateViewEdit.class);
    private final Set<String> combos = Sets.newHashSet((Object[])new String[]{"countrytype", "templatetype", "scenetype"});

    public void initialize() {
        this.getView().addCustomControls(this.combos.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs ex) {
        super.onGetControl(ex);
        String key = ex.getKey();
        if (this.combos.contains(key)) {
            LockableComboEdit edit = new LockableComboEdit();
            edit.setView(this.getView());
            edit.setKey(key);
            ex.setControl((Control)edit);
        }
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)viewStatus) || OperationStatus.EDIT.equals((Object)viewStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"countrytype", "templatetype", "scenetype"});
        }
    }

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"taxdisplayname"});
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        IDataModel model = this.getModel();
        String fieldKey = ex.getProperty().getName();
        ChangeData data = ex.getChangeSet()[0];
        switch (fieldKey) {
            case "ismustinput": {
                boolean newValue = (Boolean)data.getNewValue();
                if (!newValue) break;
                int parentRowIndex = ex.getChangeSet()[0].getParentRowIndex();
                int rowIndex = ex.getChangeSet()[0].getRowIndex();
                model.setValue("isexport", (Object)Boolean.TRUE, rowIndex, parentRowIndex);
                break;
            }
            case "isexport": {
                boolean newExport = (Boolean)data.getNewValue();
                if (!newExport) {
                    int rowIndex = ex.getChangeSet()[0].getRowIndex();
                    DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                    boolean mustInput = entry.getBoolean("ismustinput");
                    if (mustInput) {
                        int parentRowIndex = ex.getChangeSet()[0].getParentRowIndex();
                        model.beginInit();
                        model.setValue("isexport", (Object)Boolean.TRUE, rowIndex, parentRowIndex);
                        model.endInit();
                        String content = ResManager.loadKDString((String)"\u5fc5\u586b\u7684\u6570\u636e\u5fc5\u987b\u5bfc\u51fa\u3002", (String)"ImportExportTemplateViewEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(content);
                        break;
                    }
                    String disPlayName = entry.getString("taxdisplayname");
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{disPlayName})) break;
                    model.setValue("taxdisplayname", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5c06\u5ffd\u7565\u8be5\u5b57\u6bb5", (String)"ImportExportTemplateEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), rowIndex);
                    break;
                }
                TaxTemplateHelper.setDisplayName((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "taxdisplayname": {
                this.showFieldSelector();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "disable": {
                this.getModel().setValue("status", (Object)"C");
                break;
            }
            case "copy": {
                long userId = RequestContext.get().getCurrUserId();
                String appId = this.getView().getFormShowParameter().getCheckRightAppId();
                boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)userId, (String)appId, (String)"sitbs_taxtemplate", (String)"47156aff000000ac");
                logger.info("WYF---TaxTemplate log----------------{}---{}---{}", new Object[]{userId, appId, hasPerm});
                if (!hasPerm) {
                    String msg = ResManager.loadKDString((String)"\u590d\u5236\u65b0\u589e", (String)"ImportExportTemplateViewEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(SITPermissionServiceHelper.getNoPermTips((String)msg));
                }
                IFormView view = this.getView();
                view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_copy"});
                break;
            }
        }
    }

    private void showFieldSelector() {
        FormShowParameter showParameter = TaxTemplateHelper.fieldSelectorParam((IDataModel)this.getModel());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldselectorack"));
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_copy".equals(itemKey)) {
            IFormView iFormView = this.getView();
        }
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        this.init();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        IFormView view = this.getView();
        switch (key) {
            case "save": {
                view.setVisible(Boolean.TRUE, new String[]{"bar_disable"});
                view.setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_copy"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
                break;
            }
            case "copy": {
                view.setVisible(Boolean.TRUE, new String[]{"bntmoveentrydown", "newentry", "advconbaritemap1", "bntmoveentryup", ""});
                break;
            }
        }
    }

    private void init() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = parameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            String name = this.getModel().getDataEntity().getString("name");
            name = name + "\uff081\uff09";
            this.getModel().setValue("name", (Object)name);
        }
        this.setBarByOperationStatus(status, view);
        TaxTemplateHelper.initViewStatus((IDataModel)model, (IFormView)view);
        this.initEntry(model, view);
    }

    private void initEntry(IDataModel model, IFormView view) {
        TaxTemplateHelper.setDisplayName((IDataModel)this.getModel(), (IFormView)this.getView());
        TaxTemplateHelper.initTemplateEntry((IDataModel)model, (IFormView)view);
        String tmpType = model.getDataEntity().getString("templatetype");
        if ("2".equals(tmpType)) {
            HashMap<String, Object> advConApCtrl = new HashMap<String, Object>(16);
            advConApCtrl.put("text", "");
            advConApCtrl.put("collapsible", Boolean.FALSE);
            view.updateControlMetadata("advconap", advConApCtrl);
        } else {
            HashMap<String, Boolean> advConApCtrl = new HashMap<String, Boolean>(16);
            advConApCtrl.put("collapsible", Boolean.TRUE);
            view.updateControlMetadata("advconap", advConApCtrl);
            HashMap<String, Object> advConApCtrl1 = new HashMap<String, Object>(16);
            advConApCtrl1.put("text", "");
            advConApCtrl1.put("collapsible", Boolean.FALSE);
            view.updateControlMetadata("flexpanelap4", advConApCtrl1);
            view.setVisible(Boolean.FALSE, new String[]{"flextips"});
            view.updateView("flextips");
        }
        this.setImportEntryEnable();
    }

    private void setImportEntryEnable() {
        String tmpType = this.getModel().getDataEntity().getString("templatetype");
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)tmpType)) {
            return;
        }
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        if (entryEntities.size() >= 6) {
            for (TaxTemplateImportTaxDataEnum value : TaxTemplateImportTaxDataEnum.values()) {
                this.setDisplayName(value, entryEntities);
            }
        }
        this.getView().updateView("entryentity");
    }

    private void setDisplayName(TaxTemplateImportTaxDataEnum taxDataEnum, DynamicObjectCollection dys) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        for (int i = 0; i < dys.size(); ++i) {
            boolean isEquals;
            DynamicObject dy = (DynamicObject)dys.get(i);
            String displayName = taxDataEnum.getSystemFieldName().loadKDString();
            boolean bl = isEquals = StringUtils.equals((CharSequence)dy.getString("fieldkey"), (CharSequence)taxDataEnum.getSystemFieldNumber()) || dy.getLong("taxitem.id") == 1123912112880510976L;
            if (!isEquals) continue;
            dy.set("taxdisplayname", (Object)displayName);
            grid.getView().setEnable(Boolean.FALSE, i, new String[]{"taxdisplayname"});
            grid.getView().setEnable(Boolean.FALSE, i, new String[]{"notes"});
            break;
        }
    }

    private void setBarByOperationStatus(OperationStatus status, IFormView view) {
        switch (status) {
            case VIEW: {
                view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_disable"});
                view.setVisible(Boolean.FALSE, new String[]{"bntmoveentrydown", "newentry", "advconbaritemap1", "bntmoveentryup"});
                break;
            }
            case EDIT: {
                view.setVisible(Boolean.TRUE, new String[]{"bar_disable"});
                view.setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
                break;
            }
            case ADDNEW: {
                view.setVisible(Boolean.FALSE, new String[]{"bar_disable"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_donothingcopy"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_copy"});
                view.setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent ent) {
        boolean isRepeat;
        super.closedCallBack(ent);
        Map returnData = (Map)ent.getReturnData();
        if (null == returnData) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String field = (String)returnData.get("field");
        Object taxItemId = returnData.get("taxItemId");
        if (StringUtils.isNotBlank((CharSequence)field)) {
            isRepeat = TaxTemplateHelper.judgeField((String)field, (IDataModel)this.getModel(), (IFormView)this.getView());
            if (isRepeat) {
                return;
            }
            this.getModel().setValue("fieldkey", (Object)field, rowIndex);
            this.getModel().setValue("taxitem", null, rowIndex);
            this.getView().updateView("taxitemnumber", rowIndex, 0);
        }
        if (null != taxItemId) {
            isRepeat = TaxTemplateHelper.judgeTaxItem((Long)((Long)taxItemId), (IDataModel)this.getModel(), (IFormView)this.getView());
            if (isRepeat) {
                return;
            }
            this.getModel().setValue("taxitem", taxItemId, rowIndex);
            this.getModel().setValue("fieldkey", null, rowIndex);
            this.getView().updateView("taxitemnumber", rowIndex, 0);
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        boolean isExport = entry.getBoolean("isexport");
        String tmpType = this.getModel().getDataEntity().getString("templatetype");
        if (!isExport && "2".equals(tmpType)) {
            this.getModel().setValue("taxdisplayname", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5c06\u5ffd\u7565\u8be5\u5b57\u6bb5", (String)"ImportExportTemplateEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), rowIndex);
        } else {
            this.getModel().setValue("taxdisplayname", returnData.get("name"), rowIndex);
        }
    }
}

