/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;
import kd.sit.sitbs.common.enums.TaxTemplateSceneTypeEnums;
import kd.sit.sitbs.formplugin.web.taxtemplate.AbstractTaxImportExportTemplate;

public class TaxTemplateBaseInfoEdit
extends AbstractTaxImportExportTemplate
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(TaxTemplateBaseInfoEdit.class);
    private static final String[] FIELDS = new String[]{"name", "number", "templatetype", "scenetype"};
    private static final String[] SCENE_FIELDS = new String[]{"taxgroup", "taxcategory", "scene"};

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit taxCategoryBase = (BasedataEdit)this.getView().getControl("taxcategory");
        taxCategoryBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxGroupBase = (BasedataEdit)this.getView().getControl("taxgroup");
        taxGroupBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        this.init();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "taxcategory": {
                logger.info("---------------:{}", (Object)"taxcategory");
                ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                long countryId = this.getModel().getDataEntity().getLong("country.id");
                HashSet<Long> set = new HashSet<Long>(2);
                set.add(countryId);
                set.add(0L);
                QFilter qFilter = new QFilter("country.id", "in", set);
                param.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "taxgroup": {
                logger.info("kd/sit/sitbs/formplugin/web/taxtemplate/TaxTemplateBaseInfoEdit:{}", (Object)"taxcategory");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "donothing_nextpage": {
                this.checkPage(args);
                break;
            }
            case "donothing_lastpage": {
                this.checkToLastPage();
                break;
            }
        }
    }

    private void checkToLastPage() {
        if (!StringUtils.equals((CharSequence)"pagethree", (CharSequence)this.getCurrentTab())) {
            this.toLastPage();
            return;
        }
        this.updateEntryEntityView();
        this.toLastPage();
    }

    private void updateEntryEntityView() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (null != entryEntity) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
        }
    }

    private void checkPage(AfterDoOperationEventArgs args) {
        if (!StringUtils.equals((CharSequence)"pageone", (CharSequence)this.getCurrentTab())) {
            this.toNextPage();
            return;
        }
        if (this.checkMustInput()) {
            DynamicObject dy = this.getModel().getDataEntity();
            TaxTemplateHelper.taxItemCache((String)dy.getString("scene"), (Set)TaxTemplateHelper.setTaxCategoryId((IDataModel)this.getModel()), (String)dy.getString("scenetype"), (IFormView)this.getView());
            TaxTemplateHelper.taxFielCache((IFormView)this.getView());
            this.toNextPage();
        }
    }

    private boolean checkMustInput() {
        String name;
        QFilter qFilter;
        DynamicObject queryTemplate;
        boolean checkGroupAndCategory;
        String exitMeg = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"ImportExportTemplateEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isMustInput = false;
        for (String field : FIELDS) {
            String value = dataEntity.getString(field);
            if (!StringUtils.isBlank((CharSequence)value)) continue;
            FieldTip showValidateTip = TaxTemplateHelper.showValidateTip((boolean)false, (String)exitMeg, (String)field);
            this.getView().showFieldTip(showValidateTip);
            isMustInput = true;
        }
        boolean checkScent = !"1".equals(dataEntity.get("scene")) && !"3".equals(dataEntity.get("scenetype"));
        boolean bl = checkGroupAndCategory = null == dataEntity.get("taxgroup") && null == dataEntity.get("taxcategory");
        if (checkGroupAndCategory && checkScent) {
            for (String field : SCENE_FIELDS) {
                String value = dataEntity.getString(field);
                if (!StringUtils.isBlank((CharSequence)value)) continue;
                FieldTip showValidateTip = TaxTemplateHelper.showValidateTip((boolean)false, (String)exitMeg, (String)field);
                this.getView().showFieldTip(showValidateTip);
                isMustInput = true;
            }
        }
        if (isMustInput) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5fc5\u586b\u9879", (String)"ImportExportTemplateEdit_15", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList list = Lists.newArrayList();
        String number = dataEntity.getString("number");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject template = TaxImportExportTmpDBHelper.queryTemplate((String)"number", (QFilter)numberFilter);
        if (null != template) {
            list.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportExportTemplateEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        }
        if (null != (queryTemplate = TaxImportExportTmpDBHelper.queryTemplate((String)"name", (QFilter)(qFilter = new QFilter("name", "=", (Object)(name = dataEntity.getString("name"))))))) {
            list.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportExportTemplateEdit_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        }
        if (list.size() > 0) {
            isMustInput = true;
            String comma = MultiLangHelper.getMultiLangCommaDelimiter();
            String msg = ResManager.loadKDString((String)"{0}\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"ImportExportTemplateEdit_10", (String)"sit-sitbs-formplugin", (Object[])new Object[]{Joiner.on((String)comma).join((Iterable)list)});
            this.getView().showErrorNotification(msg);
        }
        return !isMustInput;
    }

    private void init() {
        this.showPage(1);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_taxitem", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)countryIds) && !countryIds.contains(1000001L)) {
            this.getModel().setValue("country", null);
            this.getModel().setValue("countrytype", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u56fd\u5bb6/\u5730\u533a\u4e1a\u52a1\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxAppItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("country", (Object)1000001L);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"country", "countrytype"});
        TaxTemplateHelper.initViewStatus((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String name = ex.getProperty().getName();
        FieldTip showValidateTip = TaxTemplateHelper.showValidateTip((boolean)true, null, (String)name);
        this.getView().showFieldTip(showValidateTip);
        switch (name) {
            case "templatetype": {
                this.tmpTypeChange();
                break;
            }
            case "scenetype": {
                this.sceneTypeChange();
                break;
            }
        }
    }

    private void sceneTypeChange() {
        IDataModel model = this.getModel();
        String sceneType = model.getDataEntity().getString("scenetype");
        model.beginInit();
        model.setValue("taxcategory", null);
        model.setValue("taxgroup", null);
        model.endInit();
        if ("1".equals(sceneType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"scene"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxcategory"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxgroup"});
            model.beginInit();
            model.setValue("scene", (Object)"1");
            model.endInit();
            this.getView().setEnable(Boolean.FALSE, new String[]{"scene"});
            this.getView().updateView("scene");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxgroup");
        } else if ("2".equals(sceneType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scene"});
            String tmpType = model.getDataEntity().getString("templatetype");
            if ("2".equals(tmpType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxcategory"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxgroup"});
                model.beginInit();
                model.setValue("scene", (Object)"2");
                model.endInit();
            } else {
                model.beginInit();
                model.setValue("scene", (Object)"3");
                model.endInit();
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxcategory"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxgroup"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"scene"});
            this.getView().updateView("scene");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxgroup");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scene", "taxgroup", "taxcategory"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"scene"});
            model.beginInit();
            model.setValue("scene", (Object)"4");
            model.endInit();
            this.getView().setEnable(Boolean.FALSE, new String[]{"scene"});
            this.getView().updateView("scene");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxgroup");
        }
    }

    private void tmpTypeChange() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String tmpType = model.getDataEntity().getString("templatetype");
        if ("1".equals(tmpType)) {
            model.beginInit();
            model.setValue("taxcategory", null);
            model.setValue("scene", null);
            model.setValue("scenetype", null);
            model.setValue("taxgroup", null);
            model.endInit();
            view.setVisible(Boolean.TRUE, new String[]{"taxgroup"});
            BasedataEdit taxGroup = (BasedataEdit)view.getControl("taxgroup");
            taxGroup.setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"scene", "taxcategory"});
            view.setVisible(Boolean.TRUE, new String[]{"headerlinenumber"});
            view.updateView("taxgroup");
            view.updateView("scenetype");
            view.updateView("scene");
            view.updateView("taxcategory");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(3);
            items.add(new ComboItem(new LocaleString(TaxTemplateSceneTypeEnums.TAX_DECLARE.getI18nName().loadKDString()), TaxTemplateSceneTypeEnums.TAX_DECLARE.getCode()));
            items.add(new ComboItem(new LocaleString(TaxTemplateSceneTypeEnums.SPECIAL_ADDITIONAL_DECLARE.getI18nName().loadKDString()), TaxTemplateSceneTypeEnums.SPECIAL_ADDITIONAL_DECLARE.getCode()));
            ComboEdit comboEdit = (ComboEdit)this.getControl("scenetype");
            comboEdit.setComboItems(items);
        } else if ("2".equals(tmpType)) {
            model.beginInit();
            model.setValue("scenetype", null);
            model.setValue("taxgroup", null);
            model.setValue("scene", null);
            model.setValue("headerlinenumber", (Object)"0");
            model.endInit();
            view.setEnable(Boolean.TRUE, new String[]{"scenetype", "taxcategory"});
            view.setVisible(Boolean.FALSE, new String[]{"headerlinenumber"});
            BasedataEdit taxCategory = (BasedataEdit)view.getControl("taxcategory");
            taxCategory.setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"taxgroup"});
            view.updateView("taxgroup");
            view.updateView("scenetype");
            view.updateView("scene");
            view.updateView("taxcategory");
            view.updateView("headerlinenumber");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(3);
            items.add(new ComboItem(new LocaleString(TaxTemplateSceneTypeEnums.TAX_PERSON_DECLARE.getI18nName().loadKDString()), TaxTemplateSceneTypeEnums.TAX_PERSON_DECLARE.getCode()));
            items.add(new ComboItem(new LocaleString(TaxTemplateSceneTypeEnums.TAX_DECLARE.getI18nName().loadKDString()), TaxTemplateSceneTypeEnums.TAX_DECLARE.getCode()));
            ComboEdit comboEdit = (ComboEdit)this.getControl("scenetype");
            comboEdit.setComboItems(items);
        }
    }
}

