/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxtemplate;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.sit.sitbp.common.enums.TaxTemplateImportTaxDataEnum;
import kd.sit.sitbs.business.model.TaxItemEntity;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;
import kd.sit.sitbs.formplugin.web.taxtemplate.AbstractTaxImportExportTemplate;
import org.apache.commons.lang3.StringUtils;

public class UploadHeaderEdit
extends AbstractTaxImportExportTemplate
implements UploadListener {
    private static Log logger = LogFactory.getLog(UploadHeaderEdit.class);

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{"btnuploadexcel"});
        Button button = (Button)this.getControl("btnuploadexcel");
        if (null != button) {
            button.addUploadListener((UploadListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        super.upload(evt);
        Object[] urls = evt.getUrls();
        if (urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6a21\u677f", (String)"UploadHeaderEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = (String)urls[0];
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6a21\u677f", (String)"UploadHeaderEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        final HashMap<Integer, String> title = new HashMap<Integer, String>();
        final int headerlinenumber = this.getModel().getDataEntity().getInt("headerlinenumber");
        InputStream inputStream = null;
        try {
            FileService service = FileServiceFactory.getAttachmentFileService();
            inputStream = service.getInputStream(url);
            new ExcelReader().read(inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    int rowNum = row.getRowNum();
                    Map rowTitle = row.getData();
                    if (rowNum == headerlinenumber) {
                        rowTitle.forEach((index, titleName) -> {
                            if (StringUtils.isNotBlank((CharSequence)titleName)) {
                                title.put(index, titleName);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e1) {
                logger.error((Throwable)e1);
            }
        }
        if (title.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6a21\u677f", (String)"UploadHeaderEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        this.setEntry(title);
    }

    private void setEntry(Map<Integer, String> title) {
        String scene = this.getModel().getDataEntity().getString("scene");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)scene) || StringUtils.equals((CharSequence)"4", (CharSequence)scene)) {
            this.mergeMustInputData(title);
        }
        this.entryImportData(title);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("sitbs_entryimport".equals(actionId) && (returnData = (Map)evt.getReturnData()) == null) {
            return;
        }
    }

    private void mergeMustInputData(Map<Integer, String> titles) {
        TaxTemplateHelper.setMustInputItem((IDataModel)this.getModel(), (IFormView)this.getView());
        for (TaxTemplateImportTaxDataEnum value : TaxTemplateImportTaxDataEnum.values()) {
            String alisName = value.getSystemFieldName().loadKDString();
            Set<Map.Entry<Integer, String>> entrySet = titles.entrySet();
            Iterator<Map.Entry<Integer, String>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, String> entry = iterator.next();
                String title = entry.getValue();
                if (StringUtils.isBlank((CharSequence)title)) continue;
                if (title.startsWith("*") || title.endsWith("*")) {
                    title = title.replaceAll("\\*", "");
                }
                if (!alisName.equals(title)) continue;
                iterator.remove();
            }
        }
    }

    private void entryImportData(Map<Integer, String> titles) {
        if (null == titles || titles.size() == 0) {
            this.toNextPage();
            return;
        }
        IDataModel model = this.getModel();
        String tmpType = this.getModel().getDataEntity().getString("templatetype");
        for (Map.Entry<Integer, String> entry : titles.entrySet()) {
            String tatle = entry.getValue();
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            if (tatle.startsWith("*") || tatle.endsWith("*")) {
                tatle = tatle.replaceAll("\\*", "");
                if (StringUtils.equals((CharSequence)"2", (CharSequence)tmpType)) {
                    model.setValue("isexport", (Object)Boolean.TRUE, rowIndex);
                    model.setValue("ismustinput", (Object)Boolean.TRUE, rowIndex);
                }
            }
            if (StringUtils.equals((CharSequence)"1", (CharSequence)tmpType)) {
                model.setValue("importfield", (Object)tatle, rowIndex);
                this.matchField(tatle, rowIndex);
                continue;
            }
            model.setValue("exportfield", (Object)tatle, rowIndex);
            this.matchField(tatle, rowIndex);
        }
        this.toNextPage();
    }

    private void matchField(String tatle, int rowIndex) {
        HRPageCache pageCache = new HRPageCache(this.getView());
        String taxfileCache = (String)pageCache.get("itc_taxfilequery_cache", String.class);
        boolean isFileMatch = false;
        String taxitemCache = (String)pageCache.get("sitbs_taxitem_cache", String.class);
        if (StringUtils.isNotBlank((CharSequence)taxitemCache)) {
            List taxitems = JSONArray.parseArray((String)taxitemCache, TaxItemEntity.class);
            isFileMatch = this.doMatchTaxItem(tatle, taxitems, rowIndex);
        }
        if (isFileMatch) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)taxfileCache)) {
            List selectFields = JSONArray.parseArray((String)taxfileCache, QuerySelectField.class);
            this.doMatchTaxFile(tatle, selectFields, rowIndex);
        }
    }

    private boolean doMatchTaxItem(String tatle, List<TaxItemEntity> taxitems, int rowIndex) {
        for (TaxItemEntity taxitem : taxitems) {
            String name = taxitem.getName();
            if (!StringUtils.equals((CharSequence)tatle, (CharSequence)name)) continue;
            this.setItemToEntry(taxitem, rowIndex);
            return true;
        }
        return false;
    }

    private void setItemToEntry(TaxItemEntity taxitem, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("taxdisplayname", (Object)taxitem.getName(), rowIndex);
        model.setValue("taxitem", (Object)taxitem.getId(), rowIndex);
        this.getView().updateView("taxitemnumber", rowIndex, 0);
    }

    private boolean doMatchTaxFile(String tatle, List<QuerySelectField> selectFields, int rowIndex) {
        for (QuerySelectField qField : selectFields) {
            String displayName = qField.getDisplayName();
            if (!StringUtils.equals((CharSequence)tatle, (CharSequence)displayName)) continue;
            this.setFileToEntry(qField, rowIndex);
            return true;
        }
        return false;
    }

    private void setFileToEntry(QuerySelectField qField, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("taxdisplayname", (Object)qField.getDisplayName(), rowIndex);
        model.setValue("fieldkey", (Object)qField.getAlias(), rowIndex);
    }
}

