/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare;

import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.formplugin.web.welfare.InsuranceItemList;
import org.apache.commons.lang.StringUtils;

public class InsuranceItemEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String DATA_TYPE = "datatype";
    private static final String DATA_PRECISION = "dataprecision";
    private static final String DATA_ROUND = "dataround";
    private static final String INSURANCE_TYPE = "group";
    private static final String COUNTRY = "country";
    private static final String INSURANCE_TYPE_ATTR = "insurancetypeattr";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit insuranceTypeAttr = (BasedataEdit)this.getControl(INSURANCE_TYPE_ATTR);
        insuranceTypeAttr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        IDataEntityProperty property = args.getProperty();
        String controlName = property.getName();
        if (StringUtils.equals((String)controlName, (String)INSURANCE_TYPE_ATTR)) {
            if (changeData[0].getNewValue() == null) {
                this.getModel().setValue(DATA_TYPE, null);
                this.getModel().setValue(DATA_PRECISION, null);
                this.getModel().setValue(DATA_ROUND, null);
            } else {
                DynamicObject insuranceTypeAttr = (DynamicObject)changeData[0].getNewValue();
                DynamicObject insurTypeDy = this.getModel().getDataEntity(true).getDynamicObject(INSURANCE_TYPE);
                if (this.checkInsurTypeAttrForSameInsurType(insurTypeDy.getLong("id"), insuranceTypeAttr.getLong("id"))) {
                    String errInfo = SocInsuranceErrInfoEnum.EXISTS_SAME_INSURE_TYPE_AND_ATTR.getErrInfo(new Object[]{insurTypeDy.getString("name"), insuranceTypeAttr.getString("name")});
                    this.getView().showTipNotification(errInfo);
                    this.getModel().beginInit();
                    this.getModel().setValue(INSURANCE_TYPE_ATTR, null);
                    this.getModel().endInit();
                    return;
                }
                this.setControlByDataType(insuranceTypeAttr.getDynamicObject(DATA_TYPE), true);
            }
        }
    }

    private boolean checkInsurTypeAttrForSameInsurType(long insurTypeId, long insurTypeAttrId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter filter = new QFilter(INSURANCE_TYPE, "=", (Object)insurTypeId);
        filter.and(INSURANCE_TYPE_ATTR, "=", (Object)insurTypeAttrId);
        return helper.isExists(filter.toArray());
    }

    public void afterCreateNewData(EventObject event) {
        DynamicObject insurTypeDy = this.getModel().getDataEntity(true).getDynamicObject(INSURANCE_TYPE);
        if (!HRObjectUtils.isEmpty((Object)insurTypeDy)) {
            this.getModel().setValue(COUNTRY, (Object)insurTypeDy.getDynamicObject(COUNTRY));
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        DynamicObject dataType = this.getModel().getDataEntity(true).getDynamicObject(DATA_TYPE);
        this.setControlByDataType(dataType, false);
        DynamicObject insurTypeDy = this.getModel().getDataEntity(true).getDynamicObject(INSURANCE_TYPE);
        if (!HRObjectUtils.isEmpty((Object)insurTypeDy)) {
            this.getModel().setValue(COUNTRY, (Object)insurTypeDy.getDynamicObject(COUNTRY));
        }
    }

    public void setControlByDataType(DynamicObject dataType, boolean isModifyDataType) {
        if (Objects.isNull(dataType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DATA_PRECISION});
            return;
        }
        long dataTypeId = dataType.getLong("id");
        BasedataEdit accuracyControl = (BasedataEdit)this.getView().getControl(DATA_PRECISION);
        DynamicObject insuranceTypeAttr = this.getModel().getDataEntity(true).getDynamicObject(INSURANCE_TYPE_ATTR);
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId) {
            accuracyControl.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{DATA_PRECISION});
            if (isModifyDataType && !Objects.isNull(insuranceTypeAttr)) {
                this.getModel().setValue(DATA_TYPE, (Object)insuranceTypeAttr.getDynamicObject(DATA_TYPE));
                this.getModel().setValue(DATA_PRECISION, (Object)insuranceTypeAttr.getDynamicObject(DATA_PRECISION));
                this.getModel().setValue(DATA_ROUND, (Object)insuranceTypeAttr.getDynamicObject(DATA_ROUND));
            }
        } else if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            accuracyControl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{DATA_PRECISION});
            if (isModifyDataType && !Objects.isNull(insuranceTypeAttr)) {
                this.getModel().setValue(DATA_TYPE, (Object)insuranceTypeAttr.getDynamicObject(DATA_TYPE));
                this.getModel().setValue(DATA_ROUND, (Object)insuranceTypeAttr.getDynamicObject(DATA_ROUND));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        long id = this.getModel().getDataEntity(true).getLong("country.id");
        if (0L == id) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"InsuranceTypeProEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        String key = basedataEdit.getKey();
        if (StringUtils.equals((String)INSURANCE_TYPE_ATTR, (String)key)) {
            QFilter countryFilter = new QFilter("country.id", "=", (Object)id);
            long insurTypeId = this.getModel().getDataEntity(true).getLong("group.id");
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
            QFilter filter = new QFilter(INSURANCE_TYPE, "=", (Object)insurTypeId);
            filter.and(countryFilter);
            DynamicObjectCollection insuranceItemDys = helper.queryOriginalCollection("insurancetypeattr.id", filter.toArray());
            if (insuranceItemDys != null && insuranceItemDys.size() > 0) {
                Set existedAttrIds = insuranceItemDys.stream().map(insuranceItemDy -> insuranceItemDy.getLong("insurancetypeattr.id")).collect(Collectors.toSet());
                countryFilter.and("id", "not in", existedAttrIds);
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(countryFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("delete".equals(formOperate.getOperateKey())) {
            super.beforeDoOperation(args);
            InsuranceItemList.ignoreRefEntityIds(formOperate);
        }
    }
}

