/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.formplugin.web.sinsur.SInsurBatchImportPlugin;
import kd.sit.sitbs.formplugin.web.welfare.imports.InsuranceDownloadTemplatePlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InsuranceItemList
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(InsuranceItemList.class);
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";

    public void initialize() {
        Long countryId;
        super.initialize();
        String entityId = this.getView().getEntityId();
        if (entityId.contains("f7")) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DEL});
        LocaleString localeString = ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u9669\u79cd\u540d\u79f0", (String)"InsuranceTypeProList_0", (String)"sit-sitbs-formplugin");
        HashMap searchApCtrl = Maps.newHashMapWithExpectedSize((int)1);
        searchApCtrl.put("emptytip", localeString);
        this.getView().updateControlMetadata("searchap", (Map)searchApCtrl);
        String appKey = this.getView().getFormShowParameter().getCheckRightAppId();
        if (!HRStringUtils.equals((String)"sitbs", (String)appKey) && (countryId = SInsuranceCommonService.getCountryIdByAppId((String)this.getView().getFormShowParameter().getAppId())) != null) {
            this.getTreeModel().getTreeFilter().add(new QFilter("country.id", "=", (Object)countryId));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String entityName = this.getModel().getDataEntityType().getName();
        switch (operateKey) {
            case "new": {
                ITreeModel treeModel = this.getTreeModel();
                String currentNodeId = (String)treeModel.getCurrentNodeId();
                if (!this.getTreeModel().getRoot().getId().equals(currentNodeId)) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9669\u79cd\u3002", (String)"InsuranceTypeProList_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                if (!StringUtils.equals((String)"bos_templatetreelist", (String)entityName)) break;
                this.initializeTree(new EventObject(new Object()));
                break;
            }
            case "bar_import": {
                this.openBosImportStart(formOperate);
                args.setCancel(true);
                break;
            }
            case "delete": {
                super.beforeDoOperation(args);
                InsuranceItemList.ignoreRefEntityIds(formOperate);
                break;
            }
            case "exportlist": 
            case "exportlistbyselectfields": 
            case "exportlist_expt": {
                this.getPageCache().put("exportKey", operateKey);
                break;
            }
        }
    }

    public void afterExportFile(ExportFileEvent event) {
        IFormView view = (IFormView)event.getSource();
        if (view == null || !"exportlist".equals(view.getPageCache().get("exportKey"))) {
            return;
        }
        view.getPageCache().remove("exportKey");
        File file = event.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);
                 XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
                 FileOutputStream fos = new FileOutputStream(file);){
                InsuranceDownloadTemplatePlugin.createInsurancePropDataRows((Workbook)workbook);
                workbook.write((OutputStream)fos);
            }
            catch (Exception ex) {
                LOGGER.error("InsuranceItemList#afterExportFile error:", (Throwable)ex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "bar_import": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public static void ignoreRefEntityIds(FormOperate formOperate) {
        StringJoiner ignoreEntityNames = new StringJoiner(",");
        ignoreEntityNames.add("hcsi_calperson");
        ignoreEntityNames.add("hcsi_calperson_tpl");
        ignoreEntityNames.add("hcsi_sinsuradjrec");
        ignoreEntityNames.add("hcsi_dclperson");
        formOperate.getOption().setVariableValue("ignorerefentityids", ignoreEntityNames.toString());
    }

    private void openBosImportStart(FormOperate formOperate) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        params.put("ServiceAppId", showParam.getCheckRightAppId());
        params.put("CheckRightAppId", showParam.getCheckRightAppId());
        params.put("BillFormId", ((ListShowParameter)showParam).getBillFormId());
        params.put("BillFormId1", ((ListShowParameter)showParam).getBillFormId());
        params.put("ListName", showParam.getCaption());
        params.put("CustPlugin", InsuranceDownloadTemplatePlugin.class.getName());
        params.put("RealPermissionEntityId", ((ListShowParameter)showParam).getBillFormId());
        params.put("PermissionItemId", "4730fc9f000003ae");
        params.put("OperateName", formOperate.getOperateName().getLocaleValue());
        params.put("ImportPlugin", SInsurBatchImportPlugin.class.getName());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sitbs_insuimportstart");
        showParameter.setAppId(showParam.getCheckRightAppId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams((Map)params);
        showParameter.setParentPageId(view.getFormShowParameter().getPageId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_import"));
        LOGGER.info("InsuranceItemList.openBosImportStart: ServiceAppId is {}", (Object)showParam.getCheckRightAppId());
        this.getView().showForm(showParameter);
    }
}

