/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare;

import java.util.Collections;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import org.apache.commons.lang.StringUtils;

public class InsuranceTypeAttrEdit
extends AbstractBasePlugIn {
    private static final String DATA_TYPE = "datatype";
    private static final String DATA_PRECISION = "dataprecision";

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        IDataEntityProperty property = args.getProperty();
        String controlName = property.getName();
        if (StringUtils.equals((String)controlName, (String)DATA_TYPE)) {
            DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
            this.setControlByDataType(newValue);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        SInsuranceCommonService.createInstance().setDefaultCountryAndCurrency((Object)this, Collections.singletonList("country"));
        DynamicObject dataType = this.getModel().getDataEntity().getDynamicObject(DATA_TYPE);
        this.setControlByDataType(dataType);
    }

    public void setControlByDataType(DynamicObject dataType) {
        if (Objects.isNull(dataType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DATA_PRECISION});
            return;
        }
        BasedataEdit accuracyControl = (BasedataEdit)this.getView().getControl(DATA_PRECISION);
        accuracyControl.setMustInput(true);
        long dataTypeId = dataType.getLong("id");
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId) {
            accuracyControl.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{DATA_PRECISION});
        } else if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            accuracyControl.setMustInput(false);
            this.getModel().setValue(DATA_PRECISION, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{DATA_PRECISION});
        }
    }
}

