/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbs.business.WelfarePayerHelper;
import kd.sit.sitbs.business.coandDimRef.CoandDimRefHelper;

public class WelfarePayerEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String WELFARE_PAYER_ID = "welfarePayerId";
    public static final String WELFARE_PAYER = "welfarepayer";
    private static final String PLACE_OF_WELFARE = "placeofwelfare";
    private static final String SIN_SUR_DCL_RULE = "sinsurdclrule";
    private static final String BASE_CAL_RULE = "basecalrule";
    private static final String LAW_ENTITY = "lawentity";
    private static final String SAVE_REF = "saveref";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit placeOfWelfareBE = (BasedataEdit)this.getControl(PLACE_OF_WELFARE);
        placeOfWelfareBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lawEntity = (BasedataEdit)this.getControl(LAW_ENTITY);
        lawEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sinSurDclRule = (BasedataEdit)this.getControl(SIN_SUR_DCL_RULE);
        sinSurDclRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit baseCalRule = (BasedataEdit)this.getControl(BASE_CAL_RULE);
        baseCalRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        boolean isRelLawEntity = WelfarePayerHelper.getIsRelLawentity();
        if (isRelLawEntity) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(LAW_ENTITY);
            fieldEdit.setMustInput(isRelLawEntity);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        String key = basedataEdit.getKey();
        if (HRStringUtils.equals((String)PLACE_OF_WELFARE, (String)key)) {
            long id = this.getModel().getDataEntity().getLong("country.id");
            if (0L == id) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"WelfarePayerEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                evt.setCancel(true);
                return;
            }
            QFilter countryFilter = new QFilter("country.id", "=", (Object)id);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(countryFilter);
        } else if (HRStringUtils.equals((String)LAW_ENTITY, (String)key)) {
            QFilter propctlFilter = new QFilter("propctl", "like", (Object)"%,4,%");
            propctlFilter.or(new QFilter("entitytype", "=", (Object)"3"));
            QFilter lawEntityFilter = this.existLawEntityId();
            if (lawEntityFilter != null) {
                propctlFilter.and(lawEntityFilter);
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(propctlFilter);
        } else if (HRStringUtils.equals((String)SIN_SUR_DCL_RULE, (String)key) || HRStringUtils.equals((String)BASE_CAL_RULE, (String)key)) {
            long countryId = this.getModel().getDataEntity(true).getLong("country.id");
            if (0L == countryId) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"WelfarePayerEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                evt.setCancel(true);
                return;
            }
            QFilter countryFilter = new QFilter("country.id", "=", (Object)countryId);
            if (HRStringUtils.equals((String)BASE_CAL_RULE, (String)key)) {
                long orgId = this.getModel().getDataEntity(true).getLong("org.id");
                countryFilter.and(SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_basecalrule", (Long)orgId));
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(countryFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)SAVE_REF, (String)operateKey) && !SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_coanddimref", (String)"47156aff000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5177\u6709\u53c2\u4fdd\u5355\u4f4d-\u53c2\u4fdd\u6807\u51c6\u5173\u8054\u5173\u7cfb\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WelfarePayerEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "save": 
            case "saveref": {
                Boolean isRelLawEntity = WelfarePayerHelper.getIsRelLawentity();
                if (!isRelLawEntity.booleanValue()) break;
                this.saveWelfarePayerConfirm(operate, args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
                case "saveref": {
                    DynamicObject mainOrgObj;
                    List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
                    Long welfarePayerId = (Long)successPkIds.get(0);
                    HashMap<String, Long> customParamMap = new HashMap<String, Long>(16);
                    customParamMap.put(WELFARE_PAYER_ID, welfarePayerId);
                    FormShowParameter baseShowParameter = CoandDimRefHelper.openAddNewPage(customParamMap);
                    MainEntityType billEntityType = this.getModel().getDataEntityType();
                    String mainOrgProp = billEntityType.getMainOrg();
                    if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
                        long orgID = (Long)mainOrgObj.getPkValue();
                        baseShowParameter.setCustomParam("orgId", (Object)(orgID + ""));
                    }
                    this.getView().getParentView().showForm(baseShowParameter);
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "save": 
            case "saveref": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("saveConfirmResult", "1");
                this.getView().invokeOperation(callBackId, operateOption);
                break;
            }
        }
    }

    private void saveWelfarePayerConfirm(FormOperate operate, BeforeDoOperationEventArgs args) {
        String confirmResult = operate.getOption().getVariableValue("saveConfirmResult", "0");
        if (!StringUtils.equals((CharSequence)confirmResult, (CharSequence)"1")) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String lawEntityName = dynamicObject.getString("lawentity.name") + "\\r\\n";
            String countryName = dynamicObject.getString("country.name") + "\\r\\n";
            String ensuredCountryName = dynamicObject.getString("placeofwelfare.name");
            String headerMsg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6240\u9009\u6cd5\u5f8b\u5b9e\u4f53\u3001\u56fd\u5bb6/\u5730\u533a\u3001\u53c2\u4fdd\u5730\u662f\u5426\u5339\u914d\u65e0\u8bef", (String)"WelfarePayerEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            String bottomMsg = ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\uff1a{0}\u56fd\u5bb6/\u5730\u533a\uff1a{1}\u53c2\u4fdd\u5730\uff1a{2}", (String)"WelfarePayerEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(headerMsg, MessageFormat.format(bottomMsg, lawEntityName, countryName, ensuredCountryName), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(operate.getOperateKey()));
            args.setCancel(true);
        }
    }

    private QFilter existLawEntityId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObject[] welfarePayers = hrBaseServiceHelper.query(LAW_ENTITY, new QFilter[0]);
        if (welfarePayers == null || welfarePayers.length == 0) {
            return null;
        }
        ArrayList<Long> lawEntiyIds = new ArrayList<Long>(welfarePayers.length);
        for (DynamicObject welfarePayer : welfarePayers) {
            lawEntiyIds.add(welfarePayer.getLong("lawentity.id"));
        }
        return new QFilter("id", "not in", lawEntiyIds);
    }
}

