/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare.imports;

import java.time.LocalDate;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.DownloadTemplatePlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public abstract class AbstractDownloadTemplatePlugin
extends DownloadTemplatePlugin {
    private static Log log = LogFactory.getLog(AbstractDownloadTemplatePlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEWTEMPLATE = "newtemplate";

    public void initialize() {
        super.initialize();
        IFormView view = this.getView();
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugIns = service.getPlugIns();
        plugIns.removeIf(plugIn -> plugIn.getPluginName().contains("bos"));
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.pushTempalte();
                break;
            }
            case "newtemplate": {
                BillList list = (BillList)this.getControl("billlistap");
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(list.getEntityId());
                parameter.setCustomParam("bindEntityId", this.getView().getFormShowParameter().getCustomParam("BillFormId"));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private void pushTempalte() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        String importPlugin = "";
        String extendData = (String)this.getView().getFormShowParameter().getCustomParam("ExtendData");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
        if (templates == null || templates.length == 0) {
            templates = new Object[]{0L};
        }
        if (!StringUtils.isBlank((CharSequence)billFormId)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
            LocalDate now = LocalDate.now();
            for (Object template : templates) {
                String fileName = this.buildFileName(mainEntityType, template, now);
                String url = this.export(template.toString(), this.getView().getFormShowParameter().getServiceAppId(), billFormId, StringUtils.isBlank((CharSequence)importPlugin) ? "" : importPlugin, extendData, fileName);
                log.info("AbstractDownloadTemplatePlugin.pushTemplate, export template ,url is {}", (Object)url);
                this.getView().download(UrlService.getAttachmentFullUrl((String)url));
                this.getView().sendFormAction(this.getView());
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractDownloadTemplatePlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        }
        log.info("AbstractDownloadTemplatePlugin.pushTemplate: end");
    }

    private String buildFileName(MainEntityType mainEntityType, Object template, LocalDate now) {
        DynamicObject templateData = null;
        if ((Long)template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f", (String)"AbstractDownloadTemplatePlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]).concat("_");
        String extentName = templateData != null && templateData.getString("name") != null && templateData.getString("name").trim().length() > 0 ? templateData.getString("name") : mainEntityType.getDisplayName().getLocaleValue();
        extentName = StringUtils.isEmpty((CharSequence)extentName) ? ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee\u7cfb\u7edf\u9ed8\u8ba4\u6a21\u677f", (String)"AbstractDownloadTemplatePlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]) : extentName;
        fileName = (fileName + extentName).replaceAll(" ", "_");
        return fileName + "_" + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
    }

    public abstract String export(String var1, String var2, String var3, String var4, String var5, String var6);
}

