/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.welfare.imports;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.formplugin.web.welfare.imports.AbstractDownloadTemplatePlugin;
import kd.sit.sitbs.formplugin.web.welfare.imports.CommonExcelWriter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class InsuranceDownloadTemplatePlugin
extends AbstractDownloadTemplatePlugin {
    private static Log log = LogFactory.getLog(InsuranceDownloadTemplatePlugin.class);
    private static final String[] FIELD_KEYS = new String[]{"number", "name", "country.name", "datatype.name", "dataprecision.name", "dataround.name"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String export(String templateId, String routeAppId, String formId, String plugin, String extendData, String fileName) {
        try (SXSSFWorkbook workBook = new SXSSFWorkbook(5000);){
            if (HRStringUtils.isEmpty((String)templateId)) return "";
            workBook.setCompressTempFiles(true);
            this.prepareExportData(routeAppId, formId, templateId, plugin, extendData, workBook);
            InsuranceDownloadTemplatePlugin.createInsurancePropDataRows((Workbook)workBook);
            CommonExcelWriter excelWriter = new CommonExcelWriter(workBook);
            log.info("InsuranceDownloadTemplatePlugin.export: end");
            String string = excelWriter.flush(this.getView().getModel().getDataEntityType(), fileName);
            return string;
        }
        catch (Exception e) {
            log.error("InsuranceDownloadTemplatePlugin.export, export template error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void prepareExportData(String routeAppId, String formId, String templateId, String plugin, String extenddata, SXSSFWorkbook wb) {
        String exportJSon = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, Long.parseLong(templateId), plugin == null ? "" : plugin, extenddata});
        List format = JSON.parseArray((String)exportJSon, ExportWriterFormat.class);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (List)format);
    }

    public static void createInsurancePropDataRows(Workbook wb) {
        String sqlSelect = String.join((CharSequence)",", FIELD_KEYS);
        List<DynamicObject> insurTypeAttrDys = InsuranceDownloadTemplatePlugin.getInsurancePropData(sqlSelect);
        Sheet sheet = wb.createSheet("sheet2");
        String[] headCells = new String[]{SocInsuranceErrInfoEnum.COMMON_FIELD_NUMBER.getErrInfo(), SocInsuranceErrInfoEnum.COMMON_FIELD_NAME.getErrInfo(), SocInsuranceErrInfoEnum.COMMON_FIELD_COUNTRY.getErrInfo(), SocInsuranceErrInfoEnum.COMMON_DATA_TYPE.getErrInfo(), SocInsuranceErrInfoEnum.COMMON_DATA_ACCURACY.getErrInfo(), SocInsuranceErrInfoEnum.COMMON_HANDLE_DATA_ACCURACY.getErrInfo()};
        for (int index = 0; index <= insurTypeAttrDys.size(); ++index) {
            Row row = sheet.createRow(index);
            for (int cellIndex = 0; cellIndex < FIELD_KEYS.length; ++cellIndex) {
                if (0 == index && (1 == cellIndex || 4 == cellIndex)) {
                    sheet.setColumnWidth(cellIndex, 3072);
                }
                String cellVal = index == 0 ? headCells[cellIndex] : insurTypeAttrDys.get(index - 1).getString(FIELD_KEYS[cellIndex]);
                CellStyle style = wb.createCellStyle();
                InsuranceDownloadTemplatePlugin.setBorderStyle(style);
                Cell cell = row.createCell((int)((short)cellIndex));
                cell.setCellValue(cellVal);
                cell.setCellStyle(style);
            }
        }
    }

    public static List<DynamicObject> getInsurancePropData(String sqlSelect) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceprop");
        DynamicObject[] insurTypeAttrDys = helper.query(sqlSelect, SInsuranceCommonService.getAuditAndEnableQFilter().toArray(), "number asc");
        return Optional.ofNullable(insurTypeAttrDys).map(Arrays::asList).orElseGet(() -> Collections.emptyList());
    }

    private static void setBorderStyle(CellStyle cellStyle) {
        cellStyle.setWrapText(true);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }
}

