/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class CertDetailUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CertDetailUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        CertDetailUpdateService.tryCompleteCertSceneDetail();
        return new UpgradeResult();
    }

    public static void tryCompleteCertSceneDetail() {
        List<Long> certDetailPks = CertDetailUpdateService.getCertDetailId();
        List partitions = Lists.partition(certDetailPks, (int)5000);
        for (List partCertDetailIds : partitions) {
            Set<Long> certDetailPksOfExistScene = CertDetailUpdateService.getDetailIdOfExistScene(partCertDetailIds);
            List leftPks = ListUtils.removeAll((Collection)partCertDetailIds, certDetailPksOfExistScene);
            CertDetailUpdateService.insertSceneDetail(leftPks);
        }
    }

    private static List<Long> getCertDetailId() {
        ArrayList certDetailPks = Lists.newArrayList();
        try (DataSet dataSet = DB.queryDataSet((String)"CertDetailUpdateService", (DBRoute)DBRoute.of((String)"sit"), (String)"select fid from t_sitbs_certdetail", (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                certDetailPks.add(dataSet.next().getLong("fid"));
            }
        }
        return certDetailPks;
    }

    private static Set<Long> getDetailIdOfExistScene(List<Long> partCertDetailIds) {
        ArrayList sepList = Lists.newArrayListWithExpectedSize((int)partCertDetailIds.size());
        partCertDetailIds.forEach(obj -> sepList.add("?"));
        HashSet certDetailPksOfExistScene = Sets.newHashSet();
        try (DataSet dataSet = DB.queryDataSet((String)"CertDetailUpdateService", (DBRoute)DBRoute.of((String)"sit"), (String)("select fid,fcertdetailid,fscene from t_sitbs_certscenedetail where fcertdetailid in (" + StringUtils.join((Iterable)sepList, (String)",") + ")"), (Object[])partCertDetailIds.toArray());){
            while (dataSet.hasNext()) {
                certDetailPksOfExistScene.add(dataSet.next().getLong("fcertdetailid"));
            }
        }
        return certDetailPksOfExistScene;
    }

    private static void insertSceneDetail(List leftPks) {
        if (leftPks.isEmpty()) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)leftPks.size());
        long[] pkIds = IDService.get().genLongIds(leftPks.size());
        for (int i = 0; i < leftPks.size(); ++i) {
            params.add(new Object[]{pkIds[i], leftPks.get(i), "china_individual"});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"sit"), (String)"insert into t_sitbs_certscenedetail(fid,fcertdetailid,fscene) values(?,?,?)", (List)params);
    }
}

