/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.mservice.update;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxPeriodUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxPeriodUpgradeService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String periodPrgSql = "select fid from t_sitbs_taxperiodprg where fcountryid = 1000001 and fid != 1463640374944791552";
        StringBuilder periodQuerySql = new StringBuilder("select a.fid, a.fenddate, a.fdeclareenddate from t_sitbs_taxperiod a where fid in (0");
        String periodUpdateSql = "update t_sitbs_taxperiod set fenddate = ?, fdeclareenddate = ? where fid = ?";
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"TaxPeriodUpgradeService1", (DBRoute)SITConstants.SIT_ROUTE, (String)periodPrgSql, (Object[])new Object[0]);){
            ArrayList periodPrgIds = Lists.newArrayListWithExpectedSize((int)100);
            while (dateSet.hasNext()) {
                periodPrgIds.add(dateSet.next().getLong("fid"));
            }
            if (CollectionUtils.isEmpty((Collection)periodPrgIds)) {
                UpgradeResult upgradeResult = new UpgradeResult();
                return upgradeResult;
            }
            for (Long periodPrgId : periodPrgIds) {
                periodQuerySql.append(", ").append(periodPrgId);
            }
            periodQuerySql.append(")");
            try (DataSet periodDateSet = SITDbUtil.queryDataSet((String)"TaxPeriodUpgradeService2", (DBRoute)SITConstants.SIT_ROUTE, (String)periodQuerySql.toString(), (Object[])new Object[0]);){
                ArrayList params = Lists.newArrayListWithExpectedSize((int)100);
                while (periodDateSet.hasNext()) {
                    Object[] item = new Object[3];
                    params.add(item);
                    Row next = periodDateSet.next();
                    item[0] = SitDateUtil.toLastSecond((Date)next.getDate("fenddate"));
                    item[1] = SitDateUtil.toLastSecond((Date)next.getDate("fdeclareenddate"));
                    item[2] = next.getLong("fid");
                }
                if (CollectionUtils.isEmpty((Collection)params)) return new UpgradeResult();
                SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)periodUpdateSql, (List)params);
                return new UpgradeResult();
            }
        }
        catch (Exception e) {
            LOGGER.error("TaxPeriodUpgradeService error", (Throwable)e);
        }
        return new UpgradeResult();
    }
}

