/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.accumulator;

import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbs.common.utils.StringCheckUtils;

public class AccumulatorHelper {
    public static String commonValidate(DynamicObject data) {
        String msg = "";
        msg = AccumulatorHelper.checkMemberEntry(data);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            return msg;
        }
        msg = AccumulatorHelper.checkFieldIllegal(data);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            return msg;
        }
        msg = AccumulatorHelper.checkStartDateAndEndDate(data);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            return msg;
        }
        msg = AccumulatorHelper.checkAccMemItem(data);
        return msg;
    }

    private static String checkMemberEntry(DynamicObject data) {
        String msg = "";
        DynamicObjectCollection accMemberEntry = data.getDynamicObjectCollection("entryentity");
        String status = data.getString("status");
        if ((StringUtils.equals((CharSequence)status, (CharSequence)"B") || StringUtils.equals((CharSequence)status, (CharSequence)"C")) && accMemberEntry.size() <= 0) {
            msg = ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0b\uff0c\u7d2f\u52a0\u6210\u5458\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorHelper_0", (String)"sit-sitbs-business", (Object[])new Object[0]);
        }
        return msg;
    }

    public static String checkFieldIllegal(DynamicObject data) {
        String msg = "";
        String name = data.getString("name");
        if (!StringUtils.isEmpty((CharSequence)name) && StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff08[\u3001]\uff09\u3002", (String)"AccumulatorHelper_1", (String)"sit-sitbs-business", (Object[])new Object[0]);
        }
        return msg;
    }

    public static String checkStartDateAndEndDate(DynamicObject data) {
        String msg = "";
        DynamicObjectCollection accMemberEntries = data.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : accMemberEntries) {
            Date startDate = entry.getDate("accmenstartdate");
            Date endDate = entry.getDate("accmemenddate");
            if (startDate == null || endDate == null || !startDate.after(endDate)) continue;
            msg = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorHelper_2", (String)"sit-sitbs-business", (Object[])new Object[0]);
            break;
        }
        return msg;
    }

    public static String checkAccMemItem(DynamicObject data) {
        String msg = "";
        DynamicObjectCollection accMemEntrys = data.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < accMemEntrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)accMemEntrys.get(i);
            DynamicObject taxItem = entry.getDynamicObject("taxitem");
            if (!ObjectUtils.isEmpty((Object)taxItem)) continue;
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u6210\u5458\u201d\u7b2c%1$s\u884c:\u201c\u7d2f\u52a0\u6210\u5458\u540d\u79f0\u201d\u3002", (String)"AccumulatorHelper_3", (String)"sit-sitbs-business", (Object[])new Object[0]), i + 1);
            break;
        }
        return msg;
    }
}

