/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.calrule;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class CalRuleHelper {
    public static DynamicObject[] getTaxItemsByTaxCategoryIdAndCountry(Long taxCategoryId, Long countryId) {
        HRBaseServiceHelper taxItemHelper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter qFilter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("country.id", "=", (Object)countryId);
        return taxItemHelper.query("id,taxcategories", new QFilter[]{qFilter});
    }

    public static List<DynamicObject> getFormulaDys(Object[] toAddFormulaIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcalformula");
        QFilter qFilter = new QFilter("id", "in", (Object)toAddFormulaIds);
        Object[] formulaDys = helper.query("id,resultitem", new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])formulaDys)) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)formulaDys.length);
        Map<Long, DynamicObject> resultMap = Arrays.stream(formulaDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        for (Object toAddFormulaId : toAddFormulaIds) {
            result.add(resultMap.get(toAddFormulaId));
        }
        return result;
    }

    public static void openFormulaSettingPage(IFormView formView, Long pkId, String name) {
        boolean hasPageermission = SITPermissionServiceHelper.hasViewPermission((String)"17/+7RIW4SCJ", (String)"sitbs_taxcalformula");
        if (!hasPageermission) {
            formView.showMessage(ResManager.loadKDString((String)"\u65e0\"\u8ba1\u7b97\u516c\u5f0f\"\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalRuleHelper_0", (String)"sit-sitbs-business", (Object[])new Object[0]));
            return;
        }
        CalRuleHelper.opeanFormulaPage(pkId, name, formView);
    }

    public static void opeanFormulaPage(Long pkId, String name, IFormView formView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("sitbs_taxcalformula");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setCustomParam("hide", (Object)YesOrNoEnum.YES.getCode());
        showParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f - {0}", (String)"CalRuleHelper_1", (String)"sit-sitbs-business", (Object[])new Object[0]), name));
        formView.showForm((FormShowParameter)showParameter);
    }

    public static boolean checkTaxCategoryAndCalrule(long taxCategoryId, long boid, long createOrgId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_calrule");
        QFilter qFilter = new QFilter("taxcategory.id", "=", (Object)taxCategoryId);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "in", (Object)new String[]{"C", "B"});
        qFilter.and("datastatus", "in", (Object)new String[]{"-3", "0", "1"});
        qFilter.and("boid", "!=", (Object)boid);
        qFilter.and("createorg.id", "=", (Object)createOrgId);
        Date date = DateUtils.parseDate((Object)"2999-12-31");
        qFilter.and("bsled", "=", (Object)date);
        return !helper.isExists(qFilter);
    }

    public static void checkSameTaxItemFormula(List<DynamicObject> formulaDys, List<DynamicObject> unPassFormulaDys) {
        Map<Long, List<DynamicObject>> groupMap = formulaDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("resultitem.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            unPassFormulaDys.addAll((Collection<DynamicObject>)entry.getValue());
        }
        formulaDys.removeAll(unPassFormulaDys);
    }

    public static void checkEntryFormula(List<DynamicObject> formulaDys, List<DynamicObject> unPassEntryFormulaDys, DynamicObjectCollection entryDys) {
        Set taxItemIds = entryDys.stream().map(dy -> dy.getLong("taxitem.id")).collect(Collectors.toSet());
        Iterator<DynamicObject> it = formulaDys.iterator();
        while (it.hasNext()) {
            DynamicObject formulaDy = it.next();
            long taxItemId = formulaDy.getLong("resultitem.id");
            if (!taxItemIds.contains(taxItemId)) continue;
            unPassEntryFormulaDys.add(formulaDy);
            it.remove();
        }
    }

    public static DynamicObject getCurrentVersionDy(long boid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_calrule");
        QFilter qFilter = new QFilter("boid", "=", (Object)boid);
        qFilter.and("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        return helper.queryOne("countrytype,country,currency,taxcategory,createorg", qFilter);
    }

    public static List<QFilter> getFormulaQFilter(String appId, Long orgId) {
        QFilter formula;
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)4);
        QFilter baseDataFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_taxcalformula", (Long)orgId);
        if (null != baseDataFilter) {
            qFilters.add(baseDataFilter);
        }
        if ((formula = SITPermissionServiceHelper.getDataRuleForBdProp((String)appId, (String)"sitbs_calrule", (String)"formula")) != null) {
            qFilters.add(formula);
        }
        return qFilters;
    }
}

