/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.multiview;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;

public enum AppAndCountryRefEnum {
    SI("sitbs_sappcountryrel", "si_currency_map_country"){

        @Override
        public Map<String, Object> getAppInfoBy(Long countryId) {
            return new HashMap<String, Object>(0);
        }

        @Override
        public Map<Long, DynamicObject> getAppInfoOfRegion(Collection<Long> regionIds) {
            return new HashMap<Long, DynamicObject>(0);
        }

        @Override
        public Map<Long, DynamicObject> getAppInfoOfAllRegions() {
            return Maps.newHashMap();
        }
    }
    ,
    SIT("sitbs_appcountryrel", "currency_map_country"){

        @Override
        public Map<String, Object> getAppInfoBy(Long countryId) {
            String sql = "id,app.id,app.number,isrelatedsalaryfile";
            DynamicObjectCollection appAndCountryRefDys = this.getAppAndCountryRefInfoBy(countryId, sql);
            if (appAndCountryRefDys == null || appAndCountryRefDys.isEmpty()) {
                return null;
            }
            HashMap<String, Object> cond = new HashMap<String, Object>(2);
            cond.put("taxAppNumber", ((DynamicObject)appAndCountryRefDys.get(0)).getString("app.number"));
            for (DynamicObject dynamicObject : appAndCountryRefDys) {
                if (!dynamicObject.getBoolean("isrelatedsalaryfile")) continue;
                cond.put("taxAppNumber", dynamicObject.getString("app.number"));
            }
            return cond;
        }

        @Override
        public Map<Long, DynamicObject> getAppInfoOfRegion(Collection<Long> regionIds) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_appcountryrel");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter auditFilter = new QFilter("status", "=", (Object)"C");
            QFilter appIdFilter = new QFilter("country.id", "in", regionIds);
            Object[] dynamicObjects = helper.query("id,country.id,app.id,app.number,isrelatedsalaryfile", new QFilter[]{enableFilter, auditFilter, appIdFilter});
            if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
            for (Object dynamicObject : dynamicObjects) {
                long key = dynamicObject.getLong("country.id");
                DynamicObject object = (DynamicObject)result.putIfAbsent(key, dynamicObject);
                if (object != null || !dynamicObject.getBoolean("isrelatedsalaryfile")) continue;
                result.put(key, dynamicObject);
            }
            return result;
        }

        @Override
        public Map<Long, DynamicObject> getAppInfoOfAllRegions() {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_appcountryrel");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter auditFilter = new QFilter("status", "=", (Object)"C");
            Object[] dynamicObjects = helper.query("id,country.id,app.id,app.number,isrelatedsalaryfile", new QFilter[]{enableFilter, auditFilter});
            if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
            for (Object dynamicObject : dynamicObjects) {
                long key = dynamicObject.getLong("country.id");
                DynamicObject object = (DynamicObject)result.putIfAbsent(key, dynamicObject);
                if (object != null || !dynamicObject.getBoolean("isrelatedsalaryfile")) continue;
                result.put(key, dynamicObject);
            }
            return result;
        }
    };

    private static final Log logger;
    private String appCountryRelEntityName;
    private String mapCountryKey;

    private AppAndCountryRefEnum(String appCountryRelEntityName, String mapCountryKey) {
        this.appCountryRelEntityName = appCountryRelEntityName;
        this.mapCountryKey = mapCountryKey;
    }

    public static AppAndCountryRefEnum getAppCountry(String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountry = null;
        for (AppAndCountryRefEnum appAndCountryRefEnum : AppAndCountryRefEnum.values()) {
            if (!appAndCountryRefEnum.appCountryRelEntityName.equals(appCountryRelEntityName)) continue;
            appCountry = appAndCountryRefEnum;
            break;
        }
        return appCountry;
    }

    public Map<String, String> getAppInfoFromDB(String appId) {
        String selectInfo = "id,country.id,country.name,currency.id,currency.number";
        DynamicObject dyObj = this.getCountryRefInfo(selectInfo, appId);
        if (dyObj != null) {
            HashMap appInfo = Maps.newHashMapWithExpectedSize((int)8);
            appInfo.put("id", dyObj.getString("id"));
            appInfo.put("countryid", dyObj.getString("country.id"));
            appInfo.put("country.name", dyObj.getString("country.name"));
            appInfo.put("currencyid", dyObj.getString("currency.id"));
            appInfo.put("currencynum", dyObj.getString("currency.number"));
            return appInfo;
        }
        return null;
    }

    public String getAppCountryRelEntityName() {
        return this.appCountryRelEntityName;
    }

    public String getMapCountryKey() {
        return this.mapCountryKey;
    }

    protected QFilter getAuditAndEnableFilter() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        return filter;
    }

    protected DynamicObject getCountryRefInfo(String selectInfo, String appId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getAppCountryRelEntityName());
        QFilter filter = this.getAuditAndEnableFilter();
        filter.and("app.number", "=", (Object)appId);
        return helper.queryOriginalOne(selectInfo, filter.toArray());
    }

    protected DynamicObjectCollection getAppAndCountryRefInfoBy(Long countryId, String sql) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getAppCountryRelEntityName());
        QFilter filter = this.getAuditAndEnableFilter();
        filter.and("country.id", "=", (Object)countryId);
        return helper.queryOriginalCollection(sql, filter.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAppInfo(String appId) {
        Map<String, Map<String, String>> appCountryMap = (HashMap)HRAppCache.get((String)"sitbs").get(this.getAppCountryRelEntityName(), Map.class);
        if (appCountryMap == null) {
            appCountryMap = new HashMap(16);
        }
        Map<String, String> appInfo = null;
        if (appCountryMap.get(appId) == null) {
            String key = this.getAppCountryRelEntityName() + "_" + appId;
            DLock dLock = DLock.create((String)key);
            try {
                dLock.lock();
                logger.info("\u5e94\u7528id\uff1a(" + appId + ")\u83b7\u5f97\u9501");
                appCountryMap = (Map)HRAppCache.get((String)"sitbs").get(this.getAppCountryRelEntityName(), Map.class);
                if (appCountryMap == null) {
                    appCountryMap = new HashMap(16);
                }
                if (appCountryMap.get(appId) == null) {
                    appInfo = this.getAppInfoFromDB(appId);
                    appCountryMap.put(appId, appInfo);
                }
                HRAppCache.get((String)"sitbs").put(this.getAppCountryRelEntityName(), appCountryMap);
            }
            finally {
                logger.info("\u5e94\u7528id\uff1a(" + appId + ")\u91ca\u653e\u9501");
                dLock.unlock();
                dLock.close();
            }
            return appInfo;
        }
        return (Map)appCountryMap.get(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrency(String countryNum) {
        String currencyId = null;
        Map<String, String> appCurrencyMap = (HashMap)HRAppCache.get((String)"sitbs").get(this.getMapCountryKey(), Map.class);
        if (appCurrencyMap == null) {
            appCurrencyMap = new HashMap(16);
        }
        if (appCurrencyMap.get(countryNum) == null) {
            String key = this.getAppCountryRelEntityName() + "_" + countryNum;
            DLock dLock = DLock.create((String)key);
            try {
                dLock.lock();
                logger.info("\u5e94\u7528id\uff1a(" + countryNum + ")\u83b7\u5f97\u9501");
                appCurrencyMap = (Map)HRAppCache.get((String)"sitbs").get(this.getMapCountryKey(), Map.class);
                if (appCurrencyMap == null) {
                    appCurrencyMap = new HashMap(16);
                }
                if (appCurrencyMap.get(countryNum) == null) {
                    currencyId = this.getCurrencyFromDB(countryNum);
                    appCurrencyMap.put(countryNum, currencyId);
                }
                HRAppCache.get((String)"sitbs").put(this.getMapCountryKey(), appCurrencyMap);
            }
            finally {
                logger.info("\u5e94\u7528id\uff1a(" + countryNum + ")\u91ca\u653e\u9501");
                dLock.unlock();
                dLock.close();
            }
            return currencyId;
        }
        return (String)appCurrencyMap.get(countryNum);
    }

    protected String getCurrencyFromDB(String countryNum) {
        String currencyId = null;
        if (countryNum != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getAppCountryRelEntityName());
            QFilter qFilter = new QFilter("country.number", "=", (Object)countryNum);
            DynamicObject dynamicObjects = serviceHelper.queryOriginalOne("currency.id", qFilter.toArray());
            currencyId = dynamicObjects.getString("currency.id");
        }
        return currencyId;
    }

    public void clearCache() {
        HRAppCache.get((String)"sitbs").remove(this.getAppCountryRelEntityName());
        HRAppCache.get((String)"sitbs").remove(this.getMapCountryKey());
    }

    public void updateAppCountryMap(List<String> appIds) {
        Map appCountryMap = (Map)HRAppCache.get((String)"sitbs").get(this.getAppCountryRelEntityName(), Map.class);
        if (appCountryMap != null) {
            for (String appId : appIds) {
                appCountryMap.remove(appId);
            }
            HRAppCache.get((String)"sitbs").put(this.getAppCountryRelEntityName(), (Object)appCountryMap);
        }
    }

    public abstract Map<String, Object> getAppInfoBy(Long var1);

    public abstract Map<Long, DynamicObject> getAppInfoOfRegion(Collection<Long> var1);

    public abstract Map<Long, DynamicObject> getAppInfoOfAllRegions();

    static {
        logger = LogFactory.getLog(AppAndCountryRefEnum.class);
    }
}

