/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.multiview;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbs.business.multiview.AppAndCountryRefEnum;
import org.apache.commons.collections.MapUtils;

public class AppCountryCacheService {
    private static final AppCountryCacheService appCountryCacheService = new AppCountryCacheService();

    public static AppCountryCacheService getInstance() {
        return appCountryCacheService;
    }

    private AppCountryCacheService() {
    }

    public void updateAppCountryMap(List<String> appIds, String billFormId) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(billFormId);
        if (appCountryEnum == null) {
            return;
        }
        appCountryEnum.updateAppCountryMap(appIds);
    }

    public Map<String, String> getAppInfoId(String appId, String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName);
        if (appCountryEnum == null) {
            return new HashMap<String, String>(0);
        }
        return appCountryEnum.getAppInfo(appId);
    }

    public Map<String, Object> getAppInfoBy(Map<String, Object> params, String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum;
        Long countryId = MapUtils.getLong(params, (Object)"taxRegionId");
        if (countryId == null || Long.valueOf(0L).equals(countryId) || (appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName)) == null) {
            return null;
        }
        return appCountryEnum.getAppInfoBy(countryId);
    }

    public String getCurrency(String countryNum, String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName);
        if (appCountryEnum == null) {
            return null;
        }
        return appCountryEnum.getCurrency(countryNum);
    }

    public Map<Long, DynamicObject> getAppInfoOfRegion(Collection<Long> regionIds, String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName);
        if (appCountryEnum == null || CollectionUtils.isEmpty(regionIds)) {
            return null;
        }
        return appCountryEnum.getAppInfoOfRegion(regionIds);
    }

    public Map<Long, DynamicObject> getAppInfoOfAllRegions(String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName);
        if (appCountryEnum == null) {
            return null;
        }
        return appCountryEnum.getAppInfoOfAllRegions();
    }

    public void clearCache(String appCountryRelEntityName) {
        AppAndCountryRefEnum appCountryEnum = AppAndCountryRefEnum.getAppCountry(appCountryRelEntityName);
        if (appCountryEnum == null) {
            return;
        }
        appCountryEnum.clearCache();
    }
}

