/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.multiview;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;

public class BelongCountryCacheService {
    private static final Log logger = LogFactory.getLog(BelongCountryCacheService.class);
    private static final BelongCountryCacheService belongCountryCacheService = new BelongCountryCacheService();

    public static BelongCountryCacheService getInstance() {
        return belongCountryCacheService;
    }

    private BelongCountryCacheService() {
    }

    public void updateBelongCountryMap(Long countryId) {
        Map belongCountryMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_belongcountry", Map.class);
        if (null != belongCountryMap) {
            belongCountryMap.remove(String.valueOf(countryId));
            HRAppCache.get((String)"sitbs").put("sitbs_belongcountry", (Object)belongCountryMap);
        }
    }

    public void updateBelongCountryMap(List<String> countryIds) {
        Map belongCountryMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_belongcountry", Map.class);
        if (null != belongCountryMap) {
            for (String countryId : countryIds) {
                belongCountryMap.remove(countryId);
            }
            HRAppCache.get((String)"sitbs").put("sitbs_belongcountry", (Object)belongCountryMap);
        }
    }

    public String getBelongCountry(Long countryId) {
        return this.getBelongCountry(countryId, "10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBelongCountry(Long countryId, String businessType) {
        String mapkey = businessType + countryId;
        Map<String, String> belongCountryMap = (HashMap)HRAppCache.get((String)"sitbs").get("sitbs_belongcountry", Map.class);
        String belongCountryId = null;
        if (null == belongCountryMap) {
            belongCountryMap = new HashMap(16);
        }
        if (null != belongCountryMap.get(mapkey)) return (String)belongCountryMap.get(mapkey);
        String key = "sitbs_belongcountry_" + mapkey;
        DLock dLock = DLock.create((String)key);
        try {
            dLock.lock();
            logger.info("\u56fd\u5bb6/\u5730\u533aid\uff1a{} \u91ca\u653e\u9501", (Object)mapkey);
            belongCountryMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_belongcountry", Map.class);
            if (null == belongCountryMap) {
                belongCountryMap = new HashMap(16);
            }
            if (null == belongCountryMap.get(mapkey)) {
                belongCountryId = this.getBelongCountryIdFromDB(countryId, businessType);
                belongCountryMap.put(mapkey, belongCountryId);
                logger.info("BelongCountryCacheService, getBelongCountryIdFromDB, belongCountryId is {}", (Object)belongCountryId);
            }
        }
        finally {
            logger.info("\u56fd\u5bb6/\u5730\u533aid\uff1a{} \u91ca\u653e\u9501", (Object)mapkey);
            dLock.unlock();
            dLock.close();
        }
        HRAppCache.get((String)"sitbs").put("sitbs_belongcountry", belongCountryMap);
        return belongCountryId;
    }

    private String getBelongCountryIdFromDB(Long countryId, String businessType) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_belongcountry");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter countryIdFilter = new QFilter("country", "=", (Object)countryId);
        QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)businessType);
        DynamicObject belongCountryDy = helper.queryOne("id", new QFilter[]{enableFilter, auditFilter, countryIdFilter, businessTypeFilter});
        if (null != belongCountryDy) {
            return belongCountryDy.getString("id");
        }
        return null;
    }

    public void clearCache() {
        HRAppCache.get((String)"sitbs").remove("sitbs_belongcountry");
    }
}

