/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.multiview;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbs.business.multiview.AppCountryCacheService;

public class GetAppInfoService {
    private static final GetAppInfoService getAppInfoService = new GetAppInfoService();

    public static GetAppInfoService getInstance() {
        return getAppInfoService;
    }

    private GetAppInfoService() {
    }

    public String getCountryId(String serviceAppId, String appCountryRelEntityName) {
        Map<String, String> appInfo = AppCountryCacheService.getInstance().getAppInfoId(serviceAppId, appCountryRelEntityName);
        return null != appInfo ? appInfo.get("countryid") : null;
    }

    public Map<String, String> getAppInfo(String serviceAppId, String appCountryRelEntityName) {
        return AppCountryCacheService.getInstance().getAppInfoId(serviceAppId, appCountryRelEntityName);
    }

    public Map<String, Object> getAppInfoBy(Map<String, Object> params, String appCountryRelEntityName) {
        return AppCountryCacheService.getInstance().getAppInfoBy(params, appCountryRelEntityName);
    }

    public DynamicObject queryAppInfoByCountryId(Long countryId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_appcountryrel");
        QFilter enableFilter = new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter appIdFilter = new QFilter("country.id", "=", (Object)countryId);
        return serviceHelper.queryOne("id,app.id,app.number,country,currency", new QFilter[]{enableFilter, auditFilter, appIdFilter});
    }

    public List<DynamicObject> getAllInfo() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_appcountryrel");
        DynamicObject[] result = serviceHelper.query("id,country,currency,issyspreset,isrelatedsalaryfile,complexmode,creator,enable", null);
        return Stream.of(result).collect(Collectors.toList());
    }
}

