/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.basecalrule.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbs.business.socinsurance.basecalrule.helper.SInsurBaseCalRuleHelper;
import kd.sit.sitbs.business.socinsurance.formula.helper.SInsurBaseCalFormulaHelper;
import kd.sit.sitbs.business.socinsurance.formula.service.SInsurBaseCalFormulaService;
import kd.sit.sitbs.business.socinsurance.insuranceitem.helper.SInsurItemHelper;

public class SInsurBaseCalRuleService {
    private SInsurBaseCalRuleService() {
    }

    public static SInsurBaseCalRuleService createInstance() {
        return new SInsurBaseCalRuleService();
    }

    public QFilter getCommonQFilter(DynamicObject dataEntity, String entityNumber) {
        QFilter filter = new QFilter("1", "!=", (Object)1);
        if (entityNumber != null) {
            switch (entityNumber) {
                case "sitbs_insuranceitem": {
                    long countryId = dataEntity.getLong("country.id");
                    filter = SInsurItemHelper.getValidPayBaseQFilter(countryId);
                    break;
                }
                case "sitbs_sinsurformula": {
                    filter = SInsurBaseCalFormulaService.createInstance().getQFilterForBaseRule(dataEntity.getLong("country.id"), entityNumber, dataEntity.getLong("createorg.id"), dataEntity.getDate("bsed"));
                    break;
                }
                default: {
                    filter.and("1", "!=", (Object)1);
                }
            }
            String fieldKey = this.getFieldKey(entityNumber);
            List insuranceIds = dataEntity.getDynamicObjectCollection("entryentity").stream().map(dyObj -> dyObj.getLong(fieldKey)).collect(Collectors.toList());
            if (insuranceIds.size() > 0) {
                filter.and("id", "not in", insuranceIds);
            }
        }
        return filter;
    }

    public String getFieldKey(String entityNumber) {
        return "sitbs_insuranceitem".equals(entityNumber) ? "insuritem.id" : "calformula.id";
    }

    public Object[] getSelectedInsuranceArr(DynamicObject dataEntity, String entityNumber, String fieldKey) {
        if (dataEntity == null || CollectionUtils.isEmpty((Collection)dataEntity.getDynamicObjectCollection("entryentity"))) {
            return new Object[0];
        }
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        List insuranceIds = entryEntity.stream().map(dyObj -> dyObj.getLong(fieldKey)).collect(Collectors.toList());
        QFilter filter = this.getCommonQFilter(dataEntity, entityNumber);
        filter.and("id", "in", insuranceIds);
        return SInsurBaseCalRuleHelper.getValidInsuranceIdArr(entityNumber, filter);
    }

    public boolean isCalFormulaInvalid(DynamicObject dataEntity, int rowIndex) {
        if (dataEntity == null) {
            return true;
        }
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (entryEntity.size() <= rowIndex) {
            return true;
        }
        DynamicObject entityDy = (DynamicObject)entryEntity.get(rowIndex);
        long calFormulaId = entityDy.getLong("calformula.id");
        long sinsurItemId = entityDy.getLong("insuritem.id");
        Date bsed = dataEntity.getDate("bsed");
        if (calFormulaId == 0L || sinsurItemId == 0L || bsed == null) {
            return true;
        }
        return SInsurBaseCalFormulaHelper.isCalFormulaExists(calFormulaId, sinsurItemId, bsed);
    }

    public Map<Long, Long> getFormulaAndRefItemMap(Collection<Long> formulaIds) {
        Map<Long, Long> formulaAndRefItemMap = SInsurBaseCalFormulaHelper.getFormulaAndRefItemMap(formulaIds);
        LinkedHashMap<Long, Long> resultMap = new LinkedHashMap<Long, Long>(formulaAndRefItemMap.size());
        for (Map.Entry<Long, Long> entry : formulaAndRefItemMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if (resultMap.containsValue(entry.getValue())) {
                resultMap.values().remove(entry.getValue());
            }
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    public Map<Long, DynamicObject> getCurrentCalFormulaVersionInfo(Collection<Long> validCalFormulaIds, Collection<Long> insuranceItemIds) {
        return SInsurBaseCalFormulaService.createInstance().getCalFormulaByIdAndInsuranceItem(validCalFormulaIds, insuranceItemIds);
    }

    public Map<Long, DynamicObject> getValidPayBaseInsuranceItem(Collection<Long> insuranceItemIds) {
        List<DynamicObject> validPayBaseInsuranceItemDys = SInsurItemHelper.getValidPayBaseInsuranceItem(insuranceItemIds);
        HashMap<Long, DynamicObject> insuranceItemIdAndRefCountryMap = new HashMap<Long, DynamicObject>(validPayBaseInsuranceItemDys.size());
        for (DynamicObject validPayBaseInsuranceItemDy : validPayBaseInsuranceItemDys) {
            insuranceItemIdAndRefCountryMap.put(validPayBaseInsuranceItemDy.getLong("id"), validPayBaseInsuranceItemDy);
        }
        return insuranceItemIdAndRefCountryMap;
    }
}

