/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.TaxItemService;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;

public class InsuranceItemServiceImpl
implements TaxItemService {
    public String name() {
        return "TaxItemService";
    }

    public Map<Long, TaxItemEntity> loadTaxItems(long countryId, long categoryId, long groupId, boolean status, QFilter ... preFilter) {
        List<QFilter> filters = InsuranceItemServiceImpl.genCommonFilter(countryId, status);
        if (preFilter != null) {
            filters.addAll(Arrays.asList(preFilter));
        }
        if (categoryId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid_id", "=", (Object)categoryId));
        }
        if (groupId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid.group.id", "=", (Object)groupId));
        }
        QFilter filter = this.converFilter(filters);
        QFilter comfilter = new QFilter("country.id", "=", (Object)0);
        comfilter.and("countrytype", "=", (Object)"0");
        filter.or(comfilter);
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxitem", (String[])new String[]{"id", "number", "status", "enable", "name", "taxcategories", "dataround", "datatype", "datalength", "caltaxtype", "incomeitem", "taxitemtype"}).subProp("dataprecision", new String[]{"scale"}).subProp("currency", new String[]{"amtprecision"}).subProp("splitalgo", new String[]{"implclasskey"});
        DynamicObject[] query = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{filter});
        LinkedHashMap<Long, TaxItemEntity> result = new LinkedHashMap<Long, TaxItemEntity>(query.length);
        for (DynamicObject obj : query) {
            long id = obj.getLong("id");
            TaxItemEntity item = new TaxItemEntity();
            item.setId(Long.valueOf(id));
            item.setNumber(obj.getString("number"));
            item.setName((Map)obj.getLocaleString("name"));
            item.setStatus(obj.getString("status"));
            item.setEnable(obj.getString("enable"));
            if (SitDataTypeEnum.AMOUNT.getId() == obj.getLong("datatype.id")) {
                item.setDataPrecisionScale(obj.getInt("currency.amtprecision"));
            } else {
                item.setDataPrecisionScale(obj.getInt("dataprecision.scale"));
            }
            item.setDataRoundId(obj.getLong("dataround.id"));
            item.setDatatypeId(obj.getLong("datatype.id"));
            item.setDataLength(obj.getInt("datalength"));
            item.setCaltaxtypeId(obj.getLong("caltaxtype.id"));
            item.setSplitAlgo(obj.getString("splitalgo.implclasskey"));
            item.setIncomeItem(obj.getBoolean("incomeitem"));
            item.setTaxItemType(Long.valueOf(obj.getLong("taxitemtype.id")));
            DynamicObjectCollection catObjs = obj.getDynamicObjectCollection("taxcategories");
            ArrayList<Long> cats = new ArrayList<Long>(catObjs.size());
            for (DynamicObject catObj : catObjs) {
                long catId = catObj.getLong("fbasedataid_id");
                cats.add(catId);
            }
            item.setCategories(cats);
            result.put(id, item);
        }
        return result;
    }

    private QFilter converFilter(List<QFilter> filters) {
        QFilter filter = filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter.and(filters.get(i));
        }
        return filter;
    }

    private static List<QFilter> genCommonFilter(Long countryId, boolean status) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("country.id", "=", (Object)countryId));
        if (status) {
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        return filters;
    }
}

