/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.formula.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbs.business.socinsurance.formula.constants.SInsurBaseCalFormulaConstants;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SInsurBaseCalFormulaHelper {
    private SInsurBaseCalFormulaHelper() {
    }

    public static Map<Long, Long> getFormulaAndRefItemMap(Collection<Long> formulaIds) {
        if (formulaIds == null || formulaIds.isEmpty()) {
            return new LinkedHashMap<Long, Long>(0);
        }
        QFilter filter = new QFilter("id", "in", formulaIds);
        DynamicObjectCollection formulaDys = SInsurBaseCalFormulaConstants.SINSUR_FORMULA_HELPER.queryOriginalCollection("id,resultitem.id", filter.toArray());
        if (formulaDys == null) {
            return new HashMap<Long, Long>(0);
        }
        return formulaDys.stream().collect(Collectors.toMap(formulaDy -> formulaDy.getLong("id"), formulaDy -> formulaDy.getLong("resultitem.id"), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
    }

    public static boolean isCalFormulaExists(long calFormulaId, long sinsurItemId, Date bsed) {
        QFilter filter = new QFilter("id", "=", (Object)calFormulaId);
        filter.and("resultitem", "=", (Object)sinsurItemId);
        filter.and(SInsuranceCommonService.getAuditEnableValidBsedQFilter(bsed));
        return SInsurBaseCalFormulaConstants.SINSUR_FORMULA_HELPER.isExists(filter);
    }

    public static QFilter getQFilterByIdAndInsuranceItem(Collection<Long> calFormulaIds, Collection<Long> sinsurItemIds) {
        QFilter filter = new QFilter("boid", "in", calFormulaIds);
        filter.and("resultitem", "in", sinsurItemIds);
        filter.and(SInsuranceCommonService.getAuditAndEnableQFilter());
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        return filter;
    }

    public static List<DynamicObject> getFormulaInfo(QFilter filter) {
        if (filter == null) {
            return new ArrayList<DynamicObject>(0);
        }
        DynamicObjectCollection formulaDys = SInsurBaseCalFormulaConstants.SINSUR_FORMULA_HELPER.queryOriginalCollection("boid,id,bsed,createorg.id,resultitem.id,firstbsed", filter.toArray());
        if (formulaDys == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return formulaDys;
    }
}

