/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.formula.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbs.business.socinsurance.basecalrule.constants.SInsurBaseCalRuleConstants;
import kd.sit.sitbs.business.socinsurance.formula.helper.SInsurBaseCalFormulaHelper;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SInsurBaseCalFormulaService {
    private SInsurBaseCalFormulaService() {
    }

    public static SInsurBaseCalFormulaService createInstance() {
        return new SInsurBaseCalFormulaService();
    }

    public QFilter getQFilterForBaseRule(Long countryId, String entityNumber, Long createOrgId, Date bsed) {
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        filter.and("country", "=", (Object)countryId);
        filter.and("firstbsed", "<=", (Object)bsed);
        filter.and(SITPermissionServiceHelper.getBaseDataFilter((String)entityNumber, (Long)createOrgId));
        filter.and("resultitem.insurancetypeattr", "in", SInsurBaseCalRuleConstants.DEFAULT_INSUR_TYPE_ATTR_ID_FOR_DATA_SRC_SET);
        return filter;
    }

    public Map<Long, DynamicObject> getCalFormulaByIdAndInsuranceItem(Collection<Long> calFormulaIds, Collection<Long> insuranceItemIds) {
        List<DynamicObject> calFormulaDys = SInsurBaseCalFormulaHelper.getFormulaInfo(SInsurBaseCalFormulaHelper.getQFilterByIdAndInsuranceItem(calFormulaIds, insuranceItemIds));
        HashMap<Long, DynamicObject> firstValidCalFormulaVersionInfo = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject calFormulaDy : calFormulaDys) {
            firstValidCalFormulaVersionInfo.put(calFormulaDy.getLong("boid"), calFormulaDy);
        }
        return firstValidCalFormulaVersionInfo;
    }
}

