/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.insuranceitem.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbs.business.socinsurance.insuranceitem.constants.SInsurItemConstants;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SInsurItemHelper {
    private SInsurItemHelper() {
    }

    public static QFilter getValidPayBaseQFilter(Long countryId) {
        QFilter filter = SInsurItemHelper.getValidPayBaseQFilterWithoutCountry();
        filter.and("country", "=", (Object)countryId);
        return filter;
    }

    public static QFilter getValidPayBaseQFilterWithoutCountry() {
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        filter.and("insurancetypeattr", "in", SInsurItemConstants.DEFAULT_INSUR_TYPE_ATTR_ID_FOR_DATA_SRC_SET);
        return filter;
    }

    public static List<DynamicObject> getValidPayBaseInsuranceItem(Collection<Long> insuranceItemIds) {
        QFilter insuranceItemQFilter = SInsurItemHelper.getValidPayBaseQFilterWithoutCountry();
        insuranceItemQFilter.and("id", "in", insuranceItemIds);
        DynamicObjectCollection insuranceItemDys = SInsurItemConstants.INSURANCE_ITEM_HELPER.queryOriginalCollection("id,country.id", insuranceItemQFilter.toArray());
        if (insuranceItemDys == null || insuranceItemDys.size() == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return insuranceItemDys;
    }
}

