/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.period.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;

public class SocInsurancePeriodHelper {
    public static Map<ExtendedDataEntity, String> validateRepeatDateInDB(List<ExtendedDataEntity> dataEntityList) {
        List<DynamicObject> periodPageList = dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Date minEntityStartDate = SocInsurancePeriodHelper.getPeriodMinOrMaxDate(periodPageList, "startdate", "min");
        Date maxEntityEndDate = SocInsurancePeriodHelper.getPeriodMinOrMaxDate(periodPageList, "enddate", "max");
        QFilter filter = new QFilter("periodtype.id", "=", (Object)periodPageList.get(0).getLong("periodtype.id"));
        List<DynamicObject> periodDBInfo = SocInsurancePeriodHelper.queryPeriodDys("id", filter);
        HashMap<Long, Integer> periodIdAndSeqMap = new HashMap<Long, Integer>(periodDBInfo.size());
        for (int i = 0; i < periodDBInfo.size(); ++i) {
            periodIdAndSeqMap.put(periodDBInfo.get(i).getLong("id"), i + 1);
        }
        filter.and("startdate", "<=", (Object)maxEntityEndDate);
        filter.and("enddate", ">=", (Object)minEntityStartDate);
        List<DynamicObject> periodDBList = SocInsurancePeriodHelper.queryPeriodDys("id,periodtype.name,startdate,enddate", filter);
        return SocInsurancePeriodHelper.checkPeriodsOverlapNew(dataEntityList, periodDBList, periodIdAndSeqMap);
    }

    public static Map<ExtendedDataEntity, String> checkPeriodsOverlapNew(List<ExtendedDataEntity> dataEntityList, List<DynamicObject> periodSourceList, HashMap<Long, Integer> periodIdAndSeqMap) {
        if (CollectionUtils.isEmpty(dataEntityList) || CollectionUtils.isEmpty(periodSourceList)) {
            return Collections.emptyMap();
        }
        LinkedHashMap msgMap = Maps.newLinkedHashMapWithExpectedSize((int)dataEntityList.size());
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        block0: while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            DynamicObject target = dataEntity.getDataEntity();
            Date targetStartDate = target.getDate("startdate");
            Date targetEndDate = target.getDate("enddate");
            for (DynamicObject source : periodSourceList) {
                Date sourceStartDate = source.getDate("startdate");
                Date sourceEndDate = source.getDate("enddate");
                String periodName = source.getString("periodtype.name");
                if (target.getLong("id") != 0L && source.getLong("id") == target.getLong("id") || targetStartDate == null || targetEndDate == null || sourceStartDate == null || sourceEndDate == null || targetStartDate.getTime() > sourceEndDate.getTime() || targetEndDate.getTime() < sourceStartDate.getTime()) continue;
                String sourceStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_sinsurperiod", (String)"startdate", (Date)source.getDate("startdate"));
                String sourceEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_sinsurperiod", (String)"enddate", (Date)source.getDate("enddate"));
                String targetStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_sinsurperiod", (String)"startdate", (Date)target.getDate("startdate"));
                String targetEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_sinsurperiod", (String)"enddate", (Date)target.getDate("enddate"));
                int seq = periodIdAndSeqMap.getOrDefault(source.getLong("id"), 1);
                msgMap.put(dataEntity, SocInsuranceErrInfoEnum.PERIOD_REPEAT.getErrInfo(targetStartDateFormat, targetEndDateFormat, periodName, seq, sourceStartDateFormat, sourceEndDateFormat));
                iterator.remove();
                continue block0;
            }
        }
        return msgMap;
    }

    private static Date getPeriodMinOrMaxDate(List<DynamicObject> periods, String field, String minOrMax) {
        Date dateResult = new Date();
        Optional<DynamicObject> result = "min".equals(minOrMax) ? periods.stream().min(Comparator.comparing(period -> period.getDate(field))) : periods.stream().max(Comparator.comparing(period -> period.getDate(field)));
        if (result.isPresent()) {
            dateResult = result.get().getDate(field);
        }
        return dateResult;
    }

    public static FormShowParameter getBatchGenerateResultForm(CloseCallBack closeCallback, int rowCount, int successCount, int failCount, Date startDate, boolean operationResult, List<String> message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("sitbs_generateresult");
        parameters.setShowTitle(false);
        parameters.setCloseCallBack(closeCallback);
        parameters.setCustomParam("rowCount", (Object)rowCount);
        parameters.setCustomParam("startDate", (Object)startDate);
        parameters.setCustomParam("successCount", (Object)successCount);
        parameters.setCustomParam("failCount", (Object)failCount);
        parameters.setCustomParam("operationResult", (Object)operationResult);
        StringBuilder buf = new StringBuilder();
        if (null != message) {
            int len = message.size();
            for (int index = 0; index < len; ++index) {
                buf.append("<div style='padding:10px;'>").append(message.get(index)).append("</div>");
            }
            parameters.setCustomParam("msg", (Object)buf.toString().trim());
        }
        return parameters;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        return cal.getTime();
    }

    public static Date calRightDate(boolean flag, Date date) {
        date = flag ? SocInsurancePeriodHelper.addMonth(date, 1) : SocInsurancePeriodHelper.getLastDayOfMonth(SocInsurancePeriodHelper.addMonth(date, 1));
        return date;
    }

    public static Date getRightDate(Date monthDateFlag, int day) {
        Date rightDate = day == 31 ? SocInsurancePeriodHelper.getLastDayOfMonth(monthDateFlag) : SocInsurancePeriodHelper.getCompleteDate(monthDateFlag, day - 1);
        return rightDate;
    }

    public static Date addMonth(Date startDate, int month) {
        LocalDateTime localDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(month);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getCompleteDate(Date startMonthDate, int day) {
        LocalDateTime localDateTime = startMonthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusDays(day);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean getRightDateFlag(int day) {
        boolean dayFlag = true;
        if (day == 31) {
            dayFlag = false;
        }
        return dayFlag;
    }

    public static Date getEndDate(int startDay, int endDay, Date startMonthDateFlag) {
        boolean endDayFlag = SocInsurancePeriodHelper.getRightDateFlag(endDay);
        Date endDate = !endDayFlag ? SocInsurancePeriodHelper.getLastDayOfMonth(startMonthDateFlag) : (startDay > endDay ? SocInsurancePeriodHelper.getCompleteDate(SocInsurancePeriodHelper.addMonth(startMonthDateFlag, 1), endDay - 1) : SocInsurancePeriodHelper.getCompleteDate(startMonthDateFlag, endDay - 1));
        return endDate;
    }

    public static BasedataEntityType getBaseDataEntityType(String entityName, String pkId) {
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dynamicObject = periodHelper.generateDynamicObject((Object)pkId, "number,name");
        return (BasedataEntityType)dynamicObject.getDataEntityType();
    }

    public static Map<Object, BaseDataCheckRefrenceResult> baseDataCheckReference(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }

    public static void setPeriodInfo(DynamicObject[] newPeriods) {
        SocInsurancePeriodHelper.setPeriodNumber(newPeriods);
        for (DynamicObject newperiod : newPeriods) {
            if (HRStringUtils.isEmpty((String)newperiod.getString("name"))) {
                newperiod.set("name", newperiod.get("number"));
            }
            newperiod.set("status", (Object)"C");
        }
    }

    private static void setPeriodNumber(DynamicObject[] newperiods) {
        DynamicObject periodtype = newperiods[0].getDynamicObject("periodtype");
        String periodNumberPrefix = periodtype.getString("periodnumberprefix");
        String periodNumberSuffix = periodtype.getString("periodnumbersuffix");
        String subjectNumberField = periodtype.getString("periodnumbersubject");
        int serialNumberValue = periodtype.getInt("serialnumber");
        long periodTypeId = periodtype.getLong("id");
        List<DynamicObject> resultPeriods = SocInsurancePeriodHelper.getGeneratePeriodNumberData(subjectNumberField, newperiods);
        if (serialNumberValue == 0) {
            for (DynamicObject period : resultPeriods) {
                String subjectNumberValue = SocInsurancePeriodHelper.getSubjectNumberValue(period, subjectNumberField);
                String periodNumber = period.getString("number");
                if (!HRStringUtils.isEmpty((String)periodNumber)) continue;
                period.set("number", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix));
            }
        } else {
            List<DynamicObject> allPeriods = SocInsurancePeriodHelper.getAllPeriods(periodTypeId, newperiods);
            Map<String, List<DynamicObject>> groupSubjectNumber = SocInsurancePeriodHelper.groupBySubjectNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, resultPeriods);
            for (Map.Entry<String, List<DynamicObject>> entrySet : groupSubjectNumber.entrySet()) {
                String number = entrySet.getKey();
                List<DynamicObject> groupDynamicObject = entrySet.getValue();
                int max = SocInsurancePeriodHelper.getMaxSerialNumber(allPeriods, number);
                SocInsurancePeriodHelper.generatePeriodNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, serialNumberValue, groupDynamicObject, max);
            }
        }
    }

    private static List<DynamicObject> getGeneratePeriodNumberData(String subjectNumberField, DynamicObject[] newPeriodDys) {
        List<Object> resultPeriods = new ArrayList(newPeriodDys.length);
        HashSet periodIds = Sets.newHashSetWithExpectedSize((int)newPeriodDys.length);
        for (DynamicObject newPeriod : newPeriodDys) {
            boolean fromDatabase = newPeriod.getDataEntityState().getFromDatabase();
            if (!fromDatabase) continue;
            periodIds.add((Long)newPeriod.getPkValue());
        }
        if (CollectionUtils.isEmpty((Collection)periodIds)) {
            resultPeriods = Arrays.stream(newPeriodDys).collect(Collectors.toList());
        } else {
            List<DynamicObject> oldPeriodDys = SocInsurancePeriodHelper.queryPeriodDys("id,number,perioddate,startdate,enddate", new QFilter("id", "in", (Object)periodIds));
            if (!CollectionUtils.isEmpty(oldPeriodDys)) {
                Map<Object, DynamicObject> oldPeriodMap = oldPeriodDys.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, po -> po, (oldVal, newVal) -> oldVal));
                for (DynamicObject period : newPeriodDys) {
                    DynamicObject oldPeriod = oldPeriodMap.get(period.getPkValue());
                    if (oldPeriod != null) {
                        String oldSubjectNumberValue;
                        String subjectNumberValue = SocInsurancePeriodHelper.getSubjectNumberValue(period, subjectNumberField);
                        if (HRStringUtils.equals((String)subjectNumberValue, (String)(oldSubjectNumberValue = SocInsurancePeriodHelper.getSubjectNumberValue(oldPeriod, subjectNumberField)))) continue;
                        resultPeriods.add(period);
                        continue;
                    }
                    resultPeriods.add(period);
                }
            } else {
                resultPeriods = Arrays.stream(newPeriodDys).collect(Collectors.toList());
            }
        }
        return resultPeriods;
    }

    private static List<DynamicObject> getAllPeriods(long periodTypeId, DynamicObject[] newPeriods) {
        List<DynamicObject> allPeriods = SocInsurancePeriodHelper.queryPeriodDys("id,periodtype,number", SocInsurancePeriodHelper.getPeriodQFilter(null, periodTypeId));
        for (DynamicObject newPeriod : newPeriods) {
            if (newPeriod.getDataEntityState().getFromDatabase()) continue;
            allPeriods.add(newPeriod);
        }
        return allPeriods;
    }

    private static void generatePeriodNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, int serialnumberValue, List<DynamicObject> groupDynamicObject, int max) {
        for (DynamicObject dynamicObject : groupDynamicObject) {
            if (dynamicObject.getDataEntityState().getFromDatabase()) continue;
            String subjectNumberValue = SocInsurancePeriodHelper.getSubjectNumberValue(dynamicObject, subjectNumberField);
            dynamicObject.set("number", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix + String.format(Locale.ROOT, "%0" + serialnumberValue + "d", ++max)));
        }
    }

    private static int getMaxSerialNumber(List<DynamicObject> Periods, String number) {
        int max = 0;
        for (DynamicObject period : Periods) {
            String periodNumber = period.getString("number");
            if (!HRStringUtils.isNotEmpty((String)periodNumber) || !HRStringUtils.equals((String)number, (String)periodNumber.substring(0, number.length()))) continue;
            int order = Integer.parseInt(periodNumber.substring(number.length()));
            max = Integer.max(max, order);
        }
        return max;
    }

    private static Map<String, List<DynamicObject>> groupBySubjectNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, List<DynamicObject> periods) {
        HashMap<String, List<DynamicObject>> groupSubjectNumber = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject period : periods) {
            String subjectNumber = SocInsurancePeriodHelper.getSubjectNumberValue(period, subjectNumberField);
            String number = periodNumberPrefix + subjectNumber + periodNumberSuffix;
            List groupCalPeriods = groupSubjectNumber.computeIfAbsent(number, key -> new ArrayList(10));
            groupCalPeriods.add(period);
        }
        return groupSubjectNumber;
    }

    private static String getSubjectNumberValue(DynamicObject calPeriod, String subjectNumberField) {
        switch (subjectNumberField) {
            case "perioddate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("perioddate"), (String)"yyyyMM");
            }
            case "startdate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("startdate"), (String)"yyyyMMdd");
            }
            case "enddate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("enddate"), (String)"yyyyMMdd");
            }
        }
        return "";
    }

    public static List<DynamicObject> queryPeriodTypeDys(String selectInfo, QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurperiodtype");
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)helper.queryOriginalCollection(selectInfo, filter.toArray(), "country asc"));
    }

    public static List<DynamicObject> queryPeriodDys(String selectInfo, QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurperiod");
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)helper.queryOriginalCollection(selectInfo, filter.toArray(), "perioddate desc, name desc"));
    }

    public static QFilter getPeriodQFilter(Long countryId, Long periodTypeId) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (countryId != null) {
            filter.and("country.id", "=", (Object)countryId);
        }
        if (periodTypeId != null) {
            filter.and("periodtype.id", "=", (Object)periodTypeId);
        }
        return filter;
    }

    public static QFilter getPeriodQFilter(Collection<String> numbers, Collection<String> names, Long periodTypeId, Collection<Long> periodIds) {
        QFilter idFilter = new QFilter("id", "not in", periodIds);
        QFilter numNameFilter = new QFilter("number", "in", numbers);
        numNameFilter.or("name", "in", names);
        QFilter periodTypeFilter = new QFilter("periodtype.id", "=", (Object)periodTypeId);
        periodTypeFilter.and(numNameFilter).and(idFilter);
        return periodTypeFilter;
    }

    public static QFilter getPeriodTypeQFilter(Long countryId, String calFrequencyType, Long periodTypeId) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (countryId != null) {
            filter.and("country.id", "=", (Object)countryId);
        }
        if (!HRStringUtils.isEmpty((String)calFrequencyType)) {
            filter.and("calfrequency.type", "=", (Object)calFrequencyType);
        }
        if (periodTypeId != null) {
            filter.and("id", "!=", (Object)periodTypeId);
        }
        return filter;
    }

    public static DynamicObject getFrequencyDy(Long frequencyId) {
        return new HRBaseServiceHelper("sitbs_calfrequency").loadSingle((Object)frequencyId);
    }
}

