/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.service;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbs.business.multiview.GetAppInfoService;

public class SInsuranceCommonService {
    private static final Log log = LogFactory.getLog(SInsuranceCommonService.class);
    private static final String[] VALID_DATA_STATUSES = new String[]{"1", "0", "2"};

    private SInsuranceCommonService() {
    }

    public static SInsuranceCommonService createInstance() {
        return new SInsuranceCommonService();
    }

    public void multiSetBeforeF7SelectListener(Object plugin, String ... fieldArr) {
        Optional.ofNullable(fieldArr).filter(arr -> !HRArrayUtils.isEmpty((Object[])fieldArr)).ifPresent(arr -> {
            for (String field : arr) {
                BasedataEdit baseDataEdit = (BasedataEdit)((AbstractBasePlugIn)plugin).getControl(field);
                baseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
            }
        });
    }

    public void setDefaultCountryAndCurrency(Object pluginOBj, List<String> fields) {
        HashMap<String, String> defaultFieldMap = new HashMap<String, String>(4);
        defaultFieldMap.put("country", "countryid");
        defaultFieldMap.put("currency", "currencyid");
        if (CollectionUtils.isEmpty(fields) || !defaultFieldMap.keySet().containsAll(fields)) {
            return;
        }
        AbstractBasePlugIn plugIn = (AbstractBasePlugIn)pluginOBj;
        IFormView iFormView = plugIn.getView();
        IDataModel model = plugIn.getView().getModel();
        String serviceAppId = iFormView.getFormShowParameter().getCheckRightAppId();
        if (serviceAppId == null) {
            return;
        }
        Map<String, String> appInfo = GetAppInfoService.getInstance().getAppInfo(serviceAppId, "sitbs_sappcountryrel");
        for (String field : fields) {
            String fieldId;
            if (appInfo == null || (fieldId = appInfo.get(defaultFieldMap.get(field))) == null || fieldId.equals(model.getDataEntity().getString(field + ".id"))) continue;
            model.setValue(field, (Object)Long.valueOf(fieldId));
            iFormView.setEnable(Boolean.FALSE, new String[]{field});
            iFormView.updateView(field);
        }
        model.setDataChanged(false);
    }

    public static Long getCountryIdByAppId(String serviceAppId) {
        if (serviceAppId == null) {
            return null;
        }
        Map<String, String> appInfo = GetAppInfoService.getInstance().getAppInfo(serviceAppId, "sitbs_sappcountryrel");
        if (appInfo != null && appInfo.get("countryid") != null) {
            return Long.valueOf(appInfo.get("countryid"));
        }
        return null;
    }

    public static QFilter getAuditEnableAndValidQFilter() {
        QFilter auditAndEnableQFilter = SInsuranceCommonService.getAuditAndEnableQFilter();
        auditAndEnableQFilter.and(SInsuranceCommonService.getDataStatusQFilter());
        auditAndEnableQFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        return auditAndEnableQFilter;
    }

    public static QFilter getAuditEnableValidBsedQFilter(Date endDate) {
        QFilter auditAndEnableQFilter = SInsuranceCommonService.getAuditEnableAndValidQFilter();
        auditAndEnableQFilter.and(SInsuranceCommonService.getDateFilter(endDate));
        return auditAndEnableQFilter;
    }

    public static QFilter getAuditAndEnableQFilter() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        return filter;
    }

    public static QFilter getDataStatusQFilter() {
        return new QFilter("datastatus", "in", (Object)VALID_DATA_STATUSES);
    }

    public static QFilter getDateFilter(Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        filter.and("bsled", ">=", (Object)endDate);
        return filter;
    }

    public void lockCommonFields(IFormView iFormView) {
        if (iFormView != null && BaseDataHisHelper.isHisPage((IFormView)iFormView)) {
            BasedataEdit basedataEdit;
            TextEdit numberEdit = (TextEdit)iFormView.getControl("number");
            if (numberEdit != null) {
                numberEdit.setEnable(null, false, 0);
            }
            if ((basedataEdit = (BasedataEdit)iFormView.getControl("country")) != null) {
                basedataEdit.setEnable(null, false, 0);
            }
        }
    }

    public Map<Long, Map<String, String>> getInsuranceItemByStatus(List<Long> ids, Integer status) {
        HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter qFilter = Integer.valueOf(0).equals(status) ? new QFilter("1", "=", (Object)1) : new QFilter("id", "in", ids);
        DynamicObject[] items = itemHelper.query("id,group.name,name,number,datatype.id,datatype.storagetype", qFilter.toArray());
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject item : items) {
            HashMap<String, String> filedMap = new HashMap<String, String>(16);
            filedMap.put("groupname", item.getString("group.name"));
            filedMap.put("insuranceitemname", item.getString("name"));
            filedMap.put("insuranceitemnumber", item.getString("number"));
            filedMap.put("storagetype", item.getString("datatype.storagetype"));
            filedMap.put("datatypeId", item.getString("datatype.id"));
            resultMap.put(item.getLong("id"), filedMap);
        }
        return resultMap;
    }

    public Map<Long, Map<String, String>> getInsuranceItemByIds(List<Long> ids) {
        return this.getInsuranceItemByStatus(ids, 1);
    }

    public static Map<String, String> getCountryInfoForAppIdByOption(OperateOption operateOption) {
        Map<String, String> appInfo;
        String appId;
        if (operateOption != null && (appId = operateOption.getVariableValue("currbizappid", null)) != null && (appInfo = GetAppInfoService.getInstance().getAppInfo(appId, "sitbs_sappcountryrel")) != null) {
            return appInfo;
        }
        return new HashMap<String, String>(0);
    }

    public static String checkCountryWhenImport(Map<String, String> appInfo, String countryIdStr, String errInfo) {
        String appDefaultCountryId;
        if (!CollectionUtils.isEmpty(appInfo) && HRStringUtils.isNotEmpty((String)countryIdStr) && (appDefaultCountryId = appInfo.get("countryid")) != null && !appDefaultCountryId.equals(countryIdStr)) {
            return MessageFormat.format(errInfo, appInfo.get("country.name"), appInfo.get("country.name"));
        }
        return null;
    }

    public List<Long> getInsuranceItemIdsByFilters(List<QFilter> filters) {
        HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("sitbs_insuranceitem");
        DynamicObjectCollection items = itemHelper.queryOriginalCollection("id", filters.toArray(new QFilter[0]));
        List<Long> ids = items.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        return ids;
    }

    public static OperationResult saveDynamicObject(Collection<DynamicObject> newDys, String status) {
        String opName;
        if (CollectionUtils.isEmpty(newDys)) {
            return null;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        if ("new".equals(status)) {
            operateOption.setVariableValue("status", status);
            opName = "save";
        } else if ("A".equals(status)) {
            operateOption.setVariableValue("status", status);
            opName = "save";
        } else if ("C".equals(status)) {
            opName = "confirmchange";
        } else {
            return null;
        }
        return opImpl.localInvokeOperation(opName, newDys.toArray(new DynamicObject[0]), operateOption);
    }
}

