/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standard.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbs.business.socinsurance.constants.SInsuranceConstants;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standard.constants.SocInsuranceStandardConstants;

public class SocInsuranceStandardHelper {
    private SocInsuranceStandardHelper() {
    }

    public static List<DynamicObject> queryDefaultInsurTypeInfo(QFilter filter, boolean enableAndAudit) {
        if (filter == null) {
            return new ArrayList<DynamicObject>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_welfaretype");
        if (enableAndAudit) {
            QFilter auditAndEnableQFilter = SInsuranceCommonService.getAuditAndEnableQFilter();
            filter.and(auditAndEnableQFilter);
        }
        DynamicObjectCollection insurTypeDys = helper.queryOriginalCollection("id, name, number, currency.amtprecision", filter.toArray(), "number asc");
        return insurTypeDys;
    }

    public static DynamicObject[] queryInsurItemInfo(Collection<Long> insurTypeIds, Long countryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter filter = new QFilter("insurtype", "in", insurTypeIds);
        filter.and(SInsuranceCommonService.getAuditAndEnableQFilter());
        filter.and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()));
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        countryId = countryId == null ? Long.valueOf(1000001L) : countryId;
        filter.and("country", "=", (Object)countryId);
        Object[] cfgDyArr = helper.loadDynamicObjectArray(filter.toArray());
        if (cfgDyArr != null && cfgDyArr.length > 0) {
            ArrayList cfgDys = Lists.newArrayList((Object[])cfgDyArr);
            Iterator iterator = cfgDys.iterator();
            while (iterator.hasNext()) {
                DynamicObject cfgDy = (DynamicObject)iterator.next();
                DynamicObjectCollection resultEntityEntry = cfgDy.getDynamicObjectCollection("rentryentity");
                Iterator resultIt = resultEntityEntry.iterator();
                while (resultIt.hasNext()) {
                    DynamicObject resultEntity = (DynamicObject)resultIt.next();
                    if (SocInsuranceStandardHelper.isValid(resultEntity)) continue;
                    resultIt.remove();
                }
                if (!resultEntityEntry.isEmpty()) continue;
                iterator.remove();
            }
            cfgDyArr = cfgDys.toArray(new DynamicObject[0]);
        }
        return cfgDyArr;
    }

    public static DynamicObjectCollection queryInsurItemInfoById(Collection<Long> insurItemIds, Long countryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter filter = new QFilter("id", "in", insurItemIds);
        long crrCountryId = countryId == null ? SInsuranceConstants.COUNTRY_ID_CHINA : (long)countryId.intValue();
        filter.and("country.id", "=", (Object)crrCountryId);
        String selectFields = "id, group,insurancetypeattr.id,insurancetypeattr.name,insurancetypeattr.number,datatype.id,datatype.number,dataprecision.id,dataprecision.number,dataprecision.scale";
        return helper.queryOriginalCollection(selectFields, filter.toArray());
    }

    public static Map<String, LinkedHashMap<String, Object>> queryStdDimAttrLinkedMap() {
        LinkedHashMap<String, LinkedHashMap<String, Object>> stdDimAttrLinkedMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>(16);
        for (String baseType : SocInsuranceStandardConstants.DEFAULT_BASE_TYPES) {
            String entityName = "1".equals(baseType) ? "hbss_category" : "sitbs_registertype";
            String fieldKey = "bt" + baseType + '_';
            Map baseTypeNamLinkedMap = stdDimAttrLinkedMap.computeIfAbsent(fieldKey, key -> new LinkedHashMap(16));
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection baseTypeDyColl = helper.queryOriginalCollection("id, name", filter.toArray(), "id asc");
            baseTypeDyColl.forEach(baseTypeDy -> baseTypeNamLinkedMap.put(baseTypeDy.getString("id"), baseTypeDy.getString("name")));
        }
        return stdDimAttrLinkedMap;
    }

    public static List<DynamicObject> queryInfoByEntityName(String entityName, QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return Arrays.asList(helper.loadDynamicObjectArray(filter.toArray()));
    }

    public static Set<Long> queryFeatureBoId(Collection<Long> insurStdBoIdSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter filter = new QFilter("boid", "in", insurStdBoIdSet);
        filter.and("iscurrentversion", "=", (Object)"0");
        filter.and("datastatus", "in", (Object)DataStatusEnum.TO_EFFECT.getCode());
        DynamicObjectCollection stdDys = helper.queryOriginalCollection("boid", filter.toArray());
        return stdDys.stream().map(stdDy -> stdDy.getLong("boid")).collect(Collectors.toSet());
    }

    public static Date getDefaultBsled() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2999);
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static List<DynamicObject> queryInsurPropBy(Collection<Long> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceprop");
        DynamicObject[] insurancePropDys = helper.loadDynamicObjectArray(new QFilter("id", "in", pkIds).toArray());
        return Optional.ofNullable(insurancePropDys).map(Arrays::asList).orElseGet(() -> Collections.emptyList());
    }

    public static Set<Long> queryResultCoverInsurType(Collection<Long> insurTypeIds) {
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_sinsurstdcfg");
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        if (insurTypeIds != null && insurTypeIds.size() > 0) {
            filter.and(new QFilter("insurtype.id", "in", insurTypeIds));
        }
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and("datastatus", "=", (Object)"1");
        Object[] cfgDys = helper.loadDynamicObjectArray(filter.toArray());
        if (cfgDys == null || cfgDys.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Long> resultCoverInsurTypeIds = new HashSet<Long>(cfgDys.length);
        ArrayList currCfgDys = Lists.newArrayList((Object[])cfgDys);
        for (DynamicObject cfgDy : currCfgDys) {
            long insurTypeId = cfgDy.getLong("insurtype.id");
            DynamicObjectCollection resultEntityEntry = cfgDy.getDynamicObjectCollection("rentryentity");
            int validSize = 0;
            for (DynamicObject resultEntity : resultEntityEntry) {
                if (!SocInsuranceStandardHelper.isValid(resultEntity)) continue;
                ++validSize;
            }
            if (validSize != 0) continue;
            resultCoverInsurTypeIds.add(insurTypeId);
        }
        return resultCoverInsurTypeIds;
    }

    private static boolean isValid(DynamicObject resultEntity) {
        return "1".equals(resultEntity.getString("isuseroundtype")) || "T".equals(resultEntity.getString("datasrc"));
    }
}

