/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standard.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.standard.constants.SocInsuranceStandardConstants;
import kd.sit.sitbs.business.socinsurance.standard.service.DyStandardEntityService;

public class DimDyStandardEntityService
extends DyStandardEntityService {
    public DimDyStandardEntityService(DetailStandardDimDTO detailStandardDimDTO) {
        super(detailStandardDimDTO);
    }

    @Override
    public void createEntryAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        for (String baseType : SocInsuranceStandardConstants.DEFAULT_BASE_TYPES) {
            String id = "bt" + baseType + '_';
            if (!this.getDetailStandardDimDTO().getFieldSet().contains(id)) continue;
            this.setId(id);
            String name = "0".equals(baseType) ? SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE.getErrInfo() : SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo();
            this.setName(name);
            this.getEntityControlAp(entityMetadata, entryAp);
        }
    }

    @Override
    protected void getEntityControlAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setKey(this.getId());
        fieldAp.setName(new LocaleString(this.getName()));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFieldTextAlign("center");
        fieldAp.setTextAlign("center");
        this.createFieldByType(fieldAp, entityMetadata);
        entryAp.getItems().add(fieldAp);
    }

    @Override
    public void createFieldByType(EntryFieldAp fieldAp, EntityMetadata entityMetadata) {
        ComboField comboField = new ComboField();
        comboField.setId(this.getId());
        comboField.setKey(this.getId());
        comboField.setFeatures(new Features());
        comboField.setEntityMetadata(entityMetadata);
        LinkedHashMap<String, Object> idAndNameLinkedMap = this.getDetailStandardDimDTO().getNameMap().get(this.getId());
        if (idAndNameLinkedMap != null) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
            for (Map.Entry<String, Object> idAndNameLinkedEntry : idAndNameLinkedMap.entrySet()) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString((String)idAndNameLinkedEntry.getValue()));
                comboItem.setValue(idAndNameLinkedEntry.getKey());
                comboItem.setItemVisible(true);
                items.add(comboItem);
            }
            comboField.setItems(items);
        }
        comboField.setMustInput(true);
        comboField.setMustInputType(1);
        fieldAp.setField((Field)comboField);
    }

    @Override
    public void createProperties(EntryType entryType) {
        for (String baseType : SocInsuranceStandardConstants.DEFAULT_BASE_TYPES) {
            String id = "bt" + baseType + '_';
            if (!this.getDetailStandardDimDTO().getFieldSet().contains(id)) continue;
            this.setId(id);
            String name = "0".equals(baseType) ? SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE.getErrInfo() : SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo();
            this.setName(name);
            this.registerSimpleProperty(entryType);
        }
    }

    @Override
    protected void registerSimpleProperty(EntryType entryType) {
        ComboProp prop = new ComboProp();
        prop.setName(this.getId());
        prop.setEnableNull(false);
        prop.setDbIgnore(true);
        prop.setAlias(null);
        prop.setDisplayName(new LocaleString(this.getName()));
        prop.setFeatures(new Features().getValue());
        prop.setShowStyle(1);
        prop.setMustInput(true);
        LinkedHashMap<String, Object> idAndNameLinkedMap = this.getDetailStandardDimDTO().getNameMap().get(this.getId());
        if (idAndNameLinkedMap != null) {
            ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(10);
            for (Map.Entry<String, Object> idAndNameLinkedEntry : idAndNameLinkedMap.entrySet()) {
                ValueMapItem comboItem = new ValueMapItem();
                comboItem.setName(new LocaleString((String)idAndNameLinkedEntry.getValue()));
                comboItem.setValue(this.getId() + idAndNameLinkedEntry.getKey());
                comboItem.setItemVisible(true);
                comboItems.add(comboItem);
            }
            prop.setComboItems(comboItems);
        }
        prop.setMustInput(true);
        entryType.registerSimpleProperty((DynamicSimpleProperty)prop);
    }

    @Override
    public Object getFieldValue(int depth) {
        return null;
    }
}

