/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standard.service;

import java.util.LinkedHashMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.standard.service.DyStandardEntityService;

public class ItemDyStandardEntityService
extends DyStandardEntityService {
    public ItemDyStandardEntityService(DetailStandardDimDTO detailStandardDimDTO) {
        super(detailStandardDimDTO);
    }

    @Override
    public void createEntryAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        for (String fieldKey : this.getDetailStandardDimDTO().getFieldSet()) {
            if (!fieldKey.contains("it")) continue;
            this.setId(fieldKey);
            String insurItemIdStr = fieldKey.substring("it".length());
            LinkedHashMap<String, Object> itemAttr = this.getDetailStandardDimDTO().getNameMap().get(insurItemIdStr);
            this.setDataTypeId(Long.parseLong(String.valueOf(itemAttr.get("datatype.id"))));
            int currAccuracy = (Integer)itemAttr.getOrDefault("dataprecision.scale", 0);
            if (InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getNumber().equals(itemAttr.get("insurancetypeattr.number")) || InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getNumber().equals(itemAttr.get("insurancetypeattr.number"))) {
                this.setDataScope("[0,100]");
                this.setName(itemAttr.get("insurancetypeattr.name") + "(%)");
                currAccuracy -= 2;
                currAccuracy = Math.max(currAccuracy, 0);
            } else {
                this.setDataScope("[0,]");
                this.setName((String)itemAttr.get("insurancetypeattr.name"));
            }
            this.setAccuracy(currAccuracy);
            this.getEntityControlAp(entityMetadata, entryAp);
        }
    }

    @Override
    protected void getEntityControlAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setKey(this.getId());
        fieldAp.setName(new LocaleString(this.getName()));
        this.setFieldWith(fieldAp);
        fieldAp.setFireUpdEvt(true);
        this.createFieldByType(fieldAp, entityMetadata);
        fieldAp.setFieldTextAlign("center");
        fieldAp.setTextAlign("center");
        entryAp.getItems().add(fieldAp);
    }

    @Override
    protected void createFieldByType(EntryFieldAp fieldAp, EntityMetadata entityMetadata) {
        SitDataTypeEnum dataType = this.getDataType();
        if (dataType.getId() == SitDataTypeEnum.NUMBER.getId() || dataType.getId() == SitDataTypeEnum.AMOUNT.getId()) {
            DecimalField decimalField = new DecimalField();
            decimalField.setId(this.getId());
            decimalField.setKey(this.getId());
            decimalField.setEnableNull(true);
            decimalField.setScale(this.getAccuracy());
            decimalField.setPrecision(23);
            decimalField.setDataScope(this.getDataScope());
            decimalField.setZeroShow(true);
            decimalField.setFeatures(new Features());
            decimalField.setMustInput(true);
            decimalField.setMustInputType(1);
            decimalField.setEntityMetadata(entityMetadata);
            fieldAp.setField((Field)decimalField);
        }
    }

    @Override
    public void createProperties(EntryType entryType) {
        for (String fieldKey : this.getDetailStandardDimDTO().getFieldSet()) {
            if (!fieldKey.contains("it")) continue;
            this.setId(fieldKey);
            String insurItemIdStr = fieldKey.substring("it".length());
            LinkedHashMap<String, Object> itemAttr = this.getDetailStandardDimDTO().getNameMap().get(insurItemIdStr);
            this.setName((String)itemAttr.get("insurancetypeattr.name"));
            int currAccuracy = (Integer)itemAttr.getOrDefault("dataprecision.scale", 0);
            if (InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getNumber().equals(itemAttr.get("insurancetypeattr.number")) || InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getNumber().equals(itemAttr.get("insurancetypeattr.number"))) {
                currAccuracy = Math.max(currAccuracy - 2, 0);
            }
            this.setAccuracy(currAccuracy);
            this.setDataTypeId(Long.parseLong(String.valueOf(itemAttr.get("datatype.id"))));
            this.registerSimpleProperty(entryType);
        }
    }

    @Override
    protected void registerSimpleProperty(EntryType entryType) {
        SitDataTypeEnum dataType = this.getDataType();
        if (dataType.getId() == SitDataTypeEnum.NUMBER.getId() || dataType.getId() == SitDataTypeEnum.AMOUNT.getId()) {
            DecimalProp decimalProp = dataType.getId() == SitDataTypeEnum.NUMBER.getId() ? new DecimalProp() : new AmountProp();
            decimalProp.setName(this.getId());
            decimalProp.setDisplayName(new LocaleString(this.getName()));
            decimalProp.setEnableNull(true);
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            decimalProp.setPrecision(23);
            decimalProp.setScale(this.getAccuracy());
            decimalProp.setZeroShow(true);
            decimalProp.setFeatures(new Features().getValue());
            decimalProp.setMustInput(true);
            entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        }
    }

    @Override
    public Object getFieldValue(int depth) {
        return null;
    }

    public SitDataTypeEnum getDataType() {
        return this.getDataTypeId() == null ? SitDataTypeEnum.NUMBER : SitDataTypeEnum.getEnumById((long)this.getDataTypeId());
    }
}

