/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standard.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.standard.service.DyStandardEntityService;
import kd.sit.sitbs.business.socinsurance.standard.service.SocInsuranceStandardService;

public class RoundTypeDyStandardEntityService
extends DyStandardEntityService {
    public RoundTypeDyStandardEntityService(DetailStandardDimDTO detailStandardDimDTO) {
        super(detailStandardDimDTO);
    }

    @Override
    public void createEntryAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        for (String fieldKey : this.getDetailStandardDimDTO().getFieldSet()) {
            if (!fieldKey.contains("rt")) continue;
            this.setId(fieldKey);
            String insurItemIdStr = fieldKey.substring("rt".length());
            LinkedHashMap<String, Object> itemAttr = this.getDetailStandardDimDTO().getNameMap().get(insurItemIdStr);
            this.setName((String)itemAttr.get("insurancetypeattr.name"));
            this.getEntityControlAp(entityMetadata, entryAp);
        }
    }

    @Override
    protected void getEntityControlAp(EntityMetadata entityMetadata, EntryAp entryAp) {
        EntryFieldGroupAp levelOneGroupAp = new EntryFieldGroupAp();
        levelOneGroupAp.setKey("cg" + this.getId());
        levelOneGroupAp.setName(new LocaleString(this.getName()));
        levelOneGroupAp.setTextAlign("center");
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setKey(this.getId());
        fieldAp.setName(new LocaleString(SocInsuranceErrInfoEnum.DYNAMIC_ROUND_TYPE.getErrInfo()));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFieldTextAlign("center");
        fieldAp.setTextAlign("center");
        this.createFieldByType(fieldAp, entityMetadata);
        levelOneGroupAp.getItems().add(fieldAp);
        entryAp.getItems().add(levelOneGroupAp);
    }

    @Override
    public void createFieldByType(EntryFieldAp fieldAp, EntityMetadata entityMetadata) {
        ComboField comboField = new ComboField();
        comboField.setId(this.getId());
        comboField.setKey(this.getId());
        comboField.setFeatures(new Features());
        comboField.setEntityMetadata(entityMetadata);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List<ValueMapItem> itemList = SocInsuranceStandardService.getRoundTypeItemList();
        for (ValueMapItem item : itemList) {
            ComboItem roundTypeItem = new ComboItem();
            roundTypeItem.setCaption(item.getName());
            roundTypeItem.setValue(item.getValue());
            roundTypeItem.setItemVisible(item.isItemVisible());
            items.add(roundTypeItem);
        }
        comboField.setItems(items);
        comboField.setMustInputType(1);
        comboField.setMustInput(true);
        fieldAp.setField((Field)comboField);
    }

    @Override
    public void createProperties(EntryType entryType) {
        for (String fieldKey : this.getDetailStandardDimDTO().getFieldSet()) {
            if (!fieldKey.contains("rt")) continue;
            this.setId(fieldKey);
            String insurItemIdStr = fieldKey.substring("rt".length());
            LinkedHashMap<String, Object> itemAttr = this.getDetailStandardDimDTO().getNameMap().get(insurItemIdStr);
            this.setName((String)itemAttr.get("insurancetypeattr.name"));
            this.registerSimpleProperty(entryType);
        }
    }

    @Override
    protected void registerSimpleProperty(EntryType entryType) {
        ComboProp prop = new ComboProp();
        prop.setName(this.getId());
        prop.setEnableNull(false);
        prop.setDbIgnore(true);
        prop.setAlias(null);
        prop.setDisplayName(new LocaleString(SocInsuranceErrInfoEnum.DYNAMIC_ROUND_TYPE.getErrInfo()));
        prop.setFeatures(new Features().getValue());
        prop.setShowStyle(1);
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(10);
        List<ValueMapItem> itemList = SocInsuranceStandardService.getRoundTypeItemList();
        for (ValueMapItem item : itemList) {
            ValueMapItem roundTypeItem = new ValueMapItem();
            roundTypeItem.setName(item.getName());
            roundTypeItem.setValue(item.getValue());
            roundTypeItem.setItemVisible(item.isItemVisible());
            comboItems.add(roundTypeItem);
        }
        prop.setComboItems(comboItems);
        prop.setMustInput(true);
        entryType.registerSimpleProperty((DynamicSimpleProperty)prop);
    }

    @Override
    public Object getFieldValue(int depth) {
        return null;
    }
}

