/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standard.service;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.entity.social.InsurTypeAttrEntity;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.constants.SInsuranceConstants;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.dto.PayBaseDTO;
import kd.sit.sitbs.business.socinsurance.dto.StandardDimDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standard.helper.SocInsuranceStandardHelper;

public class SocInsuranceStandardService {
    private SocInsuranceStandardService() {
    }

    public static SocInsuranceStandardService createInstance() {
        return new SocInsuranceStandardService();
    }

    public QFilter getCommonQFilter(IFormView iFormView, String customKey) {
        StandardDimDTO standardDimDTOFromCache;
        Set<Long> insurTypeIdSet;
        DynamicObject dataEntity = iFormView.getModel().getDataEntity();
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        if ("sitbs_insuranceitem".equals(customKey)) {
            filter.and("group", "=", (Object)dataEntity.getLong("insurtype.id"));
        } else if ("sitbs_welfaretype".equals(customKey) && !(insurTypeIdSet = (standardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache(iFormView.getPageId())).getFieldMap().keySet()).isEmpty()) {
            filter.and("id", "not in", standardDimDTOFromCache.getFieldMap().keySet());
        }
        filter.and("country", "=", (Object)dataEntity.getLong("country.id"));
        return filter;
    }

    public static StandardDimDTO updateInsurTypeInfoCache(Collection<Long> insurTypeIds, StandardDimDTO standardDimDTO, boolean isCreateNewData) {
        return SocInsuranceStandardService.updateInsurTypeInfoCache(insurTypeIds, standardDimDTO, isCreateNewData, true, null);
    }

    public static StandardDimDTO updateInsurTypeInfoCache(Collection<Long> insurTypeIds, StandardDimDTO standardDimDTO, boolean isCreateNewData, boolean needUpdateFromCfg, Integer storeLines) {
        Map<Long, Map<Long, String>> sinsurStdCfgMap;
        HashSet<Long> allInsurItemIdSet;
        if (standardDimDTO == null) {
            standardDimDTO = StandardDimDTO.updateInstance(standardDimDTO);
        }
        if (needUpdateFromCfg) {
            allInsurItemIdSet = new HashSet<Long>(16);
            sinsurStdCfgMap = SocInsuranceStandardService.getSInsurStdCfgMap(insurTypeIds, allInsurItemIdSet, true);
        } else {
            allInsurItemIdSet = new HashSet(0);
            sinsurStdCfgMap = new HashMap<Long, Map<Long, String>>(0);
        }
        for (Long insurTypeId : insurTypeIds) {
            if (needUpdateFromCfg && !SocInsuranceStandardService.updateFieldFromInsurTypeCfg(standardDimDTO, insurTypeId, isCreateNewData, sinsurStdCfgMap)) continue;
            List itemValueForDetailInsurTypes = standardDimDTO.getValueMap().computeIfAbsent(insurTypeId, key -> new ArrayList(10));
            if (isCreateNewData || itemValueForDetailInsurTypes.isEmpty()) continue;
            LinkedHashSet fieldForDetailInsurTypeLinkedSet = standardDimDTO.getFieldMap().computeIfAbsent(insurTypeId, key -> new LinkedHashSet(16));
            ArrayList<LinkedHashMap<String, String>> newItemValueForDetailInsurTypes = new ArrayList<LinkedHashMap<String, String>>(itemValueForDetailInsurTypes.size());
            int maxSize = storeLines == null || storeLines > itemValueForDetailInsurTypes.size() ? itemValueForDetailInsurTypes.size() : storeLines.intValue();
            SocInsuranceStandardService.assebleData(itemValueForDetailInsurTypes, fieldForDetailInsurTypeLinkedSet, newItemValueForDetailInsurTypes, maxSize);
            standardDimDTO.getValueMap().put(insurTypeId, newItemValueForDetailInsurTypes);
        }
        if (needUpdateFromCfg) {
            Map<String, LinkedHashMap<String, Object>> insurItemAttrLinkedMap = SocInsuranceStandardService.getFieldKeyAttrLinkedMap(allInsurItemIdSet, insurTypeIds, true);
            standardDimDTO.getNameMap().putAll(insurItemAttrLinkedMap);
        }
        return standardDimDTO;
    }

    private static void assebleData(List<LinkedHashMap<String, String>> itemValueForDetailInsurTypes, LinkedHashSet<String> fieldForDetailInsurTypeLinkedSet, List<LinkedHashMap<String, String>> newItemValueForDetailInsurTypes, int maxSize) {
        for (int i = 0; i < maxSize; ++i) {
            LinkedHashMap<String, String> itemValueLinkedMap = itemValueForDetailInsurTypes.get(i);
            LinkedHashMap<String, String> newItemValueLinkedMap = new LinkedHashMap<String, String>(itemValueLinkedMap.size());
            for (String fieldKey : fieldForDetailInsurTypeLinkedSet) {
                newItemValueLinkedMap.put(fieldKey, itemValueLinkedMap.get(fieldKey));
            }
            newItemValueForDetailInsurTypes.add(newItemValueLinkedMap);
        }
    }

    private static boolean updateFieldFromInsurTypeCfg(StandardDimDTO standardDimDTO, Long insurTypeId, boolean isCreateNewData, Map<Long, Map<Long, String>> sinsurStdCfgMap) {
        if (CollectionUtils.isEmpty(sinsurStdCfgMap)) {
            sinsurStdCfgMap = new HashMap<Long, Map<Long, String>>(0);
        }
        Map<Long, String> sinsurStdCfgEntityLinkedMap = sinsurStdCfgMap.get(insurTypeId);
        standardDimDTO.getValueMap().computeIfAbsent(insurTypeId, key -> new ArrayList(10));
        LinkedHashSet fieldForDetailInsurTypeLinkedSet = standardDimDTO.getFieldMap().computeIfAbsent(insurTypeId, key -> new LinkedHashSet(16));
        if (CollectionUtils.isEmpty(sinsurStdCfgEntityLinkedMap)) {
            fieldForDetailInsurTypeLinkedSet.clear();
            standardDimDTO.getValueMap().get(insurTypeId).clear();
            standardDimDTO.getUseStdDimMap().put(insurTypeId, "0");
            return false;
        }
        LinkedHashSet<String> newFieldForDetailInsurTypeLinkedSet = new LinkedHashSet<String>(16);
        if (isCreateNewData || fieldForDetailInsurTypeLinkedSet.isEmpty()) {
            standardDimDTO.getUseStdDimMap().put(insurTypeId, "0");
        } else {
            boolean isStdDim = "1".equals(standardDimDTO.getUseStdDimMap().get(insurTypeId));
            if (isStdDim) {
                if (fieldForDetailInsurTypeLinkedSet.contains("bt0_")) {
                    newFieldForDetailInsurTypeLinkedSet.add("bt0_");
                }
                if (fieldForDetailInsurTypeLinkedSet.contains("bt1_")) {
                    newFieldForDetailInsurTypeLinkedSet.add("bt1_");
                }
            }
        }
        String fieldKey = null;
        LinkedHashSet<String> roundTypeLinkedSet = new LinkedHashSet<String>(sinsurStdCfgEntityLinkedMap.size());
        for (Map.Entry<Long, String> sinsurStdCfgEntity : sinsurStdCfgEntityLinkedMap.entrySet()) {
            Long insurItemId = sinsurStdCfgEntity.getKey();
            if ("1".equals(sinsurStdCfgEntity.getValue())) {
                fieldKey = "rt" + insurItemId;
                roundTypeLinkedSet.add(fieldKey);
                continue;
            }
            fieldKey = "it" + insurItemId;
            newFieldForDetailInsurTypeLinkedSet.add(fieldKey);
        }
        newFieldForDetailInsurTypeLinkedSet.addAll(roundTypeLinkedSet);
        standardDimDTO.getFieldMap().put(insurTypeId, newFieldForDetailInsurTypeLinkedSet);
        fieldForDetailInsurTypeLinkedSet.clear();
        return true;
    }

    public static Map<Long, Map<Long, String>> getSInsurStdCfgMap(Collection<Long> insurTypeIds, Collection<Long> allInsurItemIdSet, boolean isItem, Map<Long, DynamicObject> tmpInsurTypeIdAndCfgIdLinkedMap, HashBasedTable<Long, Long, Long> tmpInsurTypeAndAttrAndItemTable) {
        DynamicObject[] sinsurStdCfgDyArr;
        if (insurTypeIds.isEmpty()) {
            return new LinkedHashMap<Long, Map<Long, String>>(0);
        }
        LinkedHashMap<Long, Map<Long, String>> sinsurStdCfgMap = new LinkedHashMap<Long, Map<Long, String>>(insurTypeIds.size());
        for (DynamicObject sinsurStdCfgDy : sinsurStdCfgDyArr = SocInsuranceStandardHelper.queryInsurItemInfo(insurTypeIds, null)) {
            long insurTypeId = sinsurStdCfgDy.getLong("insurtype.id");
            if (tmpInsurTypeIdAndCfgIdLinkedMap != null) {
                tmpInsurTypeIdAndCfgIdLinkedMap.put(insurTypeId, sinsurStdCfgDy);
            }
            DynamicObjectCollection resultEntryEntity = sinsurStdCfgDy.getDynamicObjectCollection("rentryentity");
            LinkedHashMap sinsurStdCfgEntityLinkedMap = new LinkedHashMap(resultEntryEntity.size());
            LinkedHashMap<Long, String> sinsurStdCfgWithRoundTypeEntityLinkedMap = new LinkedHashMap<Long, String>(resultEntryEntity.size());
            for (DynamicObject resultEntry : resultEntryEntity) {
                String isUseRoundType;
                LinkedHashMap<Long, String> tmpMap;
                if (allInsurItemIdSet != null) {
                    allInsurItemIdSet.add(resultEntry.getLong("insuritem.id"));
                }
                LinkedHashMap<Long, String> linkedHashMap = tmpMap = "1".equals(isUseRoundType = resultEntry.getString("isuseroundtype")) ? sinsurStdCfgWithRoundTypeEntityLinkedMap : sinsurStdCfgEntityLinkedMap;
                if (isItem) {
                    tmpMap.put(resultEntry.getLong("insuritem.id"), isUseRoundType);
                    continue;
                }
                DynamicObject insurItemDy = resultEntry.getDynamicObject("insuritem");
                if (!HRObjectUtils.isEmpty((Object)insurItemDy)) {
                    tmpMap.put(insurItemDy.getLong("insurancetypeattr.id"), isUseRoundType);
                }
                if (tmpInsurTypeAndAttrAndItemTable == null) continue;
                tmpInsurTypeAndAttrAndItemTable.put((Object)insurTypeId, (Object)insurItemDy.getLong("insurancetypeattr.id"), (Object)resultEntry.getLong("insuritem.id"));
            }
            sinsurStdCfgEntityLinkedMap.putAll(sinsurStdCfgWithRoundTypeEntityLinkedMap);
            sinsurStdCfgMap.put(insurTypeId, sinsurStdCfgEntityLinkedMap);
        }
        return sinsurStdCfgMap;
    }

    public static Map<Long, Map<Long, String>> getSInsurStdCfgMap(Collection<Long> insurTypeIds, Collection<Long> allInsurItemIdSet, boolean isItem) {
        return SocInsuranceStandardService.getSInsurStdCfgMap(insurTypeIds, allInsurItemIdSet, isItem, null, null);
    }

    public StandardDimDTO getInsurTypeInfoInResultLinkedMap(DynamicObjectCollection stdEntityEntity, boolean submitOrAuditOrHis) {
        StandardDimDTO standardDimDTO = StandardDimDTO.updateInstance(null);
        if (stdEntityEntity.isEmpty()) {
            return standardDimDTO;
        }
        LinkedHashMap<Long, DynamicObject> insurTypeDyLinkedMap = new LinkedHashMap<Long, DynamicObject>(stdEntityEntity.size());
        for (DynamicObject stdEntity : stdEntityEntity) {
            insurTypeDyLinkedMap.put(stdEntity.getLong("insurtype.id"), stdEntity);
        }
        if (!submitOrAuditOrHis) {
            List<DynamicObject> insurTypeDys = SocInsuranceStandardHelper.queryDefaultInsurTypeInfo(new QFilter("id", "in", insurTypeDyLinkedMap.keySet()), true);
            Set enableAndSumbitInsurTypeIdSet = insurTypeDys.stream().map(insurTypeDy -> insurTypeDy.getLong("id")).collect(Collectors.toSet());
            Set<Long> resultCoverInsurTypeIds = SocInsuranceStandardHelper.queryResultCoverInsurType(enableAndSumbitInsurTypeIdSet);
            enableAndSumbitInsurTypeIdSet.removeAll(resultCoverInsurTypeIds);
            insurTypeDyLinkedMap.keySet().retainAll(enableAndSumbitInsurTypeIdSet);
        }
        HashSet<Long> allInsurItemIdSet = new HashSet<Long>(16);
        for (Map.Entry insurTypeDyEntityLinkedMap : insurTypeDyLinkedMap.entrySet()) {
            Long insurTypeId = (Long)insurTypeDyEntityLinkedMap.getKey();
            List itemValueForDetailInsurTypeLinkedMaps = standardDimDTO.getValueMap().computeIfAbsent(insurTypeId, key -> new ArrayList(10));
            DynamicObject insurTypeEntry = (DynamicObject)insurTypeDyEntityLinkedMap.getValue();
            DynamicObjectCollection subEntryEntity = insurTypeEntry.getDynamicObjectCollection("subentryentity");
            LinkedHashMap<String, List<DynamicObject>> stdDimMap = new LinkedHashMap<String, List<DynamicObject>>(16);
            for (DynamicObject itemAttrDy : subEntryEntity) {
                long registerTypeId = itemAttrDy.getLong("registertype.id");
                long categoryId = itemAttrDy.getLong("category.id");
                StringJoiner keyOfOneLine = new StringJoiner(",");
                keyOfOneLine.add(String.valueOf(registerTypeId));
                keyOfOneLine.add(String.valueOf(categoryId));
                List itemInfoDyList = stdDimMap.computeIfAbsent(keyOfOneLine.toString(), key -> new ArrayList(10));
                itemInfoDyList.add(itemAttrDy);
            }
            this.assembleMutiRowData(allInsurItemIdSet, itemValueForDetailInsurTypeLinkedMaps, stdDimMap);
            standardDimDTO.getUseStdDimMap().put(insurTypeId, insurTypeEntry.getBoolean("isstddim") ? "1" : "0");
            LinkedHashSet fieldKeyForDetailInsurTypeLinkedSet = standardDimDTO.getFieldMap().computeIfAbsent(insurTypeId, key -> new LinkedHashSet(16));
            if (itemValueForDetailInsurTypeLinkedMaps.size() <= 0) continue;
            fieldKeyForDetailInsurTypeLinkedSet.addAll(((LinkedHashMap)itemValueForDetailInsurTypeLinkedMaps.get(0)).keySet());
        }
        Map<String, LinkedHashMap<String, Object>> insurItemAttrLinkedMap = SocInsuranceStandardService.getFieldKeyAttrLinkedMap(allInsurItemIdSet, insurTypeDyLinkedMap.keySet(), true);
        standardDimDTO.setNameMap(insurItemAttrLinkedMap);
        return standardDimDTO;
    }

    private void assembleMutiRowData(Set<Long> allInsurItemIdSet, List<LinkedHashMap<String, String>> itemValueForDetailInsurTypeLinkedMaps, Map<String, List<DynamicObject>> stdDimMap) {
        for (Map.Entry<String, List<DynamicObject>> stdDimLinkedEntry : stdDimMap.entrySet()) {
            LinkedHashMap<String, String> itemValueInfoLinkedMap = new LinkedHashMap<String, String>(16);
            LinkedHashMap<String, String> roundTypeValueLinkedMap = new LinkedHashMap<String, String>(16);
            String keyOfOneLine = stdDimLinkedEntry.getKey();
            String[] stdDimKeyArr = keyOfOneLine.split(",");
            if (!stdDimKeyArr[0].equals("0")) {
                itemValueInfoLinkedMap.put("bt0_", stdDimKeyArr[0]);
            }
            if (!stdDimKeyArr[1].equals("0")) {
                itemValueInfoLinkedMap.put("bt1_", stdDimKeyArr[1]);
            }
            List<DynamicObject> itemAttrDyList = stdDimLinkedEntry.getValue();
            for (DynamicObject itemAttrDy : itemAttrDyList) {
                allInsurItemIdSet.add(itemAttrDy.getLong("insuritem.id"));
                String roundTypeValue = itemAttrDy.getString("roundtype");
                if (!HRStringUtils.isEmpty((String)roundTypeValue)) {
                    String roundTypeFieldKey = "rt" + itemAttrDy.getString("insuritem.id");
                    roundTypeValueLinkedMap.put(roundTypeFieldKey, roundTypeValue);
                    continue;
                }
                String insurItemFieldKey = "it" + itemAttrDy.getString("insuritem.id");
                itemValueInfoLinkedMap.put(insurItemFieldKey, itemAttrDy.getString("itemvalue"));
            }
            itemValueInfoLinkedMap.putAll(roundTypeValueLinkedMap);
            itemValueForDetailInsurTypeLinkedMaps.add(itemValueInfoLinkedMap);
        }
    }

    public List<String> insertCacheDataIntoResultEntityWhenSave(StandardDimDTO standardDimDTO, DynamicObjectCollection stdEntityEntity) {
        if ((standardDimDTO = StandardDimDTO.updateInstance(standardDimDTO)).getFieldMap().isEmpty()) {
            return Collections.singletonList(SocInsuranceErrInfoEnum.INSUR_STD_TABLE_IS_NULL.getErrInfo());
        }
        Map<Long, Long> insurTypeIdAndCfgIdMap = SocInsuranceStandardService.getInsurTypeIdAndCfgIdMap(standardDimDTO.getFieldMap().keySet());
        LinkedHashMap<Long, List<LinkedHashMap<String, String>>> insurTypeInfoInResultLinkedMap = standardDimDTO.getValueMap();
        LinkedHashMap<Long, List<String>> errorInsurTypeLinkedMap = new LinkedHashMap<Long, List<String>>(insurTypeInfoInResultLinkedMap.size());
        stdEntityEntity.clear();
        int entrySeq = 1;
        for (Map.Entry<Long, List<LinkedHashMap<String, String>>> insurTypeInfoInResultLinkedEntry : insurTypeInfoInResultLinkedMap.entrySet()) {
            Long insurTypeId = insurTypeInfoInResultLinkedEntry.getKey();
            List<LinkedHashMap<String, String>> detailInsurTypeInfoInResultLinkedMap = insurTypeInfoInResultLinkedEntry.getValue();
            List<String> errMsgs = SocInsuranceStandardService.checkField(standardDimDTO, insurTypeId);
            if (errMsgs.size() > 0) {
                errorInsurTypeLinkedMap.put(insurTypeId, errMsgs);
                continue;
            }
            DynamicObject mainEntity = stdEntityEntity.addNew();
            mainEntity.set("seq", (Object)entrySeq++);
            mainEntity.set("insurtype", (Object)insurTypeId);
            mainEntity.set("isstddim", (Object)standardDimDTO.getUseStdDimMap().get(insurTypeId));
            mainEntity.set("sinsurstdcfg", Long.valueOf(0L).equals(insurTypeIdAndCfgIdMap.get(insurTypeId)) ? null : insurTypeIdAndCfgIdMap.get(insurTypeId));
            LinkedHashSet<String> fieldSet = standardDimDTO.getFieldMap().get(insurTypeId);
            String stdDim = fieldSet.contains("bt0_") ? "0" : "";
            stdDim = stdDim + (fieldSet.contains("bt1_") ? ",1" : "");
            mainEntity.set("stddim", (Object)(stdDim.length() > 0 ? stdDim : null));
            DynamicObjectCollection subEntryEntity = mainEntity.getDynamicObjectCollection("subentryentity");
            subEntryEntity.clear();
            int subEntrySeq = 1;
            this.validateAndSetValue(detailInsurTypeInfoInResultLinkedMap, subEntryEntity, subEntrySeq);
        }
        if (!errorInsurTypeLinkedMap.isEmpty()) {
            List<DynamicObject> insurTypeInfoDyColl = SocInsuranceStandardHelper.queryDefaultInsurTypeInfo(new QFilter("id", "in", errorInsurTypeLinkedMap.keySet()), false);
            Map<Long, String> insurTypeIdAndName = insurTypeInfoDyColl.stream().collect(Collectors.toMap(insurTypeInfoDy -> insurTypeInfoDy.getLong("id"), insurTypeInfoDy -> insurTypeInfoDy.getString("name"), (oldVal, newVal) -> oldVal));
            ArrayList<String> errList = new ArrayList<String>(errorInsurTypeLinkedMap.size());
            for (Map.Entry errorInsurTypeLinkeEntry : errorInsurTypeLinkedMap.entrySet()) {
                String insurTypeName = insurTypeIdAndName.get(errorInsurTypeLinkeEntry.getKey());
                ((List)errorInsurTypeLinkeEntry.getValue()).forEach(errInfo -> errList.add(MessageFormat.format(errInfo, insurTypeName)));
            }
            return errList;
        }
        return new ArrayList<String>(0);
    }

    private void validateAndSetValue(List<LinkedHashMap<String, String>> detailInsurTypeInfoInResultLinkedMap, DynamicObjectCollection subEntryEntity, int subEntrySeq) {
        for (LinkedHashMap<String, String> itemValueLinkedMap : detailInsurTypeInfoInResultLinkedMap) {
            String categoryTypeIdStr = itemValueLinkedMap.get("bt0_");
            Long categoryTypeId = HRStringUtils.isEmpty((String)categoryTypeIdStr) ? null : Long.valueOf(Long.parseLong(categoryTypeIdStr));
            String categoryArrIdStr = itemValueLinkedMap.get("bt1_");
            Long categoryArrId = HRStringUtils.isEmpty((String)categoryArrIdStr) ? null : Long.valueOf(Long.parseLong(categoryArrIdStr));
            for (Map.Entry<String, String> detailItemValueLinkedEntry : itemValueLinkedMap.entrySet()) {
                Long insurItemId;
                DynamicObject suEntity;
                String detailKey = detailItemValueLinkedEntry.getKey();
                if (detailKey.contains("it")) {
                    suEntity = subEntryEntity.addNew();
                    suEntity.set("seq", (Object)subEntrySeq++);
                    suEntity.set("registertype", (Object)categoryTypeId);
                    suEntity.set("category", (Object)categoryArrId);
                    insurItemId = Long.parseLong(detailKey.substring("it".length()));
                    suEntity.set("insuritem", (Object)insurItemId);
                    suEntity.set("itemvalue", (Object)detailItemValueLinkedEntry.getValue());
                    continue;
                }
                if (!detailKey.contains("rt")) continue;
                suEntity = subEntryEntity.addNew();
                suEntity.set("seq", (Object)subEntrySeq++);
                suEntity.set("registertype", (Object)categoryTypeId);
                suEntity.set("category", (Object)categoryArrId);
                insurItemId = Long.parseLong(detailKey.substring("rt".length()));
                suEntity.set("insuritem", (Object)insurItemId);
                suEntity.set("roundtype", (Object)itemValueLinkedMap.get("rt" + insurItemId));
            }
        }
    }

    private static Collection<PayBaseDTO> getPayBaseDTOSet(Map<String, LinkedHashMap<String, Object>> nameMap, Set<String> itemIdKeySet) {
        HashMap<PayBaseDTO.PayBaseTypeEnum, PayBaseDTO> payBaseDTOHashMap = new HashMap<PayBaseDTO.PayBaseTypeEnum, PayBaseDTO>(2);
        for (Map.Entry<String, LinkedHashMap<String, Object>> linkedHashMapEntry : nameMap.entrySet()) {
            PayBaseDTO payBaseDTO;
            if (!itemIdKeySet.contains("it" + linkedHashMapEntry.getKey())) continue;
            if (InsurTypeAttrEnum.PAY_BASE_TOP_OF_EMPLOYEE.getNumber().equals(linkedHashMapEntry.getValue().get("insurancetypeattr.number"))) {
                payBaseDTO = payBaseDTOHashMap.computeIfAbsent(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_EMPLOYEE_ENUM, key -> new PayBaseDTO());
                payBaseDTO.setPayBaseTypeEnum(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_EMPLOYEE_ENUM);
                payBaseDTO.setPayBasedTopInsurItemId(linkedHashMapEntry.getKey());
                continue;
            }
            if (InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_EMPLOYEE.getNumber().equals(linkedHashMapEntry.getValue().get("insurancetypeattr.number"))) {
                payBaseDTO = payBaseDTOHashMap.computeIfAbsent(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_EMPLOYEE_ENUM, key -> new PayBaseDTO());
                payBaseDTO.setPayBaseTypeEnum(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_EMPLOYEE_ENUM);
                payBaseDTO.setPayBasedBottomInsurItemId(linkedHashMapEntry.getKey());
                continue;
            }
            if (InsurTypeAttrEnum.PAY_BASE_TOP_OF_COMPANY.getNumber().equals(linkedHashMapEntry.getValue().get("insurancetypeattr.number"))) {
                payBaseDTO = payBaseDTOHashMap.computeIfAbsent(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_COMPANY_ENUM, key -> new PayBaseDTO());
                payBaseDTO.setPayBaseTypeEnum(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_COMPANY_ENUM);
                payBaseDTO.setPayBasedTopInsurItemId(linkedHashMapEntry.getKey());
                continue;
            }
            if (!InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_COMPANY.getNumber().equals(linkedHashMapEntry.getValue().get("insurancetypeattr.number"))) continue;
            payBaseDTO = payBaseDTOHashMap.computeIfAbsent(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_COMPANY_ENUM, key -> new PayBaseDTO());
            payBaseDTO.setPayBaseTypeEnum(PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_COMPANY_ENUM);
            payBaseDTO.setPayBasedBottomInsurItemId(linkedHashMapEntry.getKey());
        }
        payBaseDTOHashMap.keySet().stream().sorted();
        return payBaseDTOHashMap.values();
    }

    public static Map<Long, Long> getInsurTypeIdAndCfgIdMap(Collection<Long> insurTypeIds) {
        DynamicObject[] sinsurStdCfgDyArr = SocInsuranceStandardHelper.queryInsurItemInfo(insurTypeIds, null);
        return Arrays.stream(sinsurStdCfgDyArr).collect(Collectors.toMap(sinsurStdCfgDy -> sinsurStdCfgDy.getLong("insurtype.id"), sinsurStdCfgDy -> sinsurStdCfgDy.getLong("id"), (oldVal, newVal) -> oldVal));
    }

    private static List<String> checkField(StandardDimDTO standardDimDTO, Long insurTypeId) {
        boolean isStdDim = "1".equals(standardDimDTO.getUseStdDimMap().get(insurTypeId));
        LinkedHashSet<String> detailFieldInResultLinkedSet = standardDimDTO.getFieldMap().get(insurTypeId);
        if (isStdDim && !detailFieldInResultLinkedSet.contains("bt0_") && !detailFieldInResultLinkedSet.contains("bt1_")) {
            return Collections.singletonList(SocInsuranceErrInfoEnum.EXISTS_STD_DIM_IS_NULL.getErrInfo());
        }
        List<LinkedHashMap<String, String>> itemValueMaps = standardDimDTO.getValueMap().get(insurTypeId);
        if (itemValueMaps == null || itemValueMaps.isEmpty()) {
            return Collections.singletonList(SocInsuranceErrInfoEnum.EXISTS_INSUR_STD_IS_NULL.getErrInfo());
        }
        Collection<PayBaseDTO> PayBaseDTOs = SocInsuranceStandardService.getPayBaseDTOSet(standardDimDTO.getNameMap(), itemValueMaps.get(0).keySet());
        for (LinkedHashMap<String, String> itemValueMap : itemValueMaps) {
            if (itemValueMap.values().stream().anyMatch(HRStringUtils::isEmpty)) {
                return Collections.singletonList(SocInsuranceErrInfoEnum.EXISTS_INSUR_STD_IS_NULL.getErrInfo());
            }
            ArrayList<String> errMsgs = new ArrayList<String>(10);
            for (PayBaseDTO payBaseDTO : PayBaseDTOs) {
                BigDecimal topVal;
                BigDecimal bottomVal;
                if (!payBaseDTO.needChecked() || (bottomVal = new BigDecimal(itemValueMap.get("it" + payBaseDTO.getPayBasedBottomInsurItemId()))).compareTo(topVal = new BigDecimal(itemValueMap.get("it" + payBaseDTO.getPayBasedTopInsurItemId()))) <= 0) continue;
                String errMsg = payBaseDTO.getPayBaseTypeEnum() == PayBaseDTO.PayBaseTypeEnum.PAY_BASE_OF_EMPLOYEE_ENUM ? SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_BASE_PAY_OF_EMPLOYEE_WRONG.getErrInfo() : SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_BASE_PAY_OF_COMPANY_WRONG.getErrInfo();
                errMsgs.add(errMsg);
            }
            if (errMsgs.size() <= 0) continue;
            return errMsgs;
        }
        return new ArrayList<String>(0);
    }

    public static Map<String, LinkedHashMap<String, Object>> getFieldKeyAttrLinkedMap(Set<Long> allInsurItemIdSet, Collection<Long> insurTypeIds, boolean needStdDim) {
        List<DynamicObject> insurTypeInfoColl = SocInsuranceStandardHelper.queryDefaultInsurTypeInfo(new QFilter("id", "in", insurTypeIds), false);
        Map<Long, Integer> insurTypeIdAndCurrencyMap = insurTypeInfoColl.stream().collect(Collectors.toMap(insurTypeDy -> insurTypeDy.getLong("id"), insurTypeDy -> insurTypeDy.getInt("currency.amtprecision"), (oldVal, newVal) -> oldVal));
        DynamicObjectCollection insurItemInfoDyColl = SocInsuranceStandardHelper.queryInsurItemInfoById(allInsurItemIdSet, null);
        LinkedHashMap<String, LinkedHashMap<String, Object>> insurItemAttrLinkedMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>(insurItemInfoDyColl.size());
        for (DynamicObject insurItemInfoDy : insurItemInfoDyColl) {
            Map attrMap = insurItemAttrLinkedMap.computeIfAbsent(insurItemInfoDy.getString("id"), key -> new LinkedHashMap(16));
            attrMap.put("insurancetypeattr.name", insurItemInfoDy.getString("insurancetypeattr.name"));
            attrMap.put("insurancetypeattr.number", insurItemInfoDy.getString("insurancetypeattr.number"));
            attrMap.put("insurancetypeattr.id", insurItemInfoDy.getString("insurancetypeattr.id"));
            attrMap.put("datatype.id", insurItemInfoDy.getLong("datatype.id"));
            if (SitDataTypeEnum.AMOUNT.getId() == insurItemInfoDy.getLong("datatype.id")) {
                attrMap.put("dataprecision.scale", insurTypeIdAndCurrencyMap.getOrDefault(insurItemInfoDy.getLong("group"), 0));
                continue;
            }
            attrMap.put("dataprecision.scale", insurItemInfoDy.getInt("dataprecision.scale"));
        }
        if (needStdDim) {
            Map<String, LinkedHashMap<String, Object>> stdDimAttrLinkedMap = SocInsuranceStandardHelper.queryStdDimAttrLinkedMap();
            insurItemAttrLinkedMap.putAll(stdDimAttrLinkedMap);
        }
        return insurItemAttrLinkedMap;
    }

    public static StandardDimDTO getStandardDimDTOFromCache(String pageId) {
        IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + pageId));
        StandardDimDTO standardDimDTO = (StandardDimDTO)appCache.get("insur_type_cache_key", StandardDimDTO.class);
        return StandardDimDTO.updateInstance(standardDimDTO);
    }

    public static void updateStandardDimDTO(List<Long> existInsurTypeIds, StandardDimDTO standardDimDTO, String pageId) {
        LinkedHashMap<Long, LinkedHashSet<String>> fieldMap = standardDimDTO.getFieldMap();
        LinkedHashMap<Long, List<LinkedHashMap<String, String>>> valueMap = standardDimDTO.getValueMap();
        LinkedHashMap<Long, LinkedHashSet<String>> newFieldMap = new LinkedHashMap<Long, LinkedHashSet<String>>(fieldMap.size());
        LinkedHashMap<Long, List<LinkedHashMap<String, String>>> newValueMap = new LinkedHashMap<Long, List<LinkedHashMap<String, String>>>(valueMap.size());
        for (Long insurTypeId : existInsurTypeIds) {
            newFieldMap.put(insurTypeId, fieldMap.get(insurTypeId));
            newValueMap.put(insurTypeId, valueMap.get(insurTypeId));
        }
        standardDimDTO.setFieldMap(newFieldMap);
        standardDimDTO.setValueMap(newValueMap);
        IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + pageId));
        appCache.put("insur_type_cache_key", (Object)standardDimDTO);
    }

    public static DetailStandardDimDTO getDetailStandardDimDTO(String pageId, Long insurTypeId) {
        StandardDimDTO standardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache(pageId);
        DetailStandardDimDTO detailStandardDimDTO = new DetailStandardDimDTO();
        detailStandardDimDTO.setFieldSet(standardDimDTO.getFieldMap().get(insurTypeId));
        detailStandardDimDTO.setValueMaps(standardDimDTO.getValueMap().get(insurTypeId));
        detailStandardDimDTO.setNameMap(standardDimDTO.getNameMap());
        detailStandardDimDTO.setUseStdDim(standardDimDTO.getUseStdDimMap().get(insurTypeId));
        return DetailStandardDimDTO.updateInstance(detailStandardDimDTO);
    }

    public static void updateDetailDataToUpLevelCache(Long insurTypeId, String parentPageId, DetailStandardDimDTO detailStandardDimDTO) {
        if (insurTypeId != null) {
            StandardDimDTO standardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache(parentPageId);
            standardDimDTO = StandardDimDTO.updateInstance(standardDimDTO);
            standardDimDTO.getValueMap().put(insurTypeId, detailStandardDimDTO.getValueMaps());
            standardDimDTO.getFieldMap().put(insurTypeId, detailStandardDimDTO.getFieldSet());
            standardDimDTO.getUseStdDimMap().put(insurTypeId, detailStandardDimDTO.getUseStdDim());
            IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + parentPageId));
            appCache.put("insur_type_cache_key", (Object)standardDimDTO);
        }
    }

    public static void updateStandardDimDTOCache(String parentPageId) {
        StandardDimDTO standardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache(parentPageId);
        if (!standardDimDTO.getFieldMap().isEmpty()) {
            SocInsuranceStandardService.updateInsurTypeInfoCache(standardDimDTO.getFieldMap().keySet(), standardDimDTO, false, false, null);
        }
    }

    public static List<ValueMapItem> getRoundTypeItemList() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurstd");
        SubEntryType subEntryType = (SubEntryType)mainType.getAllEntities().get("subentryentity");
        ComboProp roundTypeProp = (ComboProp)subEntryType.getProperties().get((Object)"roundtype");
        return roundTypeProp.getComboItems();
    }

    public static BiMap<String, InsurTypeAttrEntity> getInsurTypeAttrFieldKeyAndEntityMap() {
        BiMap<Long, String> insurTypeAttrIdAndFieldKeyMap = SocInsuranceStandardService.getInsurTypeAttrIdAndFieldKeyMap();
        List<DynamicObject> insurancePropDys = SocInsuranceStandardHelper.queryInsurPropBy(insurTypeAttrIdAndFieldKeyMap.keySet());
        HashBiMap insurTypeAttrFieldKeyAndEntityMap = HashBiMap.create((int)insurancePropDys.size());
        for (DynamicObject insurancePropDy : insurancePropDys) {
            InsurTypeAttrEntity insurTypeAttrEntity = new InsurTypeAttrEntity(Long.valueOf(insurancePropDy.getLong("id")), insurancePropDy.getString("number"), insurancePropDy.getString("name"));
            String fieldKey = (String)insurTypeAttrIdAndFieldKeyMap.get((Object)insurTypeAttrEntity.getId());
            if (fieldKey == null) continue;
            insurTypeAttrEntity.setFieldKey(fieldKey);
            insurTypeAttrFieldKeyAndEntityMap.put((Object)fieldKey, (Object)insurTypeAttrEntity);
        }
        return insurTypeAttrFieldKeyAndEntityMap;
    }

    private static BiMap<Long, String> getInsurTypeAttrIdAndFieldKeyMap() {
        IDataEntityProperty subEntryProp;
        DataEntityPropertyCollection properties;
        MainEntityType dataEntityType;
        IDataEntityProperty stdEntryProp;
        BiMap<Long, String> insurTypeAttrIdAndFieldKeyMap = HashBiMap.create((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insurfieldcfg");
        QFilter filter = new QFilter("id", "=", (Object)SInsuranceConstants.CFG_FIELD_STD_ID);
        DynamicObject cfgDy = helper.loadDynamicObject(filter.toArray());
        if (cfgDy != null) {
            for (DynamicObject entry : cfgDy.getDynamicObjectCollection("entryentity")) {
                String cfgField = entry.getString("cfgfield");
                long insurTypeAttrId = entry.getLong("insurancetypeattr.id");
                boolean isNeedAdd = HRStringUtils.isNotEmpty((String)cfgField) && insurTypeAttrId != 0L && !insurTypeAttrIdAndFieldKeyMap.containsKey((Object)insurTypeAttrId) && !insurTypeAttrIdAndFieldKeyMap.containsValue((Object)cfgField.trim());
                if (!isNeedAdd) continue;
                insurTypeAttrIdAndFieldKeyMap.put((Object)insurTypeAttrId, (Object)cfgField.trim());
            }
        }
        if (insurTypeAttrIdAndFieldKeyMap.isEmpty()) {
            insurTypeAttrIdAndFieldKeyMap = SocInsuranceStandardService.getDefaultInsurTypeAttrIdAndFieldKeyMap();
        }
        if ((stdEntryProp = (IDataEntityProperty)(dataEntityType = EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurstdmd")).getProperties().get((Object)"stdentryentity")) != null && (properties = ((SubEntryProp)(subEntryProp = (IDataEntityProperty)((EntryProp)stdEntryProp).getDynamicCollectionItemPropertyType().getProperties().get((Object)"subentryentity"))).getDynamicCollectionItemPropertyType().getProperties()) != null) {
            insurTypeAttrIdAndFieldKeyMap.values().removeIf(fieldKey -> !properties.containsKey(fieldKey));
        }
        return insurTypeAttrIdAndFieldKeyMap;
    }

    public static BiMap<Long, String> getDefaultInsurTypeAttrIdAndFieldKeyMap() {
        HashBiMap insurTypeAttrIdAndFieldKeyMap = HashBiMap.create((int)16);
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_OF_EMPLOYEE.getId(), (Object)"paybaseofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_OF_COMPANY.getId(), (Object)"paybaseofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getId(), (Object)"payproportionofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getId(), (Object)"payproportionofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_FIXED_OF_EMPLOYEE.getId(), (Object)"payfixedofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_FIXED_OF_COMPANY.getId(), (Object)"payfixedofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_TOP_OF_EMPLOYEE.getId(), (Object)"paybasetopofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_EMPLOYEE.getId(), (Object)"paybasebottomofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_TOP_OF_COMPANY.getId(), (Object)"paybasetopofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_COMPANY.getId(), (Object)"paybasebottomofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_AMOUNT_OF_EMPLOYEE.getId(), (Object)"payamountofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_AMOUNT_OF_COMPANY.getId(), (Object)"payamountofcompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.COMP_AMOUNT_OF_EMPLOYEE.getId(), (Object)"compamountofemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.COMP_AMOUNT_OF_COMPANY.getId(), (Object)"compamountofcompany");
        return insurTypeAttrIdAndFieldKeyMap;
    }
}

