/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standardcfg.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.kingscript.util.Tuple;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.meta.MetaDataHelper;
import kd.sit.sitbs.business.socinsurance.constants.SInsuranceConstants;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standardcfg.constants.StandardCfgConstants;

public class SocInsuranceStandardCfgHelper {
    private static final Log logger = LogFactory.getLog(SocInsuranceStandardCfgHelper.class);

    private SocInsuranceStandardCfgHelper() {
    }

    public static Object[] getValidInsuranceItemIdArr(QFilter filter) {
        List<DynamicObject> insuranceItemDys = SocInsuranceStandardCfgHelper.getInsuranceItemDys(filter);
        return insuranceItemDys.stream().map(dyObj -> dyObj.getLong("id")).toArray();
    }

    private static List<DynamicObject> getInsuranceItemDys(QFilter filter) {
        if (filter == null) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        DynamicObjectCollection insuranceItemDys = helper.queryOriginalCollection("id,insurancetypeattr.number,insurancetypeattr.id,insurancetypeattr.datasrc,insurancetypeattr.isuseroundtype", filter.toArray());
        return insuranceItemDys == null ? Collections.emptyList() : insuranceItemDys;
    }

    public static Map<Long, Tuple<String, String>> queryInsuranceItemAttr(Set<Long> insuranceItemIds) {
        if (CollectionUtils.isEmpty(insuranceItemIds)) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "in", insuranceItemIds);
        List<DynamicObject> insuranceItemDys = SocInsuranceStandardCfgHelper.getInsuranceItemDys(filter);
        HashMap<Long, Tuple<String, String>> itemAndRefAttrMap = new HashMap<Long, Tuple<String, String>>(insuranceItemIds.size());
        for (DynamicObject insuranceItemDy : insuranceItemDys) {
            String roundType = insuranceItemDy.getBoolean("insurancetypeattr.isuseroundtype") ? "1" : "0";
            Tuple attrInfo = new Tuple((Object)roundType, (Object)insuranceItemDy.getString("insurancetypeattr.datasrc"));
            itemAndRefAttrMap.put(insuranceItemDy.getLong("id"), (Tuple<String, String>)attrInfo);
        }
        return itemAndRefAttrMap;
    }

    public static Map<String, Set<Long>> queryInsuranceAtt(Set<Long> insuranceItemIds) {
        if (CollectionUtils.isEmpty(insuranceItemIds)) {
            return Collections.emptyMap();
        }
        Map<String, Set<Long>> needRoundTypeOrCalInsurAttrMap = SocInsuranceStandardCfgHelper.getInsurTypeAttrCfg();
        QFilter filter = new QFilter("id", "in", insuranceItemIds);
        List<DynamicObject> insuranceItemDys = SocInsuranceStandardCfgHelper.getInsuranceItemDys(filter);
        HashMap<String, Set<Long>> markRoundTypeAndDataSrcItemMap = new HashMap<String, Set<Long>>(4);
        String[] fieldKeys = new String[]{"isuseroundtype", "datasrc"};
        Arrays.stream(fieldKeys).forEach(key -> markRoundTypeAndDataSrcItemMap.computeIfAbsent((String)key, mapKey -> new HashSet(16)));
        for (DynamicObject insuranceItemDy : insuranceItemDys) {
            Long insuranceItemId = insuranceItemDy.getLong("id");
            Long insurTypeAttrId = insuranceItemDy.getLong("insurancetypeattr.id");
            for (String fieldKey : fieldKeys) {
                Set<Long> insurTypeaAttrIdsInCfg = needRoundTypeOrCalInsurAttrMap.get(fieldKey);
                Set insurTypeaAttrIdsLast = (Set)markRoundTypeAndDataSrcItemMap.get(fieldKey);
                if (insurTypeaAttrIdsInCfg == null || !insurTypeaAttrIdsInCfg.contains(insurTypeAttrId) || insurTypeaAttrIdsLast == null) continue;
                insurTypeaAttrIdsLast.add(insuranceItemId);
            }
        }
        return markRoundTypeAndDataSrcItemMap;
    }

    public static Map<String, Set<Long>> getInsurTypeAttrCfg() {
        boolean isInvalid;
        HashMap<String, Set<Long>> cfgMap = new HashMap<String, Set<Long>>(4);
        Set insurTypeAttrIdForRoundTypeSet = cfgMap.computeIfAbsent("isuseroundtype", key -> new LinkedHashSet(16));
        Set insurTypeAttrIdForDataSrcSet = cfgMap.computeIfAbsent("datasrc", key -> new LinkedHashSet(16));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insurfieldcfg");
        QFilter filter = new QFilter("id", "=", (Object)SInsuranceConstants.CFG_FIELD_STD_CFG_ID);
        DynamicObject cfgDy = helper.loadDynamicObject(filter.toArray());
        if (cfgDy != null) {
            for (DynamicObject entryDy : cfgDy.getDynamicObjectCollection("entryentity")) {
                Set insurTypeAttrIds;
                String cfgField = entryDy.getString("cfgfield");
                if (!HRStringUtils.isNotEmpty((String)cfgField) || entryDy.getLong("insurancetypeattr.id") == 0L || (insurTypeAttrIds = (Set)cfgMap.get(cfgField.trim())) == null) continue;
                insurTypeAttrIds.add(entryDy.getLong("insurancetypeattr.id"));
            }
        }
        boolean bl = isInvalid = insurTypeAttrIdForRoundTypeSet.isEmpty() || insurTypeAttrIdForDataSrcSet.isEmpty() || !insurTypeAttrIdForRoundTypeSet.containsAll(insurTypeAttrIdForDataSrcSet);
        if (isInvalid) {
            insurTypeAttrIdForRoundTypeSet.clear();
            insurTypeAttrIdForDataSrcSet.clear();
            insurTypeAttrIdForRoundTypeSet.addAll(StandardCfgConstants.DEFAULT_INSUR_TYPE_ATTR_ID_ROUND_TYPE_SET);
            insurTypeAttrIdForDataSrcSet.addAll(StandardCfgConstants.DEFAULT_INSUR_TYPE_ATTR_ID_FOR_DATA_SRC_SET);
        }
        return cfgMap;
    }

    public static String queryInsurTypeCfgInfo(Long insurTypeId, Long countryId, Long insurCfgBoId) {
        DynamicObject dynamicObject;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter filter = new QFilter("insurtype", "=", (Object)insurTypeId);
        filter.and("country", "=", (Object)countryId);
        filter.and(SInsuranceCommonService.getAuditAndEnableQFilter());
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        if (insurCfgBoId != null && insurCfgBoId != 0L) {
            filter.and("boid", "not in", (Object)insurCfgBoId);
        }
        return (dynamicObject = helper.queryOne("name", filter.toArray())) != null ? dynamicObject.getString("name") : null;
    }

    public static Map<String, DynamicObject> queryAuditAndEnableInsurTypeCfgs() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObjectCollection cfgDys = helper.queryOriginalCollection("name,id,boid,country.id,insurtype.id,insurtype.name", filter.toArray());
        if (cfgDys == null || cfgDys.size() == 0) {
            return new HashMap<String, DynamicObject>(16);
        }
        return cfgDys.stream().collect(Collectors.toMap(cfgDy -> cfgDy.getString("country.id") + "," + cfgDy.getString("insurtype.id"), cfgDy -> cfgDy, (oldVal, newVal) -> oldVal));
    }

    public static List<DynamicObject> queryRepetitiveExtendedDataEntity(HashBasedTable<Long, Long, String> countryInsurTypeAndExEntityMap) {
        if (countryInsurTypeAndExEntityMap == null || countryInsurTypeAndExEntityMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter allFilter = SInsuranceCommonService.getAuditAndEnableQFilter();
        BaseDataHisHelper.addHisCurrFilter((QFilter)allFilter);
        Set countryIdSet = countryInsurTypeAndExEntityMap.rowMap().keySet();
        Set insurTypeIdSet = countryInsurTypeAndExEntityMap.columnMap().keySet();
        if (countryIdSet.size() == 1 || insurTypeIdSet.size() == 1) {
            allFilter.and("country", "in", countryIdSet);
            allFilter.and("insurtype", "in", insurTypeIdSet);
        } else {
            QFilter subFilter = null;
            for (Table.Cell entityCell : countryInsurTypeAndExEntityMap.cellSet()) {
                Long countryId = (Long)entityCell.getRowKey();
                Long insurTypeId = (Long)entityCell.getColumnKey();
                if (subFilter == null) {
                    subFilter = new QFilter("insurtype", "=", (Object)insurTypeId);
                    subFilter.and("country", "=", (Object)countryId);
                    continue;
                }
                QFilter currFilter = new QFilter("insurtype", "=", (Object)insurTypeId);
                currFilter.and("country", "=", (Object)countryId);
                subFilter.or(currFilter);
            }
            if (subFilter != null) {
                allFilter.and(subFilter);
            }
        }
        return helper.queryOriginalCollection("country.id, insurtype.id, name", allFilter.toArray());
    }

    public static void updateCfgToHistory() {
        String currParentInheritPath = "1942c188000065ac,2+QE4JA9QV27,201N1LT5T/GM,2JZWOUSSO4ZB";
        MetaDataHelper.replaceOldInheritPath((String)"sitbs_sinsurstdcfg", (String)currParentInheritPath);
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_sinsurstdcfg");
        HashSet<Long> auditCfgIds = null;
        try (TXHandle txHandle = TX.requiresNew();){
            logger.info("SocInsuranceStandardCfgHelper.updateCfgToHistory: begin to update cfg data.");
            QFilter filter = new QFilter("boid", "=", (Object)0L);
            DynamicObject[] cfgDys = helper.loadDynamicObjectArray(filter.toArray());
            if (cfgDys == null || cfgDys.length == 0) {
                SocInsuranceStandardCfgHelper.furtherUpdate();
                return;
            }
            SocInsuranceStandardCfgHelper.updateCurrDy(cfgDys);
            auditCfgIds = new HashSet<Long>(cfgDys.length);
            for (DynamicObject cfgDy : cfgDys) {
                if (!"C".equals(cfgDy.getString("status"))) continue;
                auditCfgIds.add(cfgDy.getLong("id"));
            }
            helper.update(cfgDys);
            logger.info("SocInsuranceStandardCfgHelper.updateCfgToHistory: end to update base data.");
        }
        txHandle = TX.requiresNew();
        try {
            if (auditCfgIds != null && !auditCfgIds.isEmpty()) {
                DynamicObject[] auditCfgDys = helper.loadDynamicObjectArray((Object[])auditCfgIds.toArray(new Long[0]));
                if (auditCfgDys == null || auditCfgDys.length == 0) {
                    return;
                }
                HisResponse response = BaseDataHisHelper.batchHisVersionChange((DynamicObject[])auditCfgDys, (boolean)true);
                String errMsg = response.getErrorMessage();
                if (errMsg != null && errMsg.length() > 0) {
                    logger.error("SocInsuranceStandardCfgHelper.updateCfgToHistory: {}", (Object)errMsg);
                    throw new KDBizException(errMsg);
                }
                logger.info("SocInsuranceStandardCfgHelper.updateCfgToHistory: end to update audited data.");
            }
        }
        catch (Exception exception) {
            logger.info("SocInsuranceStandardCfgHelper.updateCfgToHistory, auditCfgIds is {}", JSONObject.toJSON(auditCfgIds));
            logger.error("SocInsuranceStandardCfgHelper.updateCfgToHistory, update audited data failed, error info is :", (Throwable)exception);
            txHandle.markRollback();
            throw exception;
        }
        finally {
            txHandle.close();
        }
        txHandle = TX.requiresNew();
        try {
            SocInsuranceStandardCfgHelper.furtherUpdate();
        }
        catch (Exception exception) {
            logger.error("SocInsuranceStandardCfgHelper.furtherUpdate, update audited data failed, error info is :", (Throwable)exception);
            txHandle.markRollback();
            throw exception;
        }
        finally {
            txHandle.close();
        }
    }

    private static void furtherUpdate() {
        QFilter filter;
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_sinsurstdcfg");
        DynamicObject[] cfgDys = helper.loadDynamicObjectArray((filter = new QFilter("1", "=", (Object)1)).toArray());
        if (cfgDys == null || cfgDys.length == 0) {
            return;
        }
        HashSet<DynamicObject> furtherUpdateCfgDys = new HashSet<DynamicObject>(cfgDys.length);
        for (DynamicObject cfgDy : cfgDys) {
            DynamicObjectCollection resultEntryEntity = cfgDy.getDynamicObjectCollection("rentryentity");
            for (DynamicObject entity : resultEntryEntity) {
                boolean isCalRuleEmpty = HRStringUtils.isEmpty((String)entity.getString("calrule"));
                boolean isCalSrc = "C".equals(entity.getString("datasrc"));
                if (!isCalSrc || !isCalRuleEmpty) continue;
                entity.set("calrule", null);
                entity.set("datasrc", (Object)"R");
                furtherUpdateCfgDys.add(cfgDy);
            }
        }
        helper.updateDatas(furtherUpdateCfgDys.toArray(new DynamicObject[0]));
    }

    private static void updateCurrDy(DynamicObject[] cfgDys) {
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_insuranceprop");
        DynamicObjectCollection itemAttrDys = helper.queryOriginalCollection("id,isuseroundtype,datasrc", new QFilter("1", "=", (Object)1).toArray());
        Map itemAttrDyGroupByPkId = itemAttrDys.stream().filter(itemAttrDy -> itemAttrDy.getLong("id") != 0L).collect(Collectors.toMap(itemAttrDy -> itemAttrDy.getLong("id"), Function.identity(), (oldVal, newVal) -> oldVal));
        for (DynamicObject cfgDy : cfgDys) {
            cfgDy.set("iscurrentversion", (Object)Boolean.TRUE);
            cfgDy.set("ismodify", (Object)Boolean.FALSE);
            if ("C".equals(cfgDy.getString("status"))) {
                cfgDy.set("datastatus", (Object)"1");
                cfgDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            } else {
                cfgDy.set("boid", (Object)cfgDy.getLong("id"));
            }
            DynamicObjectCollection dimEntryEntity = cfgDy.getDynamicObjectCollection("dentryentity");
            for (DynamicObject entity : dimEntryEntity) {
                entity.set("entryboid", entity.getPkValue());
            }
            DynamicObjectCollection resultEntryEntity = cfgDy.getDynamicObjectCollection("rentryentity");
            for (DynamicObject entity : resultEntryEntity) {
                entity.set("entryboidren", entity.getPkValue());
                Long itemAttrId = entity.getLong("insuritem.insurancetypeattr.id");
                DynamicObject itemAttrDy2 = (DynamicObject)itemAttrDyGroupByPkId.get(itemAttrId);
                if (itemAttrDy2 == null) continue;
                String roundType = itemAttrDy2.getBoolean("isuseroundtype") ? "1" : "0";
                String dataSrc = itemAttrDy2.getString("datasrc");
                entity.set("isuseroundtype", (Object)roundType);
                boolean isRecoverCalRule = "7".equals(entity.getString("calrule"));
                boolean calRuleIsEmpty = HRStringUtils.isEmpty((String)entity.getString("calrule"));
                if (isRecoverCalRule) {
                    entity.set("calrule", null);
                    entity.set("datasrc", (Object)"R");
                    continue;
                }
                if (!calRuleIsEmpty) {
                    entity.set("datasrc", (Object)"C");
                    continue;
                }
                entity.set("datasrc", (Object)itemAttrDy2.getString("datasrc"));
                if ("C".equals(dataSrc)) continue;
                entity.set("calrule", null);
            }
        }
    }
}

