/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.socinsurance.standardcfg.service;

import com.google.common.collect.HashBasedTable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standardcfg.helper.SocInsuranceStandardCfgHelper;

public class SocInsuranceStandardCfgService {
    private SocInsuranceStandardCfgService() {
    }

    public static SocInsuranceStandardCfgService createInstance() {
        return new SocInsuranceStandardCfgService();
    }

    public QFilter getCommonQFilter(DynamicObject dataEntity, String customKey) {
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        if ("sitbs_welfaretype".equals(customKey)) {
            Set insurTypeIds;
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_sinsurstdcfg");
            QFilter cfgFilter = SInsuranceCommonService.getAuditAndEnableQFilter();
            BaseDataHisHelper.addHisCurrFilter((QFilter)cfgFilter);
            DynamicObjectCollection cfgDys = helper.queryOriginalCollection("insurtype.id", cfgFilter.toArray());
            Set set = insurTypeIds = cfgDys != null ? cfgDys.stream().map(cfgDy -> cfgDy.getLong("insurtype.id")).collect(Collectors.toSet()) : Collections.emptySet();
            if (!insurTypeIds.isEmpty()) {
                filter.and("id", "not in", insurTypeIds);
            }
        } else if ("sitbs_insuranceitem".equals(customKey)) {
            filter.and("group", "in", (Object)dataEntity.getLong("insurtype.id"));
        }
        filter.and("country", "=", (Object)dataEntity.getLong("country.id"));
        return filter;
    }

    public List<String> getErrorInfoList(DynamicObjectCollection resultEntryEntity) {
        if (CollectionUtils.isEmpty((Collection)resultEntryEntity)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> errInfoList = new ArrayList<String>(10);
        for (DynamicObject resultEntry : resultEntryEntity) {
            if (!"C".equals(resultEntry.getString("datasrc")) || !HRStringUtils.isEmpty((String)resultEntry.getString("calrule"))) continue;
            Integer seq = resultEntry.getInt("seq");
            String errorInfo = MessageFormat.format(SocInsuranceErrInfoEnum.STANDARD_CFG_CAL_RULE.getErrInfo(), seq);
            errInfoList.add(errorInfo);
        }
        return errInfoList;
    }

    public Map<ExtendedDataEntity, String> getRepetitiveExtendedDataEntity(ExtendedDataEntity[] dataEntities) {
        HashBasedTable countryInsurTypeAndExEntityMap = HashBasedTable.create();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject cfgInfoDy = dataEntity.getDataEntity();
            if (!"C".equals(cfgInfoDy.getString("status"))) continue;
            long countryId = cfgInfoDy.getLong("country.id");
            long insurTypeId = cfgInfoDy.getLong("insurtype.id");
            if (countryInsurTypeAndExEntityMap.get((Object)countryId, (Object)insurTypeId) != null) continue;
            countryInsurTypeAndExEntityMap.put((Object)countryId, (Object)insurTypeId, (Object)cfgInfoDy.getString("name"));
        }
        if (!countryInsurTypeAndExEntityMap.isEmpty()) {
            List<DynamicObject> insurCfgDys = SocInsuranceStandardCfgHelper.queryRepetitiveExtendedDataEntity((HashBasedTable<Long, Long, String>)countryInsurTypeAndExEntityMap);
            for (DynamicObject insurCfgDy : insurCfgDys) {
                long countryId = insurCfgDy.getLong("country.id");
                long insurTypeId = insurCfgDy.getLong("insurtype.id");
                countryInsurTypeAndExEntityMap.put((Object)countryId, (Object)insurTypeId, (Object)insurCfgDy.getString("name"));
            }
        }
        LinkedHashMap<ExtendedDataEntity, String> errExtendedDataEntityMap = new LinkedHashMap<ExtendedDataEntity, String>(dataEntities.length);
        if (!countryInsurTypeAndExEntityMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject insurCfgDy = dataEntity.getDataEntity();
                String currInsurCfgName = insurCfgDy.getString("name");
                long countryId = insurCfgDy.getLong("country.id");
                long insurTypeId = insurCfgDy.getLong("insurtype.id");
                String storeInsurCfgName = (String)countryInsurTypeAndExEntityMap.get((Object)countryId, (Object)insurTypeId);
                if (storeInsurCfgName == null || HRStringUtils.equals((String)currInsurCfgName, (String)storeInsurCfgName)) continue;
                String errInfo = SocInsuranceErrInfoEnum.ENABLE_INSUR_CFG_REPETITIVE.getErrInfo(insurCfgDy.getString("insurtype.name"), storeInsurCfgName);
                errExtendedDataEntityMap.put(dataEntity, errInfo);
            }
        }
        return errExtendedDataEntityMap;
    }
}

