/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.spi;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.sitbs.business.tax.basic.TaxBasicInfoQueryService;
import kd.sdk.sit.sitbs.entity.TaxItemEntity;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;

public class TaxBasicInfoQueryServiceImpl
implements TaxBasicInfoQueryService {
    public Map<Long, TaxItemEntity> queryTaxItems(List<Long> itemIds) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxitem", (String[])new String[]{"id", "number", "name", "dataround", "datatype", "datalength", "caltaxtype"}).subProp("dataprecision", new String[]{"scale"}).subProp("currency", new String[]{"amtprecision"});
        DynamicObject[] query = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{new QFilter("id", "in", itemIds)});
        LinkedHashMap<Long, TaxItemEntity> result = new LinkedHashMap<Long, TaxItemEntity>(query.length);
        for (DynamicObject obj : query) {
            result.put(obj.getLong("id"), TaxItemEntity.fromDyObj((DynamicObject)obj));
        }
        return result;
    }

    public DynamicObjectCollection queryTaxPeriods(Long periodType, Date startDate, Date endDate) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (null == periodType || null == startDate || endDate == null) {
            return dynamicObjects;
        }
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxperiod", (String[])new String[]{"id", "taxperiodprg", "startdate", "enddate", "declarestartdate", "declareenddate", "perioddate", "name", "number"});
        HRBaseServiceHelper periodPrgHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter filter = new QFilter("taxperiodprg.id", "=", (Object)periodType);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate);
        dateFilter.and("enddate", ">=", (Object)startDate);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] dys = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{filter, dateFilter, statusFilter});
        Arrays.stream(dys).forEach(arg_0 -> ((DynamicObjectCollection)dynamicObjects).add(arg_0));
        return dynamicObjects;
    }
}

