/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.service.formula.FormulaParseService;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.api.FormulaNodeItemBuilder;
import kd.sit.sitbp.business.formula.builder.BaseFormulaNodeItemBuilder;
import kd.sit.sitbp.common.api.TaxCalItemUniCodeResolver;
import kd.sit.sitbp.common.api.TaxItemService;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BizServiceFactory;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ItcFormulaDataUpGrade23330Task
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ItcFormulaDataUpGrade23330Task.class);
    private static final long CHINA_COUNTRY_ID = 1000001L;
    private static final String APP_ID = "17/+CT1QBPNP";
    private static final String APP_NUMBER = "itc";
    private static final int batchNum = 500;
    private final HRBaseServiceHelper taxCalFormulaHelper = new HRBaseServiceHelper("sitbs_taxcalformula");
    private final TaxItemService taxItemService = (TaxItemService)BizServiceFactory.lookup((String)"TaxItemService");
    private final HRBaseServiceHelper dataGradeHelper = new HRBaseServiceHelper("sitbs_datagrade");
    private final FormulaParseService parseService = new FormulaParseService();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter qFilter = new QFilter("country.id", "=", (Object)1000001L);
        Object[] formulaObjs = this.taxCalFormulaHelper.query("id", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])formulaObjs)) {
            return;
        }
        ArrayList<Long> fidList = new ArrayList<Long>(formulaObjs.length);
        for (Object obj : formulaObjs) {
            fidList.add(obj.getLong("id"));
        }
        boolean isunittest = MapUtils.isNotEmpty(map) && ObjectUtils.isNotEmpty((Object)map.get("unittest"));
        ListUtils.partition(fidList, (int)500).forEach(list -> this.updataCalFormula((List<Long>)list, isunittest));
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private void updataCalFormula(List<Long> fidList, boolean isunittest) {
        LOGGER.info("updataCalFormula fidList is:{} ", fidList);
        DynamicObject[] formulaObjs = this.taxCalFormulaHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", fidList)});
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(formulaObjs.length);
        for (DynamicObject obj : formulaObjs) {
            long taxcategoryid = obj.getLong("taxcategory.id");
            List<TreeNodeItem> treeNodeItems = this.getAllTreeNodeList(taxcategoryid);
            List<ResultItem> resultItems = this.getResultItemList(taxcategoryid);
            List<TreeNodeItem> dataGradeItems = this.getDataGrade(taxcategoryid);
            DynamicObject resultItemObj = obj.getDynamicObject("resultitem");
            if (!Objects.isNull(resultItemObj)) {
                resultItemObj.set("itemcategory", (Object)"TI");
            }
            try {
                if (isunittest) continue;
                DynamicObject newFormula = this.parseService.parseFormulaDy(obj, obj.getLong("boid"), APP_NUMBER, treeNodeItems, resultItems, dataGradeItems, false);
                newList.add(newFormula);
            }
            catch (Exception ex) {
                LOGGER.error("ItcFormulaDataUpGrade23330Task invoke FormulaParseService fail,formula id is:{},boid is:{},number is:{}, Exception:{}", new Object[]{obj.getLong("id"), obj.getLong("boid"), obj.getString("number"), ex});
            }
        }
        if (!CollectionUtils.isEmpty(newList)) {
            try (TXHandle tx = TX.requiresNew();){
                this.taxCalFormulaHelper.update(this.toArray(newList));
            }
        }
    }

    private DynamicObject[] toArray(List<DynamicObject> list) {
        DynamicObject[] newList = new DynamicObject[list.size()];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            newList[i] = list.get(i);
            sb.append(',').append(list.get(i).getString("number"));
        }
        LOGGER.info("taxCalFormulaHelper.update number is:{} ", (Object)sb.toString());
        return newList;
    }

    private List<TreeNodeItem> getAllTreeNodeList(long category) {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        HashMap cond = new HashMap(0);
        ArrayList copyBuilders = Lists.newArrayList(BaseFormulaNodeItemBuilder.getInstances().values());
        copyBuilders.sort(Comparator.comparingInt(os -> os.seq(Long.valueOf(1000001L), APP_NUMBER, Long.valueOf(category), cond)));
        for (FormulaNodeItemBuilder builder : copyBuilders) {
            List treeNodeItem;
            if (!builder.match(Long.valueOf(1000001L), APP_NUMBER, Long.valueOf(category), cond) || CollectionUtils.isEmpty((Collection)(treeNodeItem = builder.rootWithAllNode(Long.valueOf(1000001L), APP_NUMBER, Long.valueOf(category), cond)))) continue;
            treeNodeItems.addAll(treeNodeItem);
        }
        return treeNodeItems;
    }

    private List<ResultItem> getResultItemList(long taxCategoryId) {
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(10);
        Map taxItems = this.taxItemService.loadTaxItems(1000001L, taxCategoryId, 0L, true, new QFilter[0]);
        for (Map.Entry entry : taxItems.entrySet()) {
            TaxItemEntity item = (TaxItemEntity)entry.getValue();
            ResultItem resultItem = new ResultItem();
            String id = item.getId() + "";
            String uniCode = TaxCalItemUniCodeResolver.getResolverBy((String)"TI").uniCode(id);
            resultItem.setId(id);
            resultItem.setUniqueCode(uniCode);
            resultItem.setParentId("TI");
            resultItem.setItemCategory("TI");
            resultItem.setName(LocaleString.fromMap((Map)item.getName()).getLocaleValue());
            resultItem.setDataType(CalDataTypeEnum.getEnumById((long)item.getDatatypeId()));
            resultItem.setCustomItem(false);
            resultItem.setGlobalEffect(true);
            resultItem.setCalProportionItem(false);
            resultItem.setScale(Integer.valueOf(item.getDataPrecisionScale()));
            int dataLength = item.getDataLength();
            if (0 == dataLength) {
                SitDataTypeEnum enumById = SitDataTypeEnum.getEnumById((long)item.getDatatypeId());
                resultItem.setDataLength(Integer.valueOf(enumById.getDefLen()));
            } else {
                resultItem.setDataLength(Integer.valueOf(dataLength));
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private List<TreeNodeItem> getDataGrade(long taxCategoryId) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        QFilter filter = new QFilter("country.id", "=", (Object)1000001L);
        filter.and("uniquecode", "!=", (Object)"0");
        filter.and("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
        Object[] objs = this.dataGradeHelper.query("id,boid,number,name,description,datagradeparam,uniquecode,status,enable,iscurrentversion,datastatus,uniquecode", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])objs)) {
            return resultList;
        }
        Map<Long, DynamicObject> idToObjMap = Arrays.stream(objs).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj, (k1, k2) -> k1));
        for (Object obj2 : objs) {
            resultList.add((TreeNodeItem)DataGradeItem.getDataGradeItem((DynamicObject)obj2));
        }
        for (TreeNodeItem item : resultList) {
            Object obj2;
            String idStr = item.getId();
            obj2 = idToObjMap.get(Long.valueOf(idStr));
            if ("C".equals(obj2.getString("status")) && "1".equals(obj2.getString("enable")) && "1".equals(obj2.getString("datastatus")) && !YesOrNoEnum.NO.getCode().equals(obj2.getString("iscurrentversion"))) continue;
            item.setShow(false);
        }
        return resultList;
    }
}

