/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.SITDbUtil;

public class SITCalRuleCtrlUpdateTask
extends AbstractTask {
    public static final String ORG = "org";
    public static final String CREATE_ORG_ID = "createorg.id";
    public static final String USE_ORG = "useorg";
    public static final String VERSION_SOURCE = "versionsource";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper calRuleHelper = new HRBaseServiceHelper("sitbs_calrule");
        QFilter filter = new QFilter(CREATE_ORG_ID, "!=", (Object)0L);
        Object[] dys = calRuleHelper.query("id,org,useorg,createorg,ctrlstrategy,versionsource", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            this.disableTask();
            return;
        }
        HashMap idAndcreateorgIdmap = Maps.newHashMapWithExpectedSize((int)dys.length);
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (Object dy : dys) {
            idAndcreateorgIdmap.put(dy.getLong("id"), dy.getLong(CREATE_ORG_ID));
            Object createorg = dy.get("createorg");
            if (null != dy.get(ORG) && null != dy.get(USE_ORG) && StringUtils.isNotEmpty((String)dy.getString("ctrlstrategy"))) continue;
            if (null == dy.get(ORG)) {
                dy.set(ORG, createorg);
            }
            if (null == dy.get(USE_ORG)) {
                dy.set(USE_ORG, createorg);
            }
            if (StringUtils.isEmpty((String)dy.getString("ctrlstrategy"))) {
                dy.set("ctrlstrategy", (Object)"5");
            }
            if (StringUtils.isEmpty((String)dy.getString(VERSION_SOURCE))) {
                dy.set(VERSION_SOURCE, (Object)EnumHisVersionSource.CHANGE.getType());
            }
            updateList.add(dy);
        }
        String querySql = "select fdataid from t_sitbs_calrule_u";
        Set calRuleIdSet = (Set)DB.query((DBRoute)SITConstants.SIT_ROUTE, (String)querySql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> idSet = new HashSet<Long>(16);
                while (rs.next()) {
                    long id = rs.getLong(1);
                    idSet.add(id);
                }
                return idSet;
            }
        });
        String queryUserregSql = "select fdataid from t_sitbs_calruleusereg";
        Set userRegCalRuleIdSet = (Set)DB.query((DBRoute)SITConstants.SIT_ROUTE, (String)queryUserregSql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> idSet = new HashSet<Long>(16);
                while (rs.next()) {
                    long id = rs.getLong(1);
                    idSet.add(id);
                }
                return idSet;
            }
        });
        ArrayList<Object[]> saveList = new ArrayList<Object[]>(idAndcreateorgIdmap.size());
        ArrayList<Object[]> saveUserRegList = new ArrayList<Object[]>(idAndcreateorgIdmap.size());
        for (Map.Entry entry : idAndcreateorgIdmap.entrySet()) {
            Object[] saveObj;
            Long value = (Long)entry.getValue();
            Long key = (Long)entry.getKey();
            if (!calRuleIdSet.contains(key)) {
                saveObj = new Object[]{key, value};
                saveList.add(saveObj);
            }
            if (userRegCalRuleIdSet.contains(key)) continue;
            saveObj = new Object[]{key, value, value, "5", YesOrNoEnum.NO.getCode(), 0L};
            saveUserRegList.add(saveObj);
        }
        if (saveList.size() == 0 && updateList.size() == 0 && saveUserRegList.size() == 0) {
            this.disableTask();
            return;
        }
        String insertSql = "insert into t_sitbs_calrule_u(fdataid, fuseorgid) values(?,?)";
        String saveUserRegInsertSql = "insert into t_sitbs_calruleusereg(fdataid, fuseorgid, fcreateorgid, fctrlstrategy, fisassign, fadminorgid) values(?,?,?,?,?,?)";
        try (TXHandle tx = TX.requiresNew();){
            if (updateList.size() > 0) {
                calRuleHelper.update(updateList.toArray(new DynamicObject[0]));
            }
            if (saveList.size() > 0) {
                SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql, saveList);
            }
            if (saveUserRegList.size() > 0) {
                SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)saveUserRegInsertSql, saveUserRegList);
            }
        }
        this.disableTask();
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

