/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.taxitemlibrary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class TaxItemHelper {
    public static Map<Long, String> getAllCountryData(QFilter qFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_appcountryrel");
        String selectFields = "id,country.id,country.name";
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        if (null != qFilter) {
            auditFilter.and(qFilter);
        }
        DynamicObject[] dynamicObjects = helper.query(selectFields, new QFilter[]{enableFilter, auditFilter});
        HashMap<Long, String> countryMap = new HashMap<Long, String>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long countryId = dynamicObject.getLong("country.id");
            if (countryId == 0L) continue;
            countryMap.put(countryId, dynamicObject.getString("country.name"));
        }
        return countryMap;
    }

    public static List<DynamicObject> getAllTaxItemTypes(QFilter qFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitemtype");
        String selectFields = "id,name,country.id,country.name,parent.id,parent.name,longnumber,index";
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        if (null != qFilter) {
            auditFilter.and(qFilter);
        }
        DynamicObject[] dynamicObjects = helper.query(selectFields, new QFilter[]{enableFilter, auditFilter});
        List<DynamicObject> results = Arrays.stream(dynamicObjects).sorted(new dyComparator()).collect(Collectors.toList());
        return results;
    }

    public static DynamicObject getTaxItemTypeDy(String currentNodeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitemtype");
        String selectFields = "id,name,country.id,country.name,parent.id,parent.name,issyspreset";
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(currentNodeId));
        return helper.queryOne(selectFields, new QFilter[]{enableFilter, auditFilter, idFilter});
    }

    public static boolean checkHasDatas(List<Long> childIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter typeFilter = new QFilter("taxitemtype.id", "in", childIds);
        return helper.isExists(new QFilter[]{typeFilter});
    }

    public static void deleteTaxItemTypesByTypeIds(List<Long> childIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitemtype");
        QFilter qFilter = new QFilter("id", "in", childIds);
        helper.deleteByFilter(new QFilter[]{qFilter});
    }

    public static Map<String, String> getAllTaxItemTypeAndCountry() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitemtype");
        DynamicObject[] taxItemTypes = helper.query("number,country.number", null);
        HashMap<String, String> taxItemTypesMap = new HashMap<String, String>(taxItemTypes.length);
        for (DynamicObject taxItemType : taxItemTypes) {
            String taxItemTypeNum = taxItemType.getString("number");
            String countryNum = taxItemType.getString("country.number");
            taxItemTypesMap.put(taxItemTypeNum, countryNum);
        }
        return taxItemTypesMap;
    }

    public static Map<String, String> getAllTaxCategoryAndCountry() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcategory");
        DynamicObject[] taxCategories = helper.query("number,country.number", null);
        HashMap<String, String> taxCategoriesMap = new HashMap<String, String>(taxCategories.length);
        for (DynamicObject taxCategory : taxCategories) {
            String taxSrcItemTypeNum = taxCategory.getString("number");
            String countryNum = taxCategory.getString("country.number");
            taxCategoriesMap.put(taxSrcItemTypeNum, countryNum);
        }
        return taxCategoriesMap;
    }

    public static Set<Long> getAllTaxCategoryMapHasIncomeItem(Set<Long> excludeTaxItemIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter qFilter = new QFilter("incomeitem", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter idFilter = new QFilter("id", "not in", excludeTaxItemIds);
        Object[] taxItemDys = helper.query("id,taxcategories", new QFilter[]{qFilter, idFilter});
        if (ArrayUtils.isEmpty((Object[])taxItemDys)) {
            return ImmutableSet.of();
        }
        HashSet taxCategoryIdSet = Sets.newHashSetWithExpectedSize((int)(taxItemDys.length * 5));
        for (Object taxItemDy : taxItemDys) {
            DynamicObjectCollection taxCategoryDys = taxItemDy.getDynamicObjectCollection("taxcategories");
            Set taxCategoryIdsTmp = taxCategoryDys.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taxCategoryIdSet.addAll(taxCategoryIdsTmp);
        }
        return taxCategoryIdSet;
    }

    public static Set<Long> getAllTaxItemsReferredInTaxTaskSnapShot(String appId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        sql.append(" DISTINCT");
        sql.append(" FBASEDATAID fbasedataid");
        sql.append(" FROM T_");
        sql.append(appId.toUpperCase(Locale.ENGLISH));
        sql.append("_TAXITEMSNAP");
        Set taxItemIds = (Set)HRDBUtil.query((DBRoute)SITConstants.SIT_ROUTE, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> taxItemIds = new HashSet<Long>(16);
                while (rs.next()) {
                    taxItemIds.add(rs.getLong("fbasedataid"));
                }
                return taxItemIds;
            }
        });
        return taxItemIds;
    }

    public static List<DynamicObject> getAllAuditedAndEnableTaxItemsBy(Long countryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter countryFilter = new QFilter("country.id", "=", (Object)countryId);
        Object[] taxItemDys = helper.query("id,number,name", new QFilter[]{enableFilter, auditFilter, countryFilter});
        if (ArrayUtils.isEmpty((Object[])taxItemDys)) {
            return ImmutableList.of();
        }
        return Arrays.stream(taxItemDys).collect(Collectors.toList());
    }

    static class dyComparator
    implements Comparator<DynamicObject> {
        dyComparator() {
        }

        @Override
        public int compare(DynamicObject d1, DynamicObject d2) {
            int d2Index;
            int d2Level;
            int d1Level = d1.getString("longnumber").split("\\.").length;
            int div = d1Level - (d2Level = d2.getString("longnumber").split("\\.").length);
            if (div != 0) {
                return div;
            }
            int d1Index = d1.getInt("index");
            div = d1Index - (d2Index = d2.getInt("index"));
            if (div != 0) {
                return div;
            }
            String d1Name = d1.getString("name");
            String d2Name = d2.getString("name");
            return d1Name.compareTo(d2Name);
        }
    }
}

