/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.taxitemlibrary;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.multiview.GetAppInfoService;
import kd.sit.sitbs.common.taxitemlibrary.TaxItemLibraryConstants;

public class TaxLibraryHelper {
    private static final String FIELD_COUNTRYTYPE_GENERAL = "0";
    private static final String FIELD_COUNTRYTYPE_ASSIGN = "1";

    public static void setCurrency(IFormView view, Long dataTypeId) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String countryType = dataEntity.getString("countrytype");
        String countryId = dataEntity.getString("country.id");
        if (!HRStringUtils.isEmpty((String)countryId) && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType)) {
            String currencyId = TaxLibraryHelper.queryCurrencyByCountryId(countryId);
            TaxLibraryHelper.ctrlFieldVisible(view, dataTypeId, currencyId);
        } else {
            view.getModel().setValue("currency", null);
            view.setVisible(Boolean.FALSE, new String[]{"currency"});
        }
    }

    public static void ctrlCalTaxTypeVisible(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String countryType = dataEntity.getString("countrytype");
        String countryId = dataEntity.getString("country.id");
        if (!HRStringUtils.isEmpty((String)countryId) && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType) && HRStringUtils.equals((String)"1000001", (String)countryId)) {
            view.setVisible(Boolean.TRUE, new String[]{"caltaxtype"});
            BasedataEdit calTaxTypeCtl = (BasedataEdit)view.getControl("caltaxtype");
            calTaxTypeCtl.setMustInput(true);
        } else {
            view.getModel().setValue("caltaxtype", null);
            view.setVisible(Boolean.FALSE, new String[]{"caltaxtype"});
        }
    }

    public static String getAppKey(IFormView view) {
        String appKey = (String)view.getParentView().getFormShowParameter().getCustomParam("appKey");
        if (HRStringUtils.isEmpty((String)appKey)) {
            appKey = null;
        }
        return appKey;
    }

    public static String getAppId(IFormView view) {
        String parentPageId = view.getParentView().getPageId();
        String appId = view.getServiceAppId(parentPageId);
        return appId;
    }

    public static String getDataByPageCache(IFormView view, String key) {
        String value = null;
        String checkRightAppId = view.getFormShowParameter().getCheckRightAppId();
        Map<String, String> appInfo = GetAppInfoService.getInstance().getAppInfo(checkRightAppId, "sitbs_appcountryrel");
        if (null != appInfo) {
            value = HRStringUtils.equals((String)"countryid", (String)key) || HRStringUtils.equals((String)"currencyid", (String)key) ? ((value = appInfo.get(key)) == null ? FIELD_COUNTRYTYPE_GENERAL : value) : appInfo.get(key);
        }
        return value;
    }

    public static void ctrlFieldVisible(IFormView view, Long dataTypeId, String currencyId) {
        IDataModel dataModel = view.getModel();
        if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId.longValue()) {
            dataModel.setValue("currency", (Object)currencyId);
            view.setVisible(Boolean.TRUE, new String[]{"currency"});
            view.setEnable(Boolean.FALSE, new String[]{"currency"});
        } else {
            dataModel.setValue("currency", null);
            view.setVisible(Boolean.FALSE, new String[]{"currency"});
        }
    }

    public static String queryCurrencyByCountryId(String countryId) {
        String currencyId = null;
        if (null != countryId) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_appcountryrel");
            QFilter qFilter = new QFilter("country.id", "=", (Object)Long.valueOf(countryId));
            DynamicObject[] dynamicObjects = serviceHelper.query("currency.id", new QFilter[]{qFilter});
            currencyId = dynamicObjects[0].getString("currency.id");
        }
        return currencyId;
    }

    public static void setCountryVisible(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String countryType = dataEntity.getString("countrytype");
        if (FIELD_COUNTRYTYPE_GENERAL.equals(countryType)) {
            view.setVisible(Boolean.FALSE, new String[]{"country"});
            view.getModel().setValue("country", null);
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"country"});
            BasedataEdit countryCtl = (BasedataEdit)view.getControl("country");
            countryCtl.setMustInput(true);
        }
    }

    public static boolean validateTaxCategory(DynamicObjectCollection taxCategories) {
        if (CollectionUtils.isEmpty((Collection)taxCategories)) {
            return false;
        }
        if (taxCategories.size() > 1) {
            return false;
        }
        return taxCategories.size() != 1 || TaxItemLibraryConstants.NORMAL_SALARY_INCOME_ID.longValue() == ((DynamicObject)taxCategories.get(0)).getLong("fbasedataid_id");
    }
}

