/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.taxperiod;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;

public class TaxPeriodHelper {
    public static Map<ExtendedDataEntity, String> validateRepeatDateInDB(List<ExtendedDataEntity> dataEntityList) {
        List<DynamicObject> periodPageList = dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Date minEntityStartDate = TaxPeriodHelper.getPeriodMinOrMaxDate(periodPageList, "startdate", "min");
        Date maxEntityEndDate = TaxPeriodHelper.getPeriodMinOrMaxDate(periodPageList, "enddate", "max");
        Date minDeclareStartDate = TaxPeriodHelper.getPeriodMinOrMaxDate(periodPageList, "declarestartdate", "min");
        Date maxDeclareEndDate = TaxPeriodHelper.getPeriodMinOrMaxDate(periodPageList, "declareenddate", "max");
        long countryId = periodPageList.get(0).getLong("taxperiodprg.country.id");
        String calFrequency = periodPageList.get(0).getString("taxperiodprg.calfrequency.number");
        QFilter countryFilter = new QFilter("taxperiodprg.country", "=", (Object)countryId);
        countryFilter.and("taxperiodprg.calfrequency.number", "=", (Object)calFrequency);
        QFilter entityDateFilter = new QFilter("startdate", "<=", (Object)maxEntityEndDate);
        entityDateFilter.and("enddate", ">=", (Object)minEntityStartDate);
        QFilter declareDateFilter = new QFilter("declarestartdate", "<=", (Object)maxDeclareEndDate);
        declareDateFilter.and("declareenddate", ">=", (Object)minDeclareStartDate);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        DynamicObject[] periods = periodHelper.query("taxperiodprg,startdate,enddate,declarestartdate,declareenddate", new QFilter[]{countryFilter, entityDateFilter.or(declareDateFilter)});
        List<DynamicObject> periodDBList = Arrays.stream(periods).collect(Collectors.toList());
        return TaxPeriodHelper.checkPeriodsOverlapNew(dataEntityList, periodDBList);
    }

    public static Map<ExtendedDataEntity, String> checkPeriodsOverlapNew(List<ExtendedDataEntity> dataEntityList, List<DynamicObject> periodSourceList) {
        if (CollectionUtils.isEmpty(dataEntityList) || CollectionUtils.isEmpty(periodSourceList)) {
            return Collections.emptyMap();
        }
        LinkedHashMap msgMap = Maps.newLinkedHashMapWithExpectedSize((int)dataEntityList.size());
        String formatString = "yyyy/MM/dd";
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        block0: while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            DynamicObject target = dataEntity.getDataEntity();
            Date targetStartDate = target.getDate("startdate");
            Date targetEndDate = target.getDate("enddate");
            Date targetDeclareStartDate = target.getDate("declarestartdate");
            Date targetDeclareEndDate = target.getDate("declareenddate");
            for (DynamicObject source : periodSourceList) {
                String msg;
                Date sourceStartDate = source.getDate("startdate");
                Date sourceEndDate = source.getDate("enddate");
                Date sourceDeclareStartDate = source.getDate("declarestartdate");
                Date sourceDeclareEndDate = source.getDate("declareenddate");
                String periodName = source.getString("taxperiodprg.name");
                long sourceId = source.getLong("id");
                long targetId = target.getLong("id");
                if (targetId != 0L && sourceId == targetId) continue;
                if (targetStartDate != null && targetEndDate != null && sourceStartDate != null && sourceEndDate != null && targetStartDate.getTime() <= sourceEndDate.getTime() && targetEndDate.getTime() >= sourceStartDate.getTime()) {
                    String sourceStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"startdate", (Date)source.getDate("startdate"));
                    String sourceEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"enddate", (Date)source.getDate("enddate"));
                    String targetStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"startdate", (Date)source.getDate("startdate"));
                    String targetEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"enddate", (Date)source.getDate("enddate"));
                    msg = MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5165\u7684\u671f\u95f4\u8d77\u6b62\u65e5\u671f{0}~{1}\u4e0e\u201c{2}\u201d\u7684\u671f\u95f4\u8d77\u6b62\u65e5\u671f{3}~{4}\u51fa\u73b0\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"TaxPeriodHelper_3", (String)"sit-sitbs-business", (Object[])new Object[0]), targetStartDateFormat, targetEndDateFormat, periodName, sourceStartDateFormat, sourceEndDateFormat);
                    msgMap.put(dataEntity, msg);
                    iterator.remove();
                    continue block0;
                }
                if (targetDeclareStartDate == null || targetDeclareEndDate == null || sourceDeclareStartDate == null || sourceDeclareEndDate == null || targetDeclareStartDate.getTime() > sourceDeclareEndDate.getTime() || targetDeclareEndDate.getTime() < sourceDeclareStartDate.getTime()) continue;
                String sourceDeclareStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"declarestartdate", (Date)source.getDate("declarestartdate"));
                String sourceDeclareEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"declareenddate", (Date)source.getDate("declareenddate"));
                String targetDeclareStartDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"declarestartdate", (Date)source.getDate("declarestartdate"));
                String targetDeclareEndDateFormat = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"declareenddate", (Date)source.getDate("declareenddate"));
                msg = MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5165\u7684\u7533\u62a5\u8d77\u6b62\u65e5\u671f{0}~{1}\u4e0e\u201c{2}\u201d\u7684\u7533\u62a5\u8d77\u6b62\u65e5\u671f{3}~{4}\u51fa\u73b0\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"TaxPeriodHelper_2", (String)"sit-sitbs-business", (Object[])new Object[0]), targetDeclareStartDateFormat, targetDeclareEndDateFormat, periodName, sourceDeclareStartDateFormat, sourceDeclareEndDateFormat);
                msgMap.put(dataEntity, msg);
                iterator.remove();
                continue block0;
            }
        }
        return msgMap;
    }

    private static Date getPeriodMinOrMaxDate(List<DynamicObject> taxPeriods, String field, String minOrMax) {
        Date dateResult = new Date();
        Optional<DynamicObject> result = "min".equals(minOrMax) ? taxPeriods.stream().min(Comparator.comparing(period -> period.getDate(field))) : taxPeriods.stream().max(Comparator.comparing(period -> period.getDate(field)));
        if (result.isPresent()) {
            dateResult = result.get().getDate(field);
        }
        return dateResult;
    }

    public static FormShowParameter getBatchGenerateResultForm(CloseCallBack closeCallback, int rowCount, int successCount, int failCount, Date startDate, boolean operationResult, List<String> message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("sitbs_generateresult");
        parameters.setShowTitle(false);
        parameters.setCloseCallBack(closeCallback);
        parameters.setCustomParam("rowCount", (Object)rowCount);
        parameters.setCustomParam("startDate", (Object)startDate);
        parameters.setCustomParam("successCount", (Object)successCount);
        parameters.setCustomParam("failCount", (Object)failCount);
        parameters.setCustomParam("operationResult", (Object)operationResult);
        StringBuilder buf = new StringBuilder();
        if (null != message) {
            int len = message.size();
            for (int index = 0; index < len; ++index) {
                buf.append("<div style='padding:10px;'>").append(message.get(index)).append("</div>");
            }
            parameters.setCustomParam("msg", (Object)buf.toString().trim());
        }
        return parameters;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        return cal.getTime();
    }

    public static Date calRightDate(boolean flag, Date date) {
        date = flag ? TaxPeriodHelper.addMonth(date, 1) : TaxPeriodHelper.getLastDayOfMonth(TaxPeriodHelper.addMonth(date, 1));
        return date;
    }

    public static Date getRightDate(Date monthDateFlag, int day) {
        Date rightDate = day == 31 ? TaxPeriodHelper.getLastDayOfMonth(monthDateFlag) : TaxPeriodHelper.getCompleteDate(monthDateFlag, day - 1);
        return rightDate;
    }

    public static Date addMonth(Date startDate, int month) {
        LocalDateTime localDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(month);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getCompleteDate(Date startMonthDate, int day) {
        LocalDateTime localDateTime = startMonthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusDays(day);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean getRightDateFlag(int day) {
        boolean dayFlag = true;
        if (day == 31) {
            dayFlag = false;
        }
        return dayFlag;
    }

    public static Date getEndDate(int startDay, int endDay, Date startMonthDateFlag) {
        boolean endDayFlag = TaxPeriodHelper.getRightDateFlag(endDay);
        Date endDate = !endDayFlag ? TaxPeriodHelper.getLastDayOfMonth(startMonthDateFlag) : (startDay > endDay ? TaxPeriodHelper.getCompleteDate(TaxPeriodHelper.addMonth(startMonthDateFlag, 1), endDay - 1) : TaxPeriodHelper.getCompleteDate(startMonthDateFlag, endDay - 1));
        return endDate;
    }

    public static Date getDeclareMonthDate(String periodDateUseField, Date startDate, Date endDate) {
        Date declareMonthDate = HRStringUtils.equals((String)"startdate", (String)periodDateUseField) ? startDate : endDate;
        LocalDateTime localDateTime = declareMonthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime firstDayOfMonth = localDateTime.with(TemporalAdjusters.firstDayOfMonth());
        declareMonthDate = TaxPeriodHelper.addMonth(Date.from(firstDayOfMonth.atZone(ZoneId.systemDefault()).toInstant()), 1);
        return declareMonthDate;
    }

    public static void taxPeriodSort(DynamicObjectCollection taxPeriods) {
        taxPeriods.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject smallObj, DynamicObject bigObj) {
                long smallEndDate = smallObj.getDate("enddate").getTime();
                long bigEndDate = bigObj.getDate("enddate").getTime();
                return Long.compare(bigEndDate, smallEndDate);
            }
        });
        for (int index = 0; index < taxPeriods.size(); ++index) {
            ((DynamicObject)taxPeriods.get(index)).set("seq", (Object)(index + 1));
        }
    }

    public static BasedataEntityType getBaseDataEntityType(String entityName, String pkId) {
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dynamicObject = periodHelper.generateDynamicObject((Object)pkId, "number,name");
        return (BasedataEntityType)dynamicObject.getDataEntityType();
    }

    public static Map<Object, BaseDataCheckRefrenceResult> baseDataCheckReference(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }

    public static void setTaxPeriodInfo(DynamicObject[] newTaxPeriods) {
        TaxPeriodHelper.setPeriodNumber(newTaxPeriods);
        for (DynamicObject newTaxPeriod : newTaxPeriods) {
            if (HRStringUtils.isEmpty((String)newTaxPeriod.getString("name"))) {
                newTaxPeriod.set("name", newTaxPeriod.get("number"));
            }
            newTaxPeriod.set("status", (Object)"C");
        }
    }

    private static void setPeriodNumber(DynamicObject[] newTaxPeriods) {
        DynamicObject taxPeriodPrg = newTaxPeriods[0].getDynamicObject("taxperiodprg");
        String periodNumberPrefix = taxPeriodPrg.getString("periodnumberprefix");
        String periodNumberSuffix = taxPeriodPrg.getString("periodnumbersuffix");
        String subjectNumberField = taxPeriodPrg.getString("periodnumbersubject");
        int serialnumberValue = taxPeriodPrg.getInt("serialnumber");
        long periodPrgId = taxPeriodPrg.getLong("id");
        List<DynamicObject> resultTaxPeriods = TaxPeriodHelper.getGeneratePeriodNumberData(periodPrgId, subjectNumberField, newTaxPeriods);
        if (serialnumberValue == 0) {
            for (DynamicObject taxPeriod : resultTaxPeriods) {
                String subjectNumberValue = TaxPeriodHelper.getSubjectNumberValue(taxPeriod, subjectNumberField);
                taxPeriod.set("number", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix));
            }
        } else {
            List<DynamicObject> allTaxPeriods = TaxPeriodHelper.getAllTaxPeriods(periodPrgId, newTaxPeriods);
            HashMap<String, List<DynamicObject>> groupSubjectNumber = TaxPeriodHelper.groupBySubjectNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, resultTaxPeriods);
            for (Map.Entry<String, List<DynamicObject>> entrySet : groupSubjectNumber.entrySet()) {
                String number = entrySet.getKey();
                List<DynamicObject> groupDynamicObject = entrySet.getValue();
                int max = TaxPeriodHelper.getMaxSerialNumber(allTaxPeriods, number);
                TaxPeriodHelper.generatePeriodNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, serialnumberValue, groupDynamicObject, max);
            }
        }
    }

    private static List<DynamicObject> getGeneratePeriodNumberData(long periodPrgId, String subjectNumberField, DynamicObject[] newTaxPeriods) {
        List<Object> resultTaxPeriods = new ArrayList(newTaxPeriods.length);
        HashSet periodIds = Sets.newHashSetWithExpectedSize((int)newTaxPeriods.length);
        for (DynamicObject newTaxPeriod : newTaxPeriods) {
            boolean fromDatabase = newTaxPeriod.getDataEntityState().getFromDatabase();
            if (!fromDatabase) continue;
            periodIds.add((Long)newTaxPeriod.getPkValue());
        }
        if (CollectionUtils.isEmpty((Collection)periodIds)) {
            resultTaxPeriods = Arrays.stream(newTaxPeriods).collect(Collectors.toList());
        } else {
            HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_taxperiod");
            QFilter filter = new QFilter("id", "in", (Object)periodIds);
            DynamicObject[] oldTaxPeriods = periodHelper.query("id,number,perioddate,startdate,enddate", new QFilter[]{filter});
            if (oldTaxPeriods != null && oldTaxPeriods.length != 0) {
                Map<Object, DynamicObject> oldTaxPeriodMap = Arrays.stream(oldTaxPeriods).collect(Collectors.toMap(DataEntityBase::getPkValue, pk -> pk));
                for (DynamicObject taxPeriod : newTaxPeriods) {
                    DynamicObject oldTaxPeriod = oldTaxPeriodMap.get(taxPeriod.getPkValue());
                    if (oldTaxPeriod != null) {
                        String oldSubjectNumberValue;
                        String subjectNumberValue = TaxPeriodHelper.getSubjectNumberValue(taxPeriod, subjectNumberField);
                        if (HRStringUtils.equals((String)subjectNumberValue, (String)(oldSubjectNumberValue = TaxPeriodHelper.getSubjectNumberValue(oldTaxPeriod, subjectNumberField)))) continue;
                        resultTaxPeriods.add(taxPeriod);
                        continue;
                    }
                    resultTaxPeriods.add(taxPeriod);
                }
            } else {
                resultTaxPeriods = Arrays.stream(newTaxPeriods).collect(Collectors.toList());
            }
        }
        return resultTaxPeriods;
    }

    private static List<DynamicObject> getAllTaxPeriods(long taxPeriodPrgId, DynamicObject[] newTaxPeriods) {
        DynamicObject[] oldTaxPeriods = TaxPeriodHelper.getOldTaxPeriods(taxPeriodPrgId);
        ArrayList<DynamicObject> allTaxPeriods = oldTaxPeriods == null || oldTaxPeriods.length == 0 ? new ArrayList<DynamicObject>(16) : Arrays.stream(oldTaxPeriods).collect(Collectors.toList());
        for (DynamicObject newTaxPeriod : newTaxPeriods) {
            if (newTaxPeriod.getDataEntityState().getFromDatabase()) continue;
            allTaxPeriods.add(newTaxPeriod);
        }
        return allTaxPeriods;
    }

    private static DynamicObject[] getOldTaxPeriods(long periodPrgId) {
        HRBaseServiceHelper periodPrgHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter filter = new QFilter("taxperiodprg.id", "=", (Object)periodPrgId);
        return periodPrgHelper.query("id,taxperiodprg,number", new QFilter[]{filter});
    }

    private static void generatePeriodNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, int serialnumberValue, List<DynamicObject> groupDynamicObject, int max) {
        for (DynamicObject dynamicObject : groupDynamicObject) {
            String subjectNumberValue = TaxPeriodHelper.getSubjectNumberValue(dynamicObject, subjectNumberField);
            dynamicObject.set("number", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix + String.format(Locale.ROOT, "%0" + serialnumberValue + "d", ++max)));
        }
    }

    private static int getMaxSerialNumber(List<DynamicObject> taxPeriods, String number) {
        int max = 0;
        for (DynamicObject taxPeriod : taxPeriods) {
            String periodNumber = taxPeriod.getString("number");
            if (!HRStringUtils.isNotEmpty((String)periodNumber) || !HRStringUtils.equals((String)number, (String)periodNumber.substring(0, number.length()))) continue;
            int order = Integer.parseInt(periodNumber.substring(number.length()));
            max = Integer.max(max, order);
        }
        return max;
    }

    private static HashMap<String, List<DynamicObject>> groupBySubjectNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, List<DynamicObject> taxPeriods) {
        HashMap<String, List<DynamicObject>> groupSubjectNumber = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject taxPeriod : taxPeriods) {
            String subjectNumber = TaxPeriodHelper.getSubjectNumberValue(taxPeriod, subjectNumberField);
            String number = periodNumberPrefix + subjectNumber + periodNumberSuffix;
            List groupCalPeriods = groupSubjectNumber.computeIfAbsent(number, key -> new ArrayList(10));
            groupCalPeriods.add(taxPeriod);
        }
        return groupSubjectNumber;
    }

    private static String getSubjectNumberValue(DynamicObject calPeriod, String subjectNumberField) {
        switch (subjectNumberField) {
            case "perioddate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("perioddate"), (String)"yyyyMM");
            }
            case "startdate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("startdate"), (String)"yyyyMMdd");
            }
            case "enddate": {
                return HRDateTimeUtils.format((Date)calPeriod.getDate("enddate"), (String)"yyyyMMdd");
            }
        }
        return "";
    }
}

