/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.business.taxtemplate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.sit.sitbp.common.enums.TaxTemplateImportTaxDataEnum;
import kd.sit.sitbs.business.model.TaxItemEntity;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;
import kd.sit.sitbs.common.taxtemplate.TaxImportExportConstants;
import org.apache.commons.lang3.StringUtils;

public class TaxTemplateHelper {
    public static void initViewStatus(IDataModel model, IFormView view) {
        String scene = model.getDataEntity().getString("scene");
        BasedataEdit country = (BasedataEdit)view.getControl("country");
        country.setMustInput(true);
        if (StringUtils.equals((CharSequence)"3", (CharSequence)scene)) {
            view.setVisible(Boolean.TRUE, new String[]{"taxgroup", "headerlinenumber"});
            BasedataEdit taxGroup = (BasedataEdit)view.getControl("taxgroup");
            taxGroup.setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"scene", "taxcategory", "flexasterisk", "tipslabelap", "labelap"});
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)scene)) {
            view.setVisible(Boolean.TRUE, new String[]{"taxgroup", "headerlinenumber"});
            FieldEdit sceneControl = (FieldEdit)view.getControl("scene");
            sceneControl.setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"taxgroup", "taxcategory", "flexasterisk", "tipslabelap", "labelap"});
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)scene)) {
            view.setVisible(Boolean.TRUE, new String[]{"scene", "flexasterisk", "tipslabelap", "labelap"});
            FieldEdit sceneField = (FieldEdit)view.getControl("scene");
            sceneField.setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"taxcategory", "taxgroup", "headerlinenumber"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"taxcategory"});
            BasedataEdit taxCategory = (BasedataEdit)view.getControl("taxcategory");
            view.setVisible(Boolean.FALSE, new String[]{"taxgroup", "scene", "headerlinenumber"});
            taxCategory.setMustInput(true);
        }
        view.updateView("taxgroup");
        view.updateView("scenetype");
        view.updateView("scene");
        view.updateView("taxcategory");
    }

    public static void initTemplateEntry(IDataModel model, IFormView view) {
        String tmpType = model.getDataEntity().getString("templatetype");
        if (StringUtils.isBlank((CharSequence)tmpType)) {
            return;
        }
        FieldEdit displayName = (FieldEdit)view.getControl("taxdisplayname");
        displayName.setMustInput(true);
        if ("2".equals(tmpType)) {
            view.setVisible(Boolean.FALSE, new String[]{"importfield", "isonly", "nameflex"});
            view.setVisible(Boolean.TRUE, new String[]{"exportfield", "isexport", "ismustinput", "flexasterisk", "labelaptipscontent", "labelaptips"});
            FieldEdit exportField = (FieldEdit)view.getControl("exportfield");
            exportField.setMustInput(true);
            FieldEdit isExport = (FieldEdit)view.getControl("isexport");
            isExport.setMustInput(true);
            FieldEdit isMustinput = (FieldEdit)view.getControl("ismustinput");
            isMustinput.setMustInput(true);
            HashMap<String, Object> advConApCtrl = new HashMap<String, Object>(16);
            advConApCtrl.put("text", "");
            advConApCtrl.put("collapsible", Boolean.FALSE);
            view.updateControlMetadata("advconap", advConApCtrl);
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"importfield", "isonly", "labelap"});
            view.setVisible(Boolean.FALSE, new String[]{"exportfield", "isexport", "ismustinput", "flexasterisk", "labelaptipscontent", "labelaptips"});
            FieldEdit importField = (FieldEdit)view.getControl("importfield");
            importField.setMustInput(true);
            FieldEdit isOnly = (FieldEdit)view.getControl("isonly");
            isOnly.setMustInput(true);
        }
        String scene = model.getDataEntity().getString("scene");
        if ("1".equals(scene)) {
            view.setVisible(Boolean.FALSE, new String[]{"taxitemnumber"});
        }
    }

    public static String getFieldDisplayName(String fieldName) {
        QueryEntityType dataEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxdatabasicquery");
        List selectFields = dataEntityType.getSelectFields();
        for (QuerySelectField qField : selectFields) {
            String alias = qField.getAlias();
            if (!StringUtils.equals((CharSequence)alias, (CharSequence)fieldName)) continue;
            return qField.getDisplayName();
        }
        return null;
    }

    public static String getTaxItemName(String item) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter filter = new QFilter("id", "in", (Object)item);
        DynamicObject dy = helper.queryOne("name", new QFilter[]{filter});
        return dy.getString("name");
    }

    public static FormShowParameter fieldSelectorParam(IDataModel model) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sitbs_fieldselector");
        HashMap<String, String> params = new HashMap<String, String>();
        Set<Long> taxCategoryId = TaxTemplateHelper.setTaxCategoryId(model);
        params.put("taxCategoryId", JSON.toJSONString(taxCategoryId));
        params.put("templateType", model.getDataEntity().getString("templatetype"));
        params.put("scene", model.getDataEntity().getString("scene"));
        params.put("sceneType", model.getDataEntity().getString("scenetype"));
        showParameter.getCustomParams().putAll(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public static Set<Long> setTaxCategoryId(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        String templateType = model.getDataEntity().getString("templatetype");
        HashSet<Long> set = new HashSet<Long>(16);
        if ("2".equals(templateType)) {
            set.add(dataEntity.getLong("taxcategory.id"));
        } else if ("1".equals(templateType)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcategory");
            long taxGroupId = dataEntity.getLong("taxgroup.id");
            DynamicObject[] dynamicObjects = helper.query("id", new QFilter[]{new QFilter("group.id", "=", (Object)taxGroupId)});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return set;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                set.add(dynamicObject.getLong("id"));
            }
        }
        return set;
    }

    public static String fetchGroupKey(DynamicObject dy) {
        return dy.getString("templatetype") + "#" + dy.getString("scenetype") + "#" + dy.getString("scene") + "#" + dy.getString("taxgroup.id") + "#" + dy.getString("taxcategory.id");
    }

    public static List<TaxItemEntity> taxItemCache(String scene, Set<Long> taxCategoryId, String sceneType, IFormView view) {
        HRPageCache pageCache = new HRPageCache(view);
        List<TaxItemEntity> taxitems = new ArrayList<TaxItemEntity>(16);
        if ("1".equals(scene)) {
            return taxitems;
        }
        QFilter qFilter = TaxImportExportTmpDBHelper.addCountryFilter(TaxImportExportConstants.CHINA_FID);
        if ("3".equals(sceneType)) {
            qFilter.and("taxitemtype.id", "=", (Object)TaxImportExportConstants.SPECIAL_ADDITIONAL_ITEM_ID);
        } else {
            qFilter.and("taxcategories.fbasedataid_id", "in", taxCategoryId);
            if ("3".equals(scene)) {
                qFilter.and("caltaxtype.id", "!=", (Object)TaxImportExportConstants.SUBMIT_NUMBER_ID);
            }
        }
        DynamicObject[] dysArrays = TaxImportExportTmpDBHelper.queryTaxitems(qFilter);
        taxitems = TaxTemplateHelper.setTaxItem(dysArrays);
        pageCache.put("sitbs_taxitem_cache", (Object)JSON.toJSONString(taxitems));
        return taxitems;
    }

    public static List<TaxItemEntity> setTaxItem(DynamicObject[] dysArrys) {
        ArrayList<TaxItemEntity> items = new ArrayList<TaxItemEntity>(16);
        if (null == dysArrys || dysArrys.length == 0) {
            return items;
        }
        for (DynamicObject dy : dysArrys) {
            TaxItemEntity item = new TaxItemEntity();
            item.setId(dy.getLong("id"));
            item.setName(dy.getString("name"));
            item.setNumber(dy.getString("number"));
            items.add(item);
        }
        return items;
    }

    public static void taxFielCache(IFormView view) {
        HRPageCache pageCache = new HRPageCache(view);
        String taxfileCache = (String)pageCache.get("itc_taxfilequery_cache", String.class);
        if (StringUtils.isNotBlank((CharSequence)taxfileCache)) {
            return;
        }
        List<QuerySelectField> selectFields = TaxImportExportTmpDBHelper.queryTaxFileFields();
        pageCache.put("itc_taxfilequery_cache", (Object)JSON.toJSONString(selectFields));
    }

    public static FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    public static boolean judgeTaxItem(Long id, IDataModel model, IFormView view) {
        DynamicObjectCollection dys = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return false;
        }
        for (DynamicObject dy : dys) {
            long taxItemId = dy.getLong("taxitem.id");
            if (id != taxItemId) continue;
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u540c\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"ImportExportTemplateEdit_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean judgeField(String field, IDataModel model, IFormView view) {
        DynamicObjectCollection dys = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return false;
        }
        for (DynamicObject dy : dys) {
            String fieldKey = dy.getString("fieldkey");
            if (!fieldKey.equals(field)) continue;
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u540c\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"ImportExportTemplateEdit_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static void setMustInputItem(IDataModel model, IFormView view) {
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        for (TaxTemplateImportTaxDataEnum value : TaxTemplateImportTaxDataEnum.values()) {
            int rowIndex = model.createNewEntryRow("entryentity");
            String alisName = value.getSystemFieldName().loadKDString();
            String systemFieldNumber = value.getSystemFieldNumber();
            if (value.isTaxItem()) {
                if ("3".equals(model.getDataEntity().get("scenetype"))) {
                    model.deleteEntryRow("entryentity", rowIndex);
                    continue;
                }
                HRPageCache pageCache = new HRPageCache(view);
                String taxItemCache = (String)pageCache.get("sitbs_taxitem_cache", String.class);
                if (StringUtils.isNotBlank((CharSequence)taxItemCache)) {
                    List taxItems = JSON.parseArray((String)taxItemCache, TaxItemEntity.class);
                    ArrayList<TaxItemEntity> matchList = new ArrayList<TaxItemEntity>(16);
                    for (TaxItemEntity taxItemEntity : taxItems) {
                        if (!taxItemEntity.getName().equals(alisName)) continue;
                        model.setValue("taxitem", (Object)taxItemEntity.getId(), rowIndex);
                        model.setValue("ismustinput", (Object)Boolean.TRUE, rowIndex);
                        view.updateView("taxitemnumber", rowIndex, 0);
                        matchList.add(taxItemEntity);
                    }
                    if (CollectionUtils.isEmpty(matchList)) {
                        model.setValue("fieldkey", (Object)alisName, rowIndex);
                    }
                }
            } else {
                model.setValue("fieldkey", (Object)systemFieldNumber, rowIndex);
            }
            if (value.isUniqueCheck()) {
                model.setValue("isonly", (Object)"1", rowIndex);
            }
            String notesDispalyName = ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5339\u914d\u5fc5\u987b\u5b57\u6bb5\uff08\u975e\u5fc5\u586b\uff09", (String)"TaxTemplateHelper_2", (String)"sit-sitbs-business", (Object[])new Object[0]);
            if (value.isMustInput()) {
                model.setValue("ismustinput", (Object)Boolean.TRUE, rowIndex);
                notesDispalyName = ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5339\u914d\u5fc5\u987b\u5b57\u6bb5\uff08\u5fc5\u586b\uff09", (String)"TaxTemplateHelper_3", (String)"sit-sitbs-business", (Object[])new Object[0]);
            }
            model.setValue("taxdisplayname", (Object)alisName, rowIndex);
            model.setValue("importfield", (Object)alisName, rowIndex);
            model.setValue("notes", (Object)notesDispalyName, rowIndex);
            grid.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"taxdisplayname"});
            grid.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"notes"});
        }
    }

    public static void setDisplayName(IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection dys = model.getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dys)) {
            for (DynamicObject dy : dys) {
                String field = dy.getString("fieldkey");
                DynamicObject item = dy.getDynamicObject("taxitem");
                String displayName = null;
                if (StringUtils.isNotBlank((CharSequence)field)) {
                    displayName = TaxTemplateHelper.getFieldDisplayName(field);
                } else if (null != item) {
                    displayName = item.getString("name");
                }
                if ("2".equals(dataEntity.getString("templatetype")) && !dy.getBoolean("isexport")) {
                    displayName = ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\u5c06\u5ffd\u7565\u8be5\u5b57\u6bb5", (String)"ImportExportTemplateEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                }
                dy.set("taxdisplayname", (Object)displayName);
            }
        }
        view.updateView("entryentity");
    }
}

