/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.accumulator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.TaxCalItemUniCodeResolver;
import kd.sit.sitbs.opplugin.web.accumulator.AccumulatorSaveValidator;

public class AccumulatorSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs ex) {
        List fieldKeys = ex.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("accmenstartdate");
        fieldKeys.add("accmemenddate");
        fieldKeys.add("taxitem");
        fieldKeys.add("accuniquecode");
    }

    public void onAddValidators(AddValidatorsEventArgs ex) {
        ex.addValidator((AbstractValidator)new AccumulatorSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs ex) {
        DynamicObject[] dataEntities = ex.getDataEntities();
        List newObjList = Arrays.stream(dataEntities).filter(obj -> StringUtils.isEmpty((CharSequence)obj.getString("id"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(newObjList)) {
            long[] ids = ORM.create().genLongIds("sitbs_accumulator", newObjList.size());
            for (int i = 0; i < newObjList.size(); ++i) {
                DynamicObject dataEntity = (DynamicObject)newObjList.get(i);
                long id = ids[i];
                dataEntity.set("id", (Object)id);
            }
        }
        TaxCalItemUniCodeResolver uniCodeResolver = TaxCalItemUniCodeResolver.getResolverBy((String)"AC");
        for (DynamicObject acc : dataEntities) {
            if (!StringUtils.isEmpty((CharSequence)acc.getString("accuniquecode"))) continue;
            acc.set("accuniquecode", (Object)uniCodeResolver.uniCode(String.valueOf(acc.getLong("id"))));
        }
    }
}

