/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.calrule;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.sitbs.business.calrule.CalRuleHelper;

public class TaxCategoryAndBsedValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "confirmchange".equals(operateKey) || "enable".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            HashSet<String> taxCategoryIds = new HashSet<String>(dataEntities.length);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.validateTaxcategory(dataEntity, taxCategoryIds);
            }
        }
    }

    private void validateTaxcategory(ExtendedDataEntity dataEntity, Set<String> taxCategoryIds) {
        DynamicObject calRuleDy = dataEntity.getDataEntity();
        DynamicObject taxCategoryDy = calRuleDy.getDynamicObject("taxcategory");
        long taxCategoryId = taxCategoryDy.getLong("id");
        long createOrgId = calRuleDy.getLong("createorg.id");
        String key = taxCategoryId + "-" + createOrgId;
        if (taxCategoryIds.contains(key)) {
            String msg = ResManager.loadKDString((String)"{0}\u5728\u5f53\u524d\u751f\u6548\u65e5\u671f\u5185\uff0c\u521b\u5efa\u7ec4\u7ec7{1}\u4e0b\u5df2\u7ecf\u5b58\u5728\u8ba1\u7b97\u89c4\u5219\u6b63\u5728\u5ba1\u6838\u3002", (String)"TaxCategoryAndBsedValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[]{calRuleDy.getString("taxcategory.name"), calRuleDy.getString("createorg.name")});
            this.addFatalErrorMessage(dataEntity, msg);
        } else {
            long boid = calRuleDy.getLong("boid");
            boolean pass = CalRuleHelper.checkTaxCategoryAndCalrule((long)taxCategoryId, (long)boid, (long)createOrgId);
            if (!pass) {
                String msg = ResManager.loadKDString((String)"{0}\u5728\u5f53\u524d\u751f\u6548\u65e5\u671f\u5185\uff0c\u521b\u5efa\u7ec4\u7ec7{1}\u4e0b\u5df2\u7ecf\u5b58\u5728\u8ba1\u7b97\u89c4\u5219\u3002", (String)"TaxCategoryAndBsedValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[]{calRuleDy.getString("taxcategory.name"), calRuleDy.getString("createorg.name")});
                this.addFatalErrorMessage(dataEntity, msg);
                return;
            }
            taxCategoryIds.add(key);
        }
    }
}

