/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.contribution;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ContrValueRuleSaveValidator
extends AbstractValidator {
    private static final String WP_TYPE = "wptype";
    private static final String VALUE_METHOD = "valuemethod";

    public void validate() {
        HRBaseServiceHelper serviceHelper;
        if (!"save".equals(this.getOperateKey()) && !"submit".equals(this.getOperateKey())) {
            return;
        }
        StringBuilder sbd = new StringBuilder();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet groupIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet groupWelPerIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet welpayerIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet welGroupList = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet currencyNumberList = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet pointNumberList = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            this.checkDataByValueMethod(extendedDataEntity);
            String wpType = extendedDataEntity.getDataEntity().getString(WP_TYPE);
            if (StringUtils.equals((CharSequence)wpType, (CharSequence)"A")) {
                Long groupId = extendedDataEntity.getDataEntity().getLong("group.id");
                if (!groupIdSet.add(groupId)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}:\u8be5\u57fa\u6570\u7c7b\u578b\u5728\u672c\u6b21\u64cd\u4f5c\u4e2d\u5b58\u5728\u591a\u6761\u901a\u7528\u53c2\u4fdd\u5355\u4f4d\u7684\u6570\u636e", (String)"ContrValueRuleSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[]{groupId}));
                    continue;
                }
                groupMap.put(groupId, extendedDataEntity);
                currencyNumberList.add(extendedDataEntity.getDataEntity().getString("number"));
                continue;
            }
            if (!StringUtils.equals((CharSequence)wpType, (CharSequence)"B")) continue;
            Long welfareId = extendedDataEntity.getDataEntity().getLong("welpayer.id");
            Long groupId = extendedDataEntity.getDataEntity().getLong("group.id");
            String string = sbd.append(groupId).append('-').append(welfareId).toString();
            if (!groupWelPerIdSet.add(string)) {
                this.addErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5728\u672c\u6b21\u64cd\u4f5c\u4e2d\u5b58\u5728\u591a\u6761\u57fa\u6570\u7c7b\u578b\u4e3a{0} \u901a\u7528\u53c2\u4fdd\u5355\u4f4d\u4e3a{1} \u7684\u6570\u636e", (String)"ContrValueRuleSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), groupId, welfareId));
                continue;
            }
            welpayerIdSet.add(welfareId);
            welGroupList.add(groupId);
            pointNumberList.add(extendedDataEntity.getDataEntity().getString("number"));
            sbd.setLength(0);
        }
        if (!CollectionUtils.isEmpty((Collection)groupIdSet)) {
            serviceHelper = new HRBaseServiceHelper("sitbs_contrvaluerule");
            QFilter contrTypeFilter = new QFilter(WP_TYPE, "=", (Object)"A");
            contrTypeFilter.and("group.id", "in", (Object)groupIdSet);
            contrTypeFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            contrTypeFilter.and("number", "not in", (Object)currencyNumberList);
            DynamicObject[] contrTypes = serviceHelper.query("group.id, group.name", new QFilter[]{contrTypeFilter});
            if (contrTypes.length == 0) {
                return;
            }
            for (DynamicObject dynamicObject : contrTypes) {
                this.addErrorMessage((ExtendedDataEntity)groupMap.get(dynamicObject.getLong("group.id")), MessageFormat.format(ResManager.loadKDString((String)"{0}:\u8be5\u57fa\u6570\u7c7b\u578b\u5df2\u5b58\u5728\u901a\u7528\u53c2\u4fdd\u5355\u4f4d\u7c7b\u578b\u7684\u57fa\u6570\u53d6\u503c\u89c4\u5219", (String)"ContrValueRuleSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), dynamicObject.getString("group.name")));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)welpayerIdSet)) {
            serviceHelper = new HRBaseServiceHelper("sitbs_contrvaluerule");
            QFilter welpayerFilter = new QFilter(WP_TYPE, "=", (Object)"B");
            welpayerFilter.and("welpayer.id", "in", (Object)welpayerIdSet);
            welpayerFilter.and("group.id", "in", (Object)welGroupList);
            welpayerFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            welpayerFilter.and("number", "not in", (Object)pointNumberList);
            DynamicObject[] welpayerTypes = serviceHelper.query("welpayer.id, group.id", new QFilter[]{welpayerFilter});
            if (welpayerTypes.length == 0) {
                return;
            }
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)welpayerTypes.length);
            for (DynamicObject dynamicObject : welpayerTypes) {
                Set welpayerSet = hashMap.computeIfAbsent(dynamicObject.getLong("group.id"), key -> Sets.newHashSetWithExpectedSize((int)welpayerTypes.length));
                welpayerSet.add(dynamicObject.getLong("welpayer.id"));
            }
            for (DynamicObject dynamicObject : dataEntities) {
                Long welpayerId;
                Long groupId = dynamicObject.getDataEntity().getLong("group.id");
                Set welpayerList = (Set)hashMap.get(groupId);
                if (welpayerList == null || !welpayerList.contains(welpayerId = Long.valueOf(dynamicObject.getDataEntity().getLong("welpayer.id")))) continue;
                String welfareName = dynamicObject.getDataEntity().getString("welpayer.name");
                String groupName = dynamicObject.getDataEntity().getString("group.name");
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u6570\u7c7b\u578b\uff1a{0} \u5728\u53c2\u4fdd\u5355\u4f4d\uff1a{1} \u4e0b\u5df2\u5b58\u5728\u57fa\u6570\u53d6\u503c\u89c4\u5219", (String)"ContrValueRuleSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), groupName, welfareName));
            }
        }
    }

    private void checkDataByValueMethod(ExtendedDataEntity dataEntity) {
        DynamicObject welfare;
        String name;
        BigDecimal fixedValue;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String valueMethod = dynamicObject.getString(VALUE_METHOD);
        String wpType = dynamicObject.getString(WP_TYPE);
        if (StringUtils.equals((CharSequence)"C", (CharSequence)valueMethod) && Objects.isNull(fixedValue = dynamicObject.getBigDecimal("fixedvalue"))) {
            name = dynamicObject.getString("name");
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"{0}:\u53d6\u503c\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u503c\uff0c\u8bf7\u586b\u5199\u56fa\u5b9a\u503c", (String)"ContrValueRuleSaveValidator_4", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), name));
        }
        if (StringUtils.equals((CharSequence)"B", (CharSequence)wpType) && ObjectUtils.isEmpty((Object)(welfare = dynamicObject.getDynamicObject("welpayer")))) {
            name = dynamicObject.getString("name");
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"{0}:\u53c2\u4fdd\u5355\u4f4d\u7c7b\u578b\u4e3a\u6307\u5b9a\uff0c\u8bf7\u586b\u5199\u53c2\u4fdd\u5355\u4f4d", (String)"ContrValueRuleSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), name));
        }
    }
}

