/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.multiview;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class BelongCountryEnableValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> idToEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject temObj = dataEntity.getDataEntity();
            long id = temObj.getLong("id");
            idToEntityMap.put(id, dataEntity);
        }
        this.checkHasSameCountry(idToEntityMap);
        this.checkHasAlreadyUsedCountry(idToEntityMap);
    }

    private void checkHasSameCountry(Map<Long, ExtendedDataEntity> idToEntityMap) {
        HashMap countryIdToEntityMap = new HashMap(idToEntityMap.size());
        for (ExtendedDataEntity dataEntity : idToEntityMap.values()) {
            DynamicObject entity = dataEntity.getDataEntity();
            long countryId = entity.getLong("country.id");
            String businessType = entity.getString("businesstype");
            List entityLists = (List)countryIdToEntityMap.get(countryId + businessType);
            if (null != entityLists) {
                entityLists.add(dataEntity);
                continue;
            }
            ArrayList<ExtendedDataEntity> entityList = new ArrayList<ExtendedDataEntity>(16);
            entityList.add(dataEntity);
            countryIdToEntityMap.put(countryId + businessType, entityList);
        }
        for (List entityList : countryIdToEntityMap.values()) {
            if (entityList.size() <= 1) continue;
            String countryName = ((ExtendedDataEntity)entityList.get(0)).getDataEntity().getString("country.name");
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u591a\u6761\u540d\u79f0\u4e3a{0}\u7684\u56fd\u5bb6/\u5730\u533a\u6570\u636e\u6b63\u5728\u542f\u7528\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BelongCountryEnableValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), countryName);
            for (ExtendedDataEntity extendedDataEntity : entityList) {
                this.addFatalErrorMessage(extendedDataEntity, msg);
                long id = extendedDataEntity.getDataEntity().getLong("id");
                idToEntityMap.remove(id);
            }
        }
    }

    private void checkHasAlreadyUsedCountry(Map<Long, ExtendedDataEntity> idToEntityMap) {
        HashMap<String, ExtendedDataEntity> countryIdToEntityMap = new HashMap<String, ExtendedDataEntity>(idToEntityMap.size());
        for (ExtendedDataEntity entity : idToEntityMap.values()) {
            long countryId = entity.getDataEntity().getLong("country.id");
            String businessType = entity.getDataEntity().getString("businesstype");
            countryIdToEntityMap.put(countryId + businessType, entity);
        }
        Set<String> alreadyUsedCountry = this.getAlreadyUsedCountry();
        for (Map.Entry extendedDataEntityEntry : countryIdToEntityMap.entrySet()) {
            if (!alreadyUsedCountry.contains(extendedDataEntityEntry.getKey())) continue;
            String countryName = ((ExtendedDataEntity)extendedDataEntityEntry.getValue()).getDataEntity().getString("country.name");
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a{0}\u7684\u56fd\u5bb6/\u5730\u533a\u5df2\u88ab\u4f7f\u7528\u3002", (String)"BelongCountryEnableValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), countryName);
            this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntityEntry.getValue(), msg);
        }
    }

    private Set<String> getAlreadyUsedCountry() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_belongcountry");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] dys = helper.query("id, country.id, businesstype", new QFilter[]{enableFilter, auditFilter});
        HashSet<String> countryIds = new HashSet<String>(dys.length);
        for (DynamicObject dy : dys) {
            long countryId = dy.getLong("country.id");
            String businessType = dy.getString("businesstype");
            countryIds.add(countryId + businessType);
        }
        return countryIds;
    }
}

