/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.multiview;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.sitbp.business.multiview.CombinePageCfgHelper;

public class CombinePageCfgCommonValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> belongCountryIdToEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject temObj = dataEntity.getDataEntity();
            long belongCountryId = temObj.getDynamicObject("belongcountry").getLong("id");
            belongCountryIdToEntityMap.put(belongCountryId, dataEntity);
        }
        this.checkAuditedAndEnabledBelongCountry(belongCountryIdToEntityMap);
    }

    private void checkAuditedAndEnabledBelongCountry(Map<Long, ExtendedDataEntity> belongCountryIdToEntityMap) {
        Set usedBelongCountries = CombinePageCfgHelper.getAlreadyUsedBelongCountries();
        for (Map.Entry<Long, ExtendedDataEntity> extendedDataEntityEntry : belongCountryIdToEntityMap.entrySet()) {
            DynamicObject dataEntity = extendedDataEntityEntry.getValue().getDataEntity();
            String status = dataEntity.getString("status");
            String enable = dataEntity.getString("enable");
            if ((!"C".equals(status) || !"0".equals(enable)) && (!"B".equals(status) || !"1".equals(enable)) || !usedBelongCountries.contains(extendedDataEntityEntry.getKey())) continue;
            String belongCountryName = extendedDataEntityEntry.getValue().getDataEntity().getString("belongcountry.name");
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a{0}\u7684\u56fd\u5bb6/\u5730\u533a\u5f52\u5c5e\u5df2\u88ab\u4f7f\u7528\u3002", (String)"CombinePageCfgCommonValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), belongCountryName);
            this.addFatalErrorMessage(extendedDataEntityEntry.getValue(), msg);
        }
    }
}

