/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.nettaxalgo;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbs.opplugin.web.nettaxalgo.NetTaxAlgoSaveValidator;

public class NetTaxAlgoSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs ex) {
        ex.addValidator((AbstractValidator)new NetTaxAlgoSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs ex) {
        DynamicObject[] dataEntities = ex.getDataEntities();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtasksnapshot");
        for (DynamicObject dataEntity : dataEntities) {
            this.updateAlgoInTaxTaskSnapShot(dataEntity, helper);
        }
    }

    private void updateAlgoInTaxTaskSnapShot(DynamicObject dataEntity, HRBaseServiceHelper helper) {
        DynamicObject[] taxTaskSnapShotDys;
        long taxCategoryId = dataEntity.getLong("taxcategory.id");
        String expression = dataEntity.getString("expression");
        QFilter filter = new QFilter("taxtask.taskstatus", "=", (Object)YesOrNoEnum.NO.getCode());
        filter.and(new QFilter("taxtask.taxtaskcatgentry.taxcategory.id", "=", (Object)taxCategoryId));
        filter.and(new QFilter("taxtask.taxtaskcatgentry.taxdatanum", "=", (Object)0));
        for (DynamicObject taxTaskSnapShotDy : taxTaskSnapShotDys = helper.query("id,taxtask,taxtasksnapent.taxcategory,taxtasksnapent.expression", new QFilter[]{filter})) {
            DynamicObjectCollection taxCategoryEntryDys = taxTaskSnapShotDy.getDynamicObjectCollection("taxtasksnapent");
            for (DynamicObject taxCategoryEntryDy : taxCategoryEntryDys) {
                long taxCategoryIdInSnap = taxCategoryEntryDy.getLong("taxcategory.id");
                if (taxCategoryIdInSnap != taxCategoryId) continue;
                taxCategoryEntryDy.set("expression", (Object)expression);
            }
        }
        helper.save(taxTaskSnapShotDys);
    }
}

