/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.nettaxalgo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class NetTaxAlgoSaveValidator
extends AbstractValidator {
    public static final String TAX_CATEGORY = "taxcategory";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> taxCategoryIds = new HashSet<Long>();
        HashMap<Long, ExtendedDataEntity> map = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long catId = dataEntity.getDataEntity().getLong("taxcategory.id");
            if (taxCategoryIds.contains(catId)) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b[%s]\u91cd\u590d\u8bbe\u7f6e\u51c0\u7a0e\u6536\u8ba1\u7b97\u516c\u5f0f", (String)"NetTaxAlgoSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getLong("taxcategory.name"));
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            taxCategoryIds.add(catId);
            map.put(catId, dataEntity);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_nettaxalgo");
        QFilter filter = new QFilter("taxcategory.id", "in", taxCategoryIds);
        Object[] ids = serviceHelper.query("id,taxcategory.id", new QFilter[]{filter});
        if (ArrayUtils.isNotEmpty((Object[])ids)) {
            for (Object id : ids) {
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)map.get(id.get("taxcategory.id"));
                if (dataEntity == null || dataEntity.getDataEntity().getLong("id") == id.getLong("id")) continue;
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b[%s]\u91cd\u590d\u8bbe\u7f6e\u51c0\u7a0e\u6536\u8ba1\u7b97\u516c\u5f0f", (String)"NetTaxAlgoSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getString("taxcategory.name"));
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }
}

